/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBCmdParams;
import org.apache.empire.db.DBCommand;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCmdParamList
implements DBCmdParams {
    protected static final Logger log = LoggerFactory.getLogger(DBCmdParamList.class);
    protected ArrayList<DBCmdParam> cmdParams;
    private int paramUsageCount = 0;

    public DBCmdParamList() {
        this.cmdParams = null;
    }

    public DBCmdParamList(DBCmdParams initial) {
        if (initial.isEmpty()) {
            this.cmdParams = null;
        } else {
            this.cmdParams = new ArrayList(initial.size());
            for (DBCmdParam p : initial) {
                this.cmdParams.add(p);
            }
        }
    }

    public DBCmdParamList(int size) {
        this.cmdParams = size > 0 ? new ArrayList(size) : null;
    }

    @Override
    public boolean isEmpty() {
        return this.cmdParams == null || this.cmdParams.isEmpty();
    }

    @Override
    public int size() {
        return this.cmdParams == null ? 0 : this.cmdParams.size();
    }

    @Override
    public Iterator<DBCmdParam> iterator() {
        if (this.cmdParams == null) {
            throw new NotSupportedException(this, "iterator");
        }
        return this.cmdParams.iterator();
    }

    public void clear(int capacity) {
        this.paramUsageCount = 0;
        this.cmdParams = capacity > 0 ? new ArrayList(capacity) : null;
    }

    public void add(DBCmdParam param) {
        if (this.cmdParams == null) {
            this.cmdParams = new ArrayList();
        }
        this.cmdParams.add(param);
    }

    public void add(DBCommand cmd, DataType type, Object value) {
        this.add(new DBCmdParam(cmd, type, value));
    }

    public void remove(DBCmdParam param) {
        if (this.cmdParams == null || !this.cmdParams.remove(param)) {
            log.warn("Unable to remove DBCmdParam: Param not found");
        }
    }

    public Object[] getParamValues() {
        if (this.cmdParams == null || this.paramUsageCount == 0) {
            return null;
        }
        if (this.paramUsageCount != this.cmdParams.size()) {
            log.info("DBCommand parameter count (" + String.valueOf(this.cmdParams.size()) + ") does not match parameter use count (" + String.valueOf(this.paramUsageCount) + ")");
        }
        Object[] values = new Object[this.paramUsageCount];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.cmdParams.get(i).getValue();
        }
        return values;
    }

    public void resetParamUsage(DBCommand cmd) {
        this.paramUsageCount = 0;
        if (this.cmdParams == null) {
            return;
        }
        for (int i = this.cmdParams.size() - 1; i >= 0; --i) {
            if (this.cmdParams.get(i).getCmd() == cmd) continue;
            this.cmdParams.remove(i);
        }
    }

    public void completeParamUsage(DBCommand cmd) {
        if (this.cmdParams == null) {
            return;
        }
        if (this.paramUsageCount < this.cmdParams.size()) {
            log.warn("DBCommand has {} unused Command params", (Object)(this.cmdParams.size() - this.paramUsageCount));
            for (int i = this.cmdParams.size() - 1; i >= this.paramUsageCount; --i) {
                if (this.cmdParams.get(i).getCmd() == cmd) continue;
                this.cmdParams.remove(i);
            }
        }
    }

    public void mergeSubqueryParams(DBCmdParams subQueryParams) {
        if (subQueryParams == null || subQueryParams.isEmpty()) {
            return;
        }
        if (this.cmdParams == null) {
            this.cmdParams = new ArrayList(subQueryParams.size());
        }
        for (DBCmdParam p : subQueryParams) {
            this.cmdParams.add(this.paramUsageCount++, new DBCmdParam(null, DataType.UNKNOWN, p.getValue()));
        }
    }

    protected void notifyParamUsage(DBCmdParam param) {
        int index = this.cmdParams.indexOf(param);
        if (index < 0) {
            throw new InvalidOperationException("The CmdParam has not been found on this Command.");
        }
        if (index < this.paramUsageCount) {
            log.debug("The DBCmdParam already been used. Adding a temporary copy");
            this.cmdParams.add(this.paramUsageCount, new DBCmdParam(null, param.getDataType(), param.getValue()));
        } else if (index > this.paramUsageCount) {
            this.cmdParams.remove(index);
            this.cmdParams.add(this.paramUsageCount, param);
        }
        ++this.paramUsageCount;
    }
}

