/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.extension;

import jakarta.enterprise.util.Nonbinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.deltaspike.security.api.authorization.SecurityDefinitionException;

class AuthorizationParameter {
    private Type type;
    private Map<Class<? extends Annotation>, Map<Method, Object>> bindings;

    public AuthorizationParameter() {
    }

    AuthorizationParameter(Type type, Set<Annotation> bindings) {
        this.type = type;
        this.bindings = new HashMap<Class<? extends Annotation>, Map<Method, Object>>();
        for (Annotation bindingAnnotation : bindings) {
            HashMap<Method, Object> bindingMembers = new HashMap<Method, Object>();
            try {
                for (Method method : bindingAnnotation.annotationType().getDeclaredMethods()) {
                    if (method.isAnnotationPresent(Nonbinding.class)) continue;
                    bindingMembers.put(method, method.invoke((Object)bindingAnnotation, new Object[0]));
                }
            }
            catch (InvocationTargetException ex) {
                throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new SecurityDefinitionException("Error reading security binding members", (Throwable)ex);
            }
            this.bindings.put(bindingAnnotation.annotationType(), bindingMembers);
        }
    }

    boolean matches(AuthorizationParameter parameter) {
        if (!this.type.equals(parameter.type)) {
            return false;
        }
        for (Map.Entry<Class<? extends Annotation>, Map<Method, Object>> bindingEntry : this.bindings.entrySet()) {
            Map<Method, Object> bindingValues = parameter.bindings.get(bindingEntry.getKey());
            if (bindingValues == null) {
                return false;
            }
            for (Map.Entry<Method, Object> value : bindingEntry.getValue().entrySet()) {
                if (bindingValues.get(value.getKey()).equals(value.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Class<? extends Annotation>, Map<Method, Object>> bindingEntry : this.bindings.entrySet()) {
            builder.append('@').append(bindingEntry.getKey().getName()).append('(');
            for (Map.Entry<Method, Object> value : bindingEntry.getValue().entrySet()) {
                builder.append(value.getKey().getName()).append('=').append(value.getValue()).append(',');
            }
            if (bindingEntry.getValue().isEmpty()) {
                builder.append(')');
                continue;
            }
            builder.setCharAt(builder.length() - 1, ')');
        }
        if (!this.bindings.isEmpty()) {
            builder.append(' ');
        }
        builder.append(this.type);
        return builder.toString();
    }
}

