/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.mock;

import jakarta.enterprise.util.Nonbinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.deltaspike.core.util.ReflectionUtils;

public class BeanCacheKey {
    private static final Comparator<Annotation> ANNOTATION_COMPARATOR = new AnnotationComparator();
    private final Type type;
    private final Annotation qualifier;
    private final Annotation[] qualifiers;
    private final int hashCode;

    public BeanCacheKey(Type type, Annotation ... qualifiers) {
        int length;
        this.type = type;
        int n = length = qualifiers != null ? qualifiers.length : 0;
        if (length == 0) {
            this.qualifier = null;
            this.qualifiers = null;
        } else if (length == 1) {
            this.qualifier = qualifiers[0];
            this.qualifiers = null;
        } else {
            this.qualifier = null;
            this.qualifiers = new Annotation[length];
            System.arraycopy(qualifiers, 0, this.qualifiers, 0, length);
            Arrays.sort(this.qualifiers, ANNOTATION_COMPARATOR);
        }
        this.hashCode = this.computeHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanCacheKey cacheKey = (BeanCacheKey)o;
        if (!this.type.equals(cacheKey.type)) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifierEquals(this.qualifier, cacheKey.qualifier) : cacheKey.qualifier != null) {
            return false;
        }
        return this.qualifierArrayEquals(this.qualifiers, cacheKey.qualifiers);
    }

    private boolean qualifierArrayEquals(Annotation[] qualifiers1, Annotation[] qualifiers2) {
        if (qualifiers1 == qualifiers2) {
            return true;
        }
        if (qualifiers1 == null || qualifiers2 == null) {
            return false;
        }
        if (qualifiers1.length != qualifiers2.length) {
            return false;
        }
        for (int i = 0; i < qualifiers1.length; ++i) {
            Annotation a1 = qualifiers1[i];
            Annotation a2 = qualifiers2[i];
            if (!(a1 == null ? a2 != null : !this.qualifierEquals(a1, a2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int computedHashCode = 31 * ReflectionUtils.calculateHashCodeOfType((Type)this.type);
        if (this.qualifier != null) {
            computedHashCode = 31 * computedHashCode + this.getQualifierHashCode(this.qualifier);
        }
        if (this.qualifiers != null) {
            for (int i = 0; i < this.qualifiers.length; ++i) {
                computedHashCode = 31 * computedHashCode + this.getQualifierHashCode(this.qualifiers[i]);
            }
        }
        return computedHashCode;
    }

    private int getQualifierHashCode(Annotation a) {
        return ReflectionUtils.calculateHashCodeOfAnnotation((Annotation)a, (boolean)true);
    }

    private boolean qualifierEquals(Annotation qualifier1, Annotation qualifier2) {
        return ANNOTATION_COMPARATOR.compare(qualifier1, qualifier2) == 0;
    }

    public String toString() {
        return "BeanCacheKey{type=" + this.type + ", qualifiers=" + (this.qualifiers == null ? this.qualifier : Arrays.asList(this.qualifiers)) + ", hashCode=" + this.hashCode + "}";
    }

    private static class AnnotationComparator
    implements Comparator<Annotation> {
        private AnnotationComparator() {
        }

        @Override
        public int compare(Annotation annotation1, Annotation annotation2) {
            Class<? extends Annotation> type1 = annotation1.annotationType();
            Class<? extends Annotation> type2 = annotation2.annotationType();
            int temp = type1.getName().compareTo(type2.getName());
            if (temp != 0) {
                return temp;
            }
            Method[] member1 = type1.getDeclaredMethods();
            Method[] member2 = type2.getDeclaredMethods();
            int i = 0;
            int j = 0;
            int length1 = member1.length;
            int length2 = member2.length;
            while (true) {
                if (i < length1 && member1[i].isAnnotationPresent(Nonbinding.class)) {
                    ++i;
                    continue;
                }
                while (j < length2 && member2[j].isAnnotationPresent(Nonbinding.class)) {
                    ++j;
                }
                if (i >= length1 && j >= length2) {
                    return 0;
                }
                if (i >= length1) {
                    return 1;
                }
                if (j >= length2) {
                    return -1;
                }
                int c = member1[i].getName().compareTo(member2[j].getName());
                if (c != 0) {
                    return c;
                }
                Object value1 = ReflectionUtils.invokeMethod((Object)annotation1, (Method)member1[i], Object.class, (boolean)true, (Object[])new Object[0]);
                Object value2 = ReflectionUtils.invokeMethod((Object)annotation2, (Method)member2[j], Object.class, (boolean)true, (Object[])new Object[0]);
                assert (value1.getClass().equals(value2.getClass()));
                if (value1 instanceof Comparable) {
                    c = ((Comparable)value1).compareTo(value2);
                    if (c != 0) {
                        return c;
                    }
                } else if (value1.getClass().isArray()) {
                    c = value1.getClass().getComponentType().getName().compareTo(value2.getClass().getComponentType().getName());
                    if (c != 0) {
                        return c;
                    }
                    int length = Array.getLength(value1);
                    c = length - Array.getLength(value2);
                    if (c != 0) {
                        return c;
                    }
                    for (int k = 0; k < length; ++k) {
                        c = ((Comparable)Array.get(value1, k)).compareTo(Array.get(value2, k));
                        if (c == 0) continue;
                        return c;
                    }
                } else if (value1 instanceof Class) {
                    c = ((Class)value1).getName().compareTo(((Class)value2).getName());
                    if (c != 0) {
                        return c;
                    }
                } else assert (false);
                ++i;
                ++j;
            }
        }
    }
}

