/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.spi.descriptor.xml;

import jakarta.enterprise.inject.Vetoed;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.deltaspike.jpa.spi.descriptor.xml.AbstractEntityHierarchyBuilder;
import org.apache.deltaspike.jpa.spi.descriptor.xml.Descriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.DescriptorReader;
import org.apache.deltaspike.jpa.spi.descriptor.xml.EntityDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.EntityMappingsDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.EntityMappingsDescriptorParser;
import org.apache.deltaspike.jpa.spi.descriptor.xml.MappedSuperclassDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.PersistenceUnitDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Vetoed
public class PersistenceUnitDescriptorParser
extends DescriptorReader {
    public static final String RESOURCE_PATH = "META-INF/persistence.xml";
    private final EntityMappingsDescriptorParser entityMappingsDescriptorParser = new EntityMappingsDescriptorParser();

    public List<PersistenceUnitDescriptor> readAll() throws IOException {
        LinkedList<PersistenceUnitDescriptor> result = new LinkedList<PersistenceUnitDescriptor>();
        List<Descriptor> persistenceXmls = this.readAllFromClassPath(RESOURCE_PATH);
        for (Descriptor desc : persistenceXmls) {
            result.addAll(this.lookupUnits(desc));
        }
        return Collections.unmodifiableList(result);
    }

    protected List<PersistenceUnitDescriptor> lookupUnits(Descriptor descriptor) {
        LinkedList<PersistenceUnitDescriptor> result = new LinkedList<PersistenceUnitDescriptor>();
        NodeList list = descriptor.getDocument().getDocumentElement().getElementsByTagName("persistence-unit");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String unitName = this.extractUnitName(node);
            String baseUrl = this.extractBaseUrl(descriptor.getUrl(), RESOURCE_PATH);
            List<EntityDescriptor> entities = this.extractMappings((Element)node, baseUrl, unitName);
            Map<String, String> properties = this.extractProperties((Element)node);
            result.add(new PersistenceUnitDescriptor(unitName, entities, properties));
        }
        return result;
    }

    protected List<EntityDescriptor> extractMappings(Element element, String baseUrl, String unitName) {
        try {
            LinkedList<EntityDescriptor> entities = new LinkedList<EntityDescriptor>();
            LinkedList<MappedSuperclassDescriptor> superClasses = new LinkedList<MappedSuperclassDescriptor>();
            NodeList list = element.getElementsByTagName("mapping-file");
            this.readMappingFiles(baseUrl, unitName, entities, superClasses, list);
            EntityMappingsDescriptor mappings = this.entityMappingsDescriptorParser.readDefaultOrm(baseUrl);
            entities.addAll(mappings.getEntityDescriptors());
            superClasses.addAll(mappings.getMappedSuperclassDescriptors());
            AbstractEntityHierarchyBuilder.buildHierarchy(entities, superClasses);
            return entities;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed initializing mapping files", e);
        }
    }

    protected void readMappingFiles(String baseUrl, String unitName, List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses, NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            String resource = list.item(i).getTextContent();
            try {
                EntityMappingsDescriptor mappings = this.entityMappingsDescriptorParser.readAll(baseUrl, resource);
                entities.addAll(mappings.getEntityDescriptors());
                superClasses.addAll(mappings.getMappedSuperclassDescriptors());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("[PersistenceUnit: " + unitName + "] Unable to resolve named mapping-file [" + resource + "]");
            }
        }
    }

    protected String extractUnitName(Node node) {
        return node.getAttributes().getNamedItem("name").getTextContent();
    }

    protected Map<String, String> extractProperties(Element element) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Node propertiesNode = element.getElementsByTagName("properties").item(0);
        if (propertiesNode != null) {
            NodeList propertyNodes = propertiesNode.getChildNodes();
            for (int i = 0; i < propertyNodes.getLength(); ++i) {
                if (!"property".equals(propertyNodes.item(i).getNodeName())) continue;
                Element propertyNode = (Element)propertyNodes.item(i);
                propertiesMap.put(propertyNode.getAttribute("name"), propertyNode.getAttribute("value"));
            }
        }
        return Collections.unmodifiableMap(propertiesMap);
    }
}

