/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.message;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Specializes;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.util.Iterator;
import java.util.Locale;
import org.apache.deltaspike.core.impl.message.DefaultLocaleResolver;

@ApplicationScoped
@Specializes
public class JsfAwareLocaleResolver
extends DefaultLocaleResolver {
    private static final long serialVersionUID = -8776583393262804931L;

    public Locale getLocale() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && facesContext.getCurrentPhaseId() != null) {
            UIViewRoot viewRoot = facesContext.getViewRoot();
            Locale result = null;
            if (viewRoot != null) {
                result = viewRoot.getLocale();
            }
            if (result != null) {
                Iterator supportedLocale = facesContext.getApplication().getSupportedLocales();
                boolean supportedLocaleConfigured = false;
                while (supportedLocale.hasNext()) {
                    supportedLocaleConfigured = true;
                    if (!result.equals(supportedLocale.next())) continue;
                    return result;
                }
                if (!supportedLocaleConfigured) {
                    return result;
                }
            }
            if ((result = facesContext.getApplication().getDefaultLocale()) != null) {
                return result;
            }
        }
        return super.getLocale();
    }
}

