/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.config.view;

import jakarta.enterprise.util.Nonbinding;
import jakarta.inject.Named;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.deltaspike.core.api.config.view.ViewConfig;
import org.apache.deltaspike.core.api.config.view.controller.ViewControllerRef;
import org.apache.deltaspike.core.api.config.view.metadata.InlineViewMetaData;
import org.apache.deltaspike.core.api.literal.ViewControllerRefLiteral;
import org.apache.deltaspike.core.spi.config.view.InlineMetaDataTransformer;
import org.apache.deltaspike.core.spi.config.view.TargetViewConfigProvider;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@InlineViewMetaData(targetViewConfigProvider=ViewRefTargetViewConfigProvider.class, inlineMetaDataTransformer=ViewRefInlineMetaDataTransformer.class)
public @interface ViewRef {
    @Nonbinding
    public Class<? extends ViewConfig>[] config();

    public static class ViewRefInlineMetaDataTransformer
    implements InlineMetaDataTransformer<ViewRef, ViewControllerRef> {
        @Override
        public ViewControllerRef convertToViewMetaData(ViewRef inlineMetaData, Class<?> sourceClass) {
            Named named = sourceClass.getAnnotation(Named.class);
            String beanName = named == null ? null : named.value();
            return new ViewControllerRefLiteral(sourceClass, beanName);
        }
    }

    public static class ViewRefTargetViewConfigProvider
    implements TargetViewConfigProvider<ViewRef> {
        @Override
        public Class<? extends ViewConfig>[] getTarget(ViewRef inlineMetaData) {
            return inlineMetaData.config();
        }
    }

    public static abstract class Manual
    implements ViewConfig {
    }
}

