/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.config;

import jakarta.enterprise.inject.Vetoed;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.deltaspike.core.api.config.Config;
import org.apache.deltaspike.core.api.config.ConfigSnapshot;
import org.apache.deltaspike.core.spi.config.ConfigFilter;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.util.ClassUtils;

@Vetoed
public final class ConfigResolver {
    public static final String DELTASPIKE_APP_NAME_CONFIG = "deltaspike.application.name";
    public static final String DELTASPIKE_LOG_CONFIG = "deltaspike.config.log";
    private static ConfigProvider configProvider;

    private ConfigResolver() {
    }

    public static Config getConfig() {
        ClassLoader cl = ClassUtils.getClassLoader(null);
        return ConfigResolver.getConfig(cl);
    }

    public static Config getConfig(ClassLoader cl) {
        return ConfigResolver.getConfigProvider().getConfig(cl);
    }

    public static synchronized void addConfigSources(List<ConfigSource> configSourcesToAdd) {
        ConfigResolver.getConfigProvider().getConfig().addConfigSources(configSourcesToAdd);
    }

    public static synchronized void freeConfigSources() {
        if (configProvider != null) {
            ClassLoader cl = ClassUtils.getClassLoader(null);
            configProvider.releaseConfig(cl);
        }
    }

    public static void addConfigFilter(ConfigFilter configFilter) {
        ConfigResolver.getConfigProvider().getConfig().addConfigFilter(configFilter);
    }

    public static List<ConfigFilter> getConfigFilters() {
        return ConfigResolver.getConfigProvider().getConfig().getConfigFilters();
    }

    public static String getPropertyValue(String key, String defaultValue) {
        return ConfigResolver.getPropertyValue(key, defaultValue, true);
    }

    public static String getPropertyValue(String key, String defaultValue, boolean evaluateVariables) {
        return ConfigResolver.getConfigProvider().getConfig().resolve(key).withDefault(defaultValue).evaluateVariables(evaluateVariables).withCurrentProjectStage(false).getValue();
    }

    public static String getPropertyValue(String key) {
        return (String)ConfigResolver.getConfigProvider().getConfig().resolve(key).evaluateVariables(true).withCurrentProjectStage(false).getValue();
    }

    public static String getPropertyValue(String key, boolean evaluateVariables) {
        return (String)ConfigResolver.getConfigProvider().getConfig().resolve(key).evaluateVariables(evaluateVariables).withCurrentProjectStage(false).getValue();
    }

    public static String getProjectStageAwarePropertyValue(String key) {
        return (String)ConfigResolver.getConfigProvider().getConfig().resolve(key).withCurrentProjectStage(true).evaluateVariables(true).getValue();
    }

    public static String getProjectStageAwarePropertyValue(String key, String defaultValue) {
        return ConfigResolver.getConfigProvider().getConfig().resolve(key).withCurrentProjectStage(true).withDefault(defaultValue).evaluateVariables(true).getValue();
    }

    public static String getPropertyAwarePropertyValue(String key, String property) {
        return (String)ConfigResolver.getConfigProvider().getConfig().resolve(key).withCurrentProjectStage(true).parameterizedBy(property).evaluateVariables(true).getValue();
    }

    public static String getPropertyAwarePropertyValue(String key, String property, String defaultValue) {
        return ConfigResolver.getConfigProvider().getConfig().resolve(key).withCurrentProjectStage(true).parameterizedBy(property).withDefault(defaultValue).evaluateVariables(true).getValue();
    }

    public static List<String> getAllPropertyValues(String key) {
        ConfigSource[] configSources = ConfigResolver.getConfigProvider().getConfig().getConfigSources();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = configSources.length; i > 0; --i) {
            String value = configSources[i - 1].getPropertyValue(key);
            if (value == null || result.contains(value = ConfigResolver.filterConfigValue(key, value))) continue;
            result.add(value);
        }
        return result;
    }

    public static Map<String, String> getAllProperties() {
        ConfigSource[] configSources = ConfigResolver.getConfigProvider().getConfig().getConfigSources();
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = configSources.length; i > 0; --i) {
            ConfigSource configSource = configSources[i - 1];
            if (!configSource.isScannable()) continue;
            result.putAll(configSource.getProperties());
        }
        return Collections.unmodifiableMap(result);
    }

    public static ConfigSource[] getConfigSources() {
        return ConfigResolver.getConfigProvider().getConfig().getConfigSources();
    }

    public static String filterConfigValue(String key, String value) {
        return ConfigResolver.getConfigProvider().getConfig().filterConfigValue(key, value, false);
    }

    public static String filterConfigValueForLog(String key, String value) {
        return ConfigResolver.getConfigProvider().getConfig().filterConfigValue(key, value, true);
    }

    public static UntypedResolver<String> resolve(String name) {
        return ConfigResolver.getConfigProvider().getConfig().resolve(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigProvider getConfigProvider() {
        if (configProvider != null) return configProvider;
        Class<ConfigResolver> clazz = ConfigResolver.class;
        synchronized (ConfigResolver.class) {
            if (configProvider != null) return configProvider;
            Iterator<ConfigProvider> configProviders = ServiceLoader.load(ConfigProvider.class).iterator();
            if (!configProviders.hasNext()) {
                throw new RuntimeException("Could not load ConfigProvider");
            }
            configProvider = configProviders.next();
            if (!configProviders.hasNext()) return configProvider;
            throw new RuntimeException("Found more than one ConfigProvider");
        }
    }

    public static interface ConfigProvider {
        public Config getConfig();

        public Config getConfig(ClassLoader var1);

        public void releaseConfig(ClassLoader var1);

        public ConfigHelper getHelper();
    }

    public static interface UntypedResolver<T>
    extends TypedResolver<T> {
        public <N> TypedResolver<N> as(Class<N> var1);

        public <N> TypedResolver<N> as(Type var1, Converter<N> var2);

        public <N> TypedResolver<N> as(Class<N> var1, Converter<N> var2);

        public <N> TypedResolver<N> asBean(Class<N> var1);

        public <N> TypedResolver<N> asBean(Class<N> var1, BiFunction<Config, String, N> var2);
    }

    public static interface TypedResolver<T> {
        public TypedResolver<List<T>> asList();

        public TypedResolver<T> parameterizedBy(String var1);

        public TypedResolver<T> withCurrentProjectStage(boolean var1);

        public TypedResolver<T> strictly(boolean var1);

        public TypedResolver<T> withDefault(T var1);

        public TypedResolver<T> withStringDefault(String var1);

        public TypedResolver<T> cacheFor(TimeUnit var1, long var2);

        public TypedResolver<T> evaluateVariables(boolean var1);

        public TypedResolver<T> logChanges(boolean var1);

        public TypedResolver<T> onChange(ConfigChanged<T> var1);

        public T getValue();

        public T getValue(ConfigSnapshot var1);

        public String getKey();

        public String getResolvedKey();

        public T getDefaultValue();
    }

    public static interface ConfigChanged<T> {
        public void onValueChange(String var1, T var2, T var3);
    }

    public static interface ConfigHelper {
        public Set<String> diffConfig(Map<String, String> var1, Map<String, String> var2);
    }

    public static interface Converter<T> {
        public T convert(String var1);
    }
}

