/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.BytesCompactHashIterator;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.HashIterator;

class WrappedCompactSketch
extends CompactThetaSketch {
    final byte[] bytes_;

    WrappedCompactSketch(byte[] bytes) {
        this.bytes_ = bytes;
    }

    static WrappedCompactSketch wrapInstance(byte[] bytes, short seedHash) {
        Util.checkSeedHashes(ByteArrayUtil.getShortLE(bytes, 6), seedHash);
        return new WrappedCompactSketch(bytes);
    }

    @Override
    public CompactThetaSketch compact(boolean dstOrdered, MemorySegment dstSeg) {
        return CompactOperations.segmentToCompact(MemorySegment.ofArray(this.bytes_), dstOrdered, dstSeg);
    }

    @Override
    public int getCurrentBytes() {
        byte preLongs = this.bytes_[0];
        int numEntries = preLongs == 1 ? 0 : ByteArrayUtil.getIntLE(this.bytes_, 8);
        return preLongs + numEntries << 3;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        byte preLongs = this.bytes_[0];
        return preLongs == 1 ? 0 : ByteArrayUtil.getIntLE(this.bytes_, 8);
    }

    @Override
    public long getThetaLong() {
        byte preLongs = this.bytes_[0];
        return preLongs > 2 ? ByteArrayUtil.getLongLE(this.bytes_, 16) : Long.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return (this.bytes_[5] & 4) > 0;
    }

    @Override
    public boolean isOrdered() {
        return (this.bytes_[5] & 0x10) > 0;
    }

    @Override
    public HashIterator iterator() {
        return new BytesCompactHashIterator(this.bytes_, this.bytes_[0] << 3, this.getRetainedEntries());
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.bytes_, this.getCurrentBytes());
    }

    @Override
    long[] getCache() {
        long[] cache = new long[this.getRetainedEntries()];
        int i = 0;
        HashIterator it = this.iterator();
        while (it.next()) {
            cache[i++] = it.get();
        }
        return cache;
    }

    @Override
    int getCompactPreambleLongs() {
        return this.bytes_[0];
    }

    @Override
    int getCurrentPreambleLongs() {
        return this.bytes_[0];
    }

    @Override
    short getSeedHash() {
        return ByteArrayUtil.getShortLE(this.bytes_, 6);
    }
}

