/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.frequencies.DistTest;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.FrequentLongsSketch;
import org.apache.datasketches.frequencies.PreambleUtil;
import org.apache.datasketches.frequencies.ReversePurgeLongHashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LongsSketchTest {
    @Test
    public void hashMapSerialTest() {
        ReversePurgeLongHashMap map = new ReversePurgeLongHashMap(8);
        map.adjustOrPutValue(10L, 15L);
        map.adjustOrPutValue(10L, 5L);
        map.adjustOrPutValue(1L, 1L);
        map.adjustOrPutValue(2L, 3L);
        String string = map.serializeToString();
        ReversePurgeLongHashMap new_map = ReversePurgeLongHashMap.getInstance((String)string);
        String new_string = new_map.serializeToString();
        Assert.assertTrue((boolean)string.equals(new_string));
    }

    @Test
    public void frequentItemsStringSerialTest() {
        FrequentLongsSketch sketch = new FrequentLongsSketch(8);
        FrequentLongsSketch sketch2 = new FrequentLongsSketch(128);
        sketch.update(10L, 100L);
        sketch.update(10L, 100L);
        sketch.update(15L, 3443L);
        sketch.update(1000001L, 1010230L);
        sketch.update(1000002L, 1010230L);
        String string0 = sketch.serializeToString();
        FrequentLongsSketch new_sketch0 = FrequentLongsSketch.getInstance((String)string0);
        String new_string0 = new_sketch0.serializeToString();
        Assert.assertTrue((boolean)string0.equals(new_string0));
        Assert.assertTrue((new_sketch0.getMaximumMapCapacity() == sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch0.getCurrentMapCapacity() == sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
        sketch2.update(190L, 12902390L);
        sketch2.update(191L, 12902390L);
        sketch2.update(192L, 12902390L);
        sketch2.update(193L, 12902390L);
        sketch2.update(194L, 12902390L);
        sketch2.update(195L, 12902390L);
        sketch2.update(196L, 12902390L);
        sketch2.update(197L, 12902390L);
        sketch2.update(198L, 12902390L);
        sketch2.update(199L, 12902390L);
        sketch2.update(200L, 12902390L);
        sketch2.update(201L, 12902390L);
        sketch2.update(202L, 12902390L);
        sketch2.update(203L, 12902390L);
        sketch2.update(204L, 12902390L);
        sketch2.update(205L, 12902390L);
        sketch2.update(206L, 12902390L);
        sketch2.update(207L, 12902390L);
        sketch2.update(208L, 12902390L);
        String string2 = sketch2.serializeToString();
        FrequentLongsSketch new_sketch2 = FrequentLongsSketch.getInstance((String)string2);
        String new_string2 = new_sketch2.serializeToString();
        Assert.assertTrue((boolean)string2.equals(new_string2));
        Assert.assertTrue((new_sketch2.getMaximumMapCapacity() == sketch2.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch2.getCurrentMapCapacity() == sketch2.getCurrentMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch2.getStreamLength() == sketch2.getStreamLength() ? 1 : 0) != 0);
        FrequentLongsSketch merged_sketch = sketch.merge(sketch2);
        String string = merged_sketch.serializeToString();
        FrequentLongsSketch new_sketch = FrequentLongsSketch.getInstance((String)string);
        String new_string = new_sketch.serializeToString();
        Assert.assertTrue((boolean)string.equals(new_string));
        Assert.assertTrue((new_sketch.getMaximumMapCapacity() == merged_sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch.getCurrentMapCapacity() == merged_sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch.getStreamLength() == merged_sketch.getStreamLength() ? 1 : 0) != 0);
    }

    @Test
    public void frequentItemsByteSerialTest() {
        FrequentLongsSketch sketch = new FrequentLongsSketch(16);
        byte[] bytearray0 = sketch.toByteArray();
        MemorySegment seg0 = MemorySegment.ofArray(bytearray0);
        FrequentLongsSketch new_sketch0 = FrequentLongsSketch.getInstance((MemorySegment)seg0);
        String str0 = FrequentLongsSketch.toString((MemorySegment)seg0);
        LongsSketchTest.println(str0);
        String string0 = sketch.serializeToString();
        String new_string0 = new_sketch0.serializeToString();
        Assert.assertTrue((boolean)string0.equals(new_string0));
        FrequentLongsSketch sketch2 = new FrequentLongsSketch(128);
        sketch.update(10L, 100L);
        sketch.update(10L, 100L);
        sketch.update(15L, 3443L);
        sketch.update(1000001L, 1010230L);
        sketch.update(1000002L, 1010230L);
        byte[] bytearray1 = sketch.toByteArray();
        MemorySegment seg1 = MemorySegment.ofArray(bytearray1);
        FrequentLongsSketch new_sketch1 = FrequentLongsSketch.getInstance((MemorySegment)seg1);
        String str1 = FrequentLongsSketch.toString((byte[])bytearray1);
        LongsSketchTest.println(str1);
        String string1 = sketch.serializeToString();
        String new_string1 = new_sketch1.serializeToString();
        Assert.assertTrue((boolean)string1.equals(new_string1));
        Assert.assertTrue((new_sketch1.getMaximumMapCapacity() == sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch1.getCurrentMapCapacity() == sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
        sketch2.update(190L, 12902390L);
        sketch2.update(191L, 12902390L);
        sketch2.update(192L, 12902390L);
        sketch2.update(193L, 12902390L);
        sketch2.update(194L, 12902390L);
        sketch2.update(195L, 12902390L);
        sketch2.update(196L, 12902390L);
        sketch2.update(197L, 12902390L);
        sketch2.update(198L, 12902390L);
        sketch2.update(199L, 12902390L);
        sketch2.update(200L, 12902390L);
        sketch2.update(201L, 12902390L);
        sketch2.update(202L, 12902390L);
        sketch2.update(203L, 12902390L);
        sketch2.update(204L, 12902390L);
        sketch2.update(205L, 12902390L);
        sketch2.update(206L, 12902390L);
        sketch2.update(207L, 12902390L);
        sketch2.update(208L, 12902390L);
        byte[] bytearray2 = sketch2.toByteArray();
        MemorySegment seg2 = MemorySegment.ofArray(bytearray2);
        FrequentLongsSketch new_sketch2 = FrequentLongsSketch.getInstance((MemorySegment)seg2);
        String string2 = sketch2.serializeToString();
        String new_string2 = new_sketch2.serializeToString();
        Assert.assertTrue((boolean)string2.equals(new_string2));
        Assert.assertTrue((new_sketch2.getMaximumMapCapacity() == sketch2.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch2.getCurrentMapCapacity() == sketch2.getCurrentMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch2.getStreamLength() == sketch2.getStreamLength() ? 1 : 0) != 0);
        FrequentLongsSketch merged_sketch = sketch.merge(sketch2);
        byte[] bytearray = sketch.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(bytearray);
        FrequentLongsSketch new_sketch = FrequentLongsSketch.getInstance((MemorySegment)seg);
        String string = sketch.serializeToString();
        String new_string = new_sketch.serializeToString();
        Assert.assertTrue((boolean)string.equals(new_string));
        Assert.assertTrue((new_sketch.getMaximumMapCapacity() == merged_sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch.getCurrentMapCapacity() == merged_sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch.getStreamLength() == merged_sketch.getStreamLength() ? 1 : 0) != 0);
    }

    @Test
    public void frequentItemsByteResetAndEmptySerialTest() {
        FrequentLongsSketch sketch = new FrequentLongsSketch(16);
        sketch.update(10L, 100L);
        sketch.update(10L, 100L);
        sketch.update(15L, 3443L);
        sketch.update(1000001L, 1010230L);
        sketch.update(1000002L, 1010230L);
        sketch.reset();
        byte[] bytearray0 = sketch.toByteArray();
        MemorySegment seg0 = MemorySegment.ofArray(bytearray0);
        FrequentLongsSketch new_sketch0 = FrequentLongsSketch.getInstance((MemorySegment)seg0);
        String string0 = sketch.serializeToString();
        String new_string0 = new_sketch0.serializeToString();
        Assert.assertTrue((boolean)string0.equals(new_string0));
        Assert.assertTrue((new_sketch0.getMaximumMapCapacity() == sketch.getMaximumMapCapacity() ? 1 : 0) != 0);
        Assert.assertTrue((new_sketch0.getCurrentMapCapacity() == sketch.getCurrentMapCapacity() ? 1 : 0) != 0);
    }

    @Test
    public void checkFreqLongsSegSerDe() {
        int minSize = 8;
        FrequentLongsSketch sk1 = new FrequentLongsSketch(8);
        sk1.update(10L, 100L);
        sk1.update(10L, 100L);
        sk1.update(15L, 3443L);
        LongsSketchTest.println(sk1.toString());
        sk1.update(1000001L, 1010230L);
        LongsSketchTest.println(sk1.toString());
        sk1.update(1000002L, 1010230L);
        LongsSketchTest.println(sk1.toString());
        byte[] bytearray0 = sk1.toByteArray();
        MemorySegment seg0 = MemorySegment.ofArray(bytearray0);
        FrequentLongsSketch sk2 = FrequentLongsSketch.getInstance((MemorySegment)seg0);
        LongsSketchTest.checkEquality(sk1, sk2);
    }

    @Test
    public void checkFreqLongsStringSerDe() {
        int minSize = 8;
        FrequentLongsSketch sk1 = new FrequentLongsSketch(8);
        sk1.update(10L, 100L);
        sk1.update(10L, 100L);
        sk1.update(15L, 3443L);
        sk1.update(1000001L, 1010230L);
        sk1.update(1000002L, 1010230L);
        String string1 = sk1.serializeToString();
        FrequentLongsSketch sk2 = FrequentLongsSketch.getInstance((String)string1);
        LongsSketchTest.checkEquality(sk1, sk2);
    }

    private static void checkEquality(FrequentLongsSketch sk1, FrequentLongsSketch sk2) {
        String s2;
        String s1;
        int i;
        Assert.assertEquals((int)sk1.getNumActiveItems(), (int)sk2.getNumActiveItems());
        Assert.assertEquals((int)sk1.getCurrentMapCapacity(), (int)sk2.getCurrentMapCapacity());
        Assert.assertEquals((long)sk1.getMaximumError(), (long)sk2.getMaximumError());
        Assert.assertEquals((int)sk1.getMaximumMapCapacity(), (int)sk2.getMaximumMapCapacity());
        Assert.assertEquals((int)sk1.getStorageBytes(), (int)sk2.getStorageBytes());
        Assert.assertEquals((long)sk1.getStreamLength(), (long)sk2.getStreamLength());
        Assert.assertEquals((boolean)sk1.isEmpty(), (boolean)sk2.isEmpty());
        ErrorType NFN = ErrorType.NO_FALSE_NEGATIVES;
        ErrorType NFP = ErrorType.NO_FALSE_POSITIVES;
        FrequentLongsSketch.Row[] rowArr1 = sk1.getFrequentItems(NFN);
        FrequentLongsSketch.Row[] rowArr2 = sk2.getFrequentItems(NFN);
        Assert.assertEquals((int)sk1.getFrequentItems(NFN).length, (int)sk2.getFrequentItems(NFN).length);
        for (i = 0; i < rowArr1.length; ++i) {
            s1 = rowArr1[i].toString();
            s2 = rowArr2[i].toString();
            Assert.assertEquals((String)s1, (String)s2);
        }
        rowArr1 = sk1.getFrequentItems(NFP);
        rowArr2 = sk2.getFrequentItems(NFP);
        Assert.assertEquals((int)sk1.getFrequentItems(NFP).length, (int)sk2.getFrequentItems(NFP).length);
        for (i = 0; i < rowArr1.length; ++i) {
            s1 = rowArr1[i].toString();
            s2 = rowArr2[i].toString();
            Assert.assertEquals((String)s1, (String)s2);
        }
    }

    @Test
    public void checkFreqLongsSegDeSerExceptions() {
        int minSize = 8;
        FrequentLongsSketch sk1 = new FrequentLongsSketch(8);
        sk1.update(1L);
        byte[] bytearray0 = sk1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(bytearray0);
        long pre0 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 0L);
        LongsSketchTest.tryBadSeg(seg, 0, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        LongsSketchTest.tryBadSeg(seg, 1, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        LongsSketchTest.tryBadSeg(seg, 2, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        LongsSketchTest.tryBadSeg(seg, 5, 4);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
    }

    private static void tryBadSeg(MemorySegment seg, int byteOffset, int byteValue) {
        try {
            seg.set(ValueLayout.JAVA_BYTE, (long)byteOffset, (byte)byteValue);
            FrequentLongsSketch.getInstance((MemorySegment)seg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFreqLongsStringDeSerExceptions() {
        LongsSketchTest.tryBadString("2,10,2,4,0,0,0,4,");
        LongsSketchTest.tryBadString("1,10,2,0,0,0,0,4,");
        LongsSketchTest.tryBadString("1,10,2,4,0,0,0,4,0,");
    }

    private static void tryBadString(String badString) {
        try {
            FrequentLongsSketch.getInstance((String)badString);
            Assert.fail((String)"Should have thrown SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFreqLongs() {
        boolean numSketches = true;
        int n = 2222;
        double error_tolerance = 0.01;
        FrequentLongsSketch[] sketches = new FrequentLongsSketch[1];
        for (int h = 0; h < 1; ++h) {
            sketches[h] = LongsSketchTest.newFrequencySketch(0.01);
        }
        double prob = 0.001;
        for (int i = 0; i < 2222; ++i) {
            long item = DistTest.randomGeometricDist(0.001) + 1L;
            for (int h = 0; h < 1; ++h) {
                sketches[h].update(item);
            }
        }
        for (int h = 0; h < 1; ++h) {
            int i;
            long threshold = sketches[h].getMaximumError();
            FrequentLongsSketch.Row[] rows = sketches[h].getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
            for (i = 0; i < rows.length; ++i) {
                Assert.assertTrue((rows[i].getUpperBound() > threshold ? 1 : 0) != 0);
            }
            rows = sketches[h].getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
            for (i = 0; i < rows.length; ++i) {
                Assert.assertTrue((rows[i].getLowerBound() > threshold ? 1 : 0) != 0);
            }
            rows = sketches[h].getFrequentItems(Long.MAX_VALUE, ErrorType.NO_FALSE_POSITIVES);
            Assert.assertEquals((int)rows.length, (int)0);
        }
    }

    @Test
    public void updateOneTime() {
        int size = 100;
        double error_tolerance = 0.01;
        boolean numSketches = true;
        for (int h = 0; h < 1; ++h) {
            FrequentLongsSketch sketch = LongsSketchTest.newFrequencySketch(0.01);
            Assert.assertEquals((long)sketch.getUpperBound(13L), (long)0L);
            Assert.assertEquals((long)sketch.getLowerBound(13L), (long)0L);
            Assert.assertEquals((long)sketch.getMaximumError(), (long)0L);
            Assert.assertEquals((long)sketch.getEstimate(13L), (long)0L);
            sketch.update(13L);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceMemorySegment() {
        MemorySegment seg = MemorySegment.ofArray(new byte[4]);
        FrequentLongsSketch.getInstance((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetInstanceString() {
        String s = "";
        FrequentLongsSketch.getInstance((String)"");
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkUpdateNegative() {
        int minSize = 8;
        FrequentLongsSketch fls = new FrequentLongsSketch(8);
        fls.update(1L, 0L);
        fls.update(1L, -1L);
    }

    @Test
    public void checkGetFrequentItems1() {
        int minSize = 8;
        FrequentLongsSketch fis = new FrequentLongsSketch(8);
        fis.update(1L);
        FrequentLongsSketch.Row[] rowArr = fis.getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
        FrequentLongsSketch.Row row = rowArr[0];
        Assert.assertTrue((row.hashCode() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)row.equals((Object)row));
        Assert.assertFalse((boolean)row.equals((Object)fis));
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)row.est, (long)1L);
        Assert.assertEquals((long)row.item, (long)1L);
        Assert.assertEquals((long)row.lb, (long)1L);
        Assert.assertEquals((long)row.ub, (long)1L);
        FrequentLongsSketch.Row newRow = new FrequentLongsSketch.Row(row.item, row.est + 1L, row.ub, row.lb);
        Assert.assertFalse((boolean)row.equals((Object)newRow));
        newRow = new FrequentLongsSketch.Row(row.item, row.est, row.ub, row.lb);
        Assert.assertTrue((boolean)row.equals((Object)newRow));
    }

    @Test
    public void checkGetStorageBytes() {
        int minSize = 8;
        FrequentLongsSketch fls = new FrequentLongsSketch(8);
        Assert.assertEquals((int)fls.toByteArray().length, (int)fls.getStorageBytes());
        fls.update(1L);
        Assert.assertEquals((int)fls.toByteArray().length, (int)fls.getStorageBytes());
    }

    @Test
    public void checkDeSerFromStringArray() {
        int minSize = 8;
        FrequentLongsSketch fls = new FrequentLongsSketch(8);
        String ser = fls.serializeToString();
        LongsSketchTest.println(ser);
        fls.update(1L);
        ser = fls.serializeToString();
        LongsSketchTest.println(ser);
    }

    @Test
    public void checkMerge() {
        int minSize = 8;
        FrequentLongsSketch fls1 = new FrequentLongsSketch(8);
        FrequentLongsSketch fls2 = null;
        FrequentLongsSketch fle = fls1.merge(fls2);
        Assert.assertTrue((boolean)fle.isEmpty());
        fls2 = new FrequentLongsSketch(8);
        fle = fls1.merge(fls2);
        Assert.assertTrue((boolean)fle.isEmpty());
    }

    @Test
    public void checkSortItems() {
        boolean numSketches = true;
        int n = 2222;
        double error_tolerance = 0.01;
        int sketchSize = Util.ceilingPowerOf2((int)((int)(1.0 / (0.01 * ReversePurgeLongHashMap.getLoadFactor()))));
        FrequentLongsSketch[] sketches = new FrequentLongsSketch[1];
        for (int h = 0; h < 1; ++h) {
            sketches[h] = new FrequentLongsSketch(sketchSize);
        }
        double prob = 0.001;
        for (int i = 0; i < 2222; ++i) {
            long item = DistTest.randomGeometricDist(0.001) + 1L;
            for (int h = 0; h < 1; ++h) {
                sketches[h].update(item);
            }
        }
        for (int h = 0; h < 1; ++h) {
            long threshold = sketches[h].getMaximumError();
            FrequentLongsSketch.Row[] rows = sketches[h].getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
            for (int i = 0; i < rows.length; ++i) {
                Assert.assertTrue((rows[i].ub > threshold ? 1 : 0) != 0);
            }
            FrequentLongsSketch.Row first = rows[0];
            long anItem = first.getItem();
            long anEst = first.getEstimate();
            long aLB = first.getLowerBound();
            String s = first.toString();
            LongsSketchTest.println(s);
            Assert.assertTrue((anEst >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((aLB >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)anItem, (long)anItem);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetAndCheckPreLongs() {
        byte[] byteArr = new byte[8];
        byteArr[0] = 2;
        PreambleUtil.checkPreambleSize((MemorySegment)MemorySegment.ofArray(byteArr));
    }

    @Test
    public void checkToString1() {
        int size = 8;
        this.printSketch(8, new long[]{1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 3L, 4L, 5L});
        this.printSketch(8, new long[]{5L, 4L, 3L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
    }

    @Test
    public void checkStringDeserEmptyNotCorrupt() {
        int size = 8;
        int thresh = 6;
        String fmt = "%6d%10s%s";
        FrequentLongsSketch fls = new FrequentLongsSketch(8);
        LongsSketchTest.println("Sketch Size: 8");
        String s = null;
        for (int i = 0; i <= 6; ++i) {
            fls.update((long)(i + 1), 1L);
            s = fls.serializeToString();
            LongsSketchTest.println(String.format("SER   %6d%10s%s", i + 1, fls.isEmpty() + " : ", s));
            FrequentLongsSketch fls2 = FrequentLongsSketch.getInstance((String)s);
            LongsSketchTest.println(String.format("DESER %6d%10s%s", i + 1, fls2.isEmpty() + " : ", s));
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkStringDeserEmptyCorrupt() {
        String s = "1,10,3,0,7,1,0,8,";
        FrequentLongsSketch.getInstance((String)"1,10,3,0,7,1,0,8,");
    }

    @Test
    public void checkGetEpsilon() {
        Assert.assertEquals((double)FrequentLongsSketch.getEpsilon((int)1024), (double)0.00341796875, (double)0.0);
        try {
            FrequentLongsSketch.getEpsilon((int)1000);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkGetAprioriError() {
        double eps = 0.00341796875;
        Assert.assertEquals((double)FrequentLongsSketch.getAprioriError((int)1024, (long)10000L), (double)34.1796875);
    }

    @Test
    public void printlnTest() {
        LongsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    public void printSketch(int size, long[] freqArr) {
        FrequentLongsSketch fls = new FrequentLongsSketch(size);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < freqArr.length; ++i) {
            fls.update((long)(i + 1), freqArr[i]);
        }
        sb.append("Sketch Size: " + size).append(Util.LS);
        String s = fls.toString();
        sb.append(s);
        LongsSketchTest.println(sb.toString());
        LongsSketchTest.printRows(fls, ErrorType.NO_FALSE_NEGATIVES);
        LongsSketchTest.println("");
        LongsSketchTest.printRows(fls, ErrorType.NO_FALSE_POSITIVES);
        LongsSketchTest.println("");
    }

    private static void printRows(FrequentLongsSketch fls, ErrorType eType) {
        FrequentLongsSketch.Row[] rows = fls.getFrequentItems(eType);
        String s1 = eType.toString();
        LongsSketchTest.println(s1);
        String hdr = FrequentLongsSketch.Row.getRowHeader();
        LongsSketchTest.println(hdr);
        for (int i = 0; i < rows.length; ++i) {
            FrequentLongsSketch.Row row = rows[i];
            String s2 = row.toString();
            LongsSketchTest.println(s2);
        }
        if (rows.length > 0) {
            Object nullRow = null;
            Assert.assertFalse((boolean)rows[0].equals(nullRow));
        }
    }

    static void println(String s) {
    }

    private static FrequentLongsSketch newFrequencySketch(double eps) {
        double loadFactor = ReversePurgeLongHashMap.getLoadFactor();
        int maxMapSize = Util.ceilingPowerOf2((int)((int)(1.0 / (eps * loadFactor))));
        return new FrequentLongsSketch(maxMapSize);
    }
}

