/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.AbstractXoRoShiRo128;

public class XoRoShiRo128PlusPlus
extends AbstractXoRoShiRo128 {
    private static final long[] JUMP_COEFFICIENTS = new long[]{3159176899437800924L, 689838746718161413L};
    private static final long[] LONG_JUMP_COEFFICIENTS = new long[]{3895567441539718553L, -7174682294107748637L};

    public XoRoShiRo128PlusPlus(long[] seed) {
        super(seed);
    }

    public XoRoShiRo128PlusPlus(long seed0, long seed1) {
        super(seed0, seed1);
    }

    protected XoRoShiRo128PlusPlus(XoRoShiRo128PlusPlus source) {
        super(source);
    }

    @Override
    public long next() {
        long s0 = this.state0;
        long s1 = this.state1;
        long result = Long.rotateLeft(s0 + s1, 17) + s0;
        this.state0 = Long.rotateLeft(s0, 49) ^ (s1 ^= s0) ^ s1 << 21;
        this.state1 = Long.rotateLeft(s1, 28);
        return result;
    }

    @Override
    protected long nextOutput() {
        throw new UnsupportedOperationException("The PlusPlus algorithm redefines the next() method");
    }

    @Override
    public UniformRandomProvider jump() {
        XoRoShiRo128PlusPlus copy = this.copy();
        this.performJump(JUMP_COEFFICIENTS);
        return copy;
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        XoRoShiRo128PlusPlus copy = this.copy();
        this.performJump(LONG_JUMP_COEFFICIENTS);
        return copy;
    }

    @Override
    protected XoRoShiRo128PlusPlus copy() {
        return new XoRoShiRo128PlusPlus(this);
    }
}

