/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class AssignTest
extends JexlTestCase {
    public AssignTest() {
        super("AssignTest", new JexlBuilder().cache(512).strict(true).silent(false).create());
    }

    @Test
    public void testAntish() throws Exception {
        JexlExpression assign = this.JEXL.createExpression("froboz.value = 10");
        JexlExpression check = this.JEXL.createExpression("froboz.value");
        MapContext jc = new MapContext();
        Object o = assign.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    @Test
    public void testAntishInteger() throws Exception {
        JexlExpression assign = this.JEXL.createExpression("froboz.0 = 10");
        JexlExpression check = this.JEXL.createExpression("froboz.0");
        MapContext jc = new MapContext();
        Object o = assign.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    @Test
    public void testBeanish() throws Exception {
        JexlExpression assign = this.JEXL.createExpression("froboz.value = 10");
        JexlExpression check = this.JEXL.createExpression("froboz.value");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(-169);
        jc.set("froboz", (Object)froboz);
        Object o = assign.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAmbiguous() throws Exception {
        JexlExpression assign = this.JEXL.createExpression("froboz.nosuchbean = 10");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(-169);
        jc.set("froboz", (Object)froboz);
        Object o = null;
        try {
            o = assign.evaluate((JexlContext)jc);
        }
        catch (RuntimeException xrt) {
            String str = xrt.toString();
            Assert.assertTrue((boolean)str.contains("nosuchbean"));
        }
        finally {
            Assert.assertNull((String)"Should have failed", (Object)o);
        }
    }

    @Test
    public void testArray() throws Exception {
        JexlExpression assign = this.JEXL.createExpression("froboz[\"value\"] = 10");
        JexlExpression check = this.JEXL.createExpression("froboz[\"value\"]");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(0);
        jc.set("froboz", (Object)froboz);
        Object o = assign.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    @Test
    public void testMini() throws Exception {
        MapContext jc = new MapContext();
        JexlExpression assign = this.JEXL.createExpression("quux = 10");
        Object o = assign.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    @Test
    public void testMore() throws Exception {
        MapContext jc = new MapContext();
        jc.set("quuxClass", Quux.class);
        JexlExpression create = this.JEXL.createExpression("quux = new(quuxClass, 'xuuq', 100)");
        JexlExpression assign = this.JEXL.createExpression("quux.froboz.value = 10");
        JexlExpression check = this.JEXL.createExpression("quux[\"froboz\"].value");
        Quux quux = (Quux)create.evaluate((JexlContext)jc);
        Assert.assertNotNull((String)"quux is null", (Object)quux);
        Object o = assign.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    @Test
    public void testUtil() throws Exception {
        Quux quux = (Quux)this.JEXL.newInstance(Quux.class, new Object[]{"xuuq", 100});
        Assert.assertNotNull((Object)quux);
        this.JEXL.setProperty((Object)quux, "froboz.value", (Object)100);
        Object o = this.JEXL.getProperty((Object)quux, "froboz.value");
        Assert.assertEquals((String)"Result is not 100", (Object)new Integer(100), (Object)o);
        this.JEXL.setProperty((Object)quux, "['froboz'].value", (Object)1000);
        o = this.JEXL.getProperty((Object)quux, "['froboz']['value']");
        Assert.assertEquals((String)"Result is not 1000", (Object)new Integer(1000), (Object)o);
    }

    @Test
    public void testRejectLocal() throws Exception {
        Object o;
        MapContext jc = new MapContext();
        JexlScript assign = this.JEXL.createScript("var quux = null; quux.froboz.value = 10");
        try {
            o = assign.execute((JexlContext)jc);
            Assert.fail((String)"quux is local and null, should fail");
        }
        catch (JexlException xjexl) {
            String x;
            String string = x = xjexl.toString();
        }
        assign = this.JEXL.createScript("quux.froboz.value = 10");
        o = assign.execute((JexlContext)jc);
        Assert.assertEquals((Object)10, (Object)o);
    }

    public static class Quux {
        String str;
        Froboz froboz;

        public Quux(String str, int fro) {
            this.str = str;
            this.froboz = new Froboz(fro);
        }

        public Froboz getFroboz() {
            return this.froboz;
        }

        public void setFroboz(Froboz froboz) {
            this.froboz = froboz;
        }

        public String getStr() {
            return this.str;
        }

        public void setStr(String str) {
            this.str = str;
        }
    }

    public static class Froboz {
        int value;

        public Froboz(int v) {
            this.value = v;
        }

        public void setValue(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

