/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import junit.framework.TestSuite;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.test.BaseJellyTest;

public class TestInvokeStaticTag
extends BaseJellyTest {
    public TestInvokeStaticTag(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestInvokeStaticTag.class);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSimpleSystemInvoke() throws Exception {
        this.setUpScript("testInvokeStaticTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.simpleSystemInvoke", (Object)Boolean.TRUE);
        this.getJellyContext().setVariable("propertyName", (Object)"java.runtime.version");
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestInvokeStaticTag.assertTrue((boolean)System.getProperty("java.runtime.version").equals(this.getJellyContext().getVariable("propertyName")));
    }

    public void testSystemInvoke() throws Exception {
        this.setUpScript("testInvokeStaticTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.systemInvoke", (Object)Boolean.TRUE);
        this.getJellyContext().setVariable("propertyName", (Object)"TEST PROPERTY");
        this.getJellyContext().setVariable("propertyValue", (Object)"Jelly is cool");
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestInvokeStaticTag.assertTrue((boolean)System.getProperty("TEST PROPERTY").equals("Jelly is cool"));
    }

    public void testMessageFormatInvoke() throws Exception {
        System.out.println(System.getProperties());
        this.setUpScript("testInvokeStaticTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.messageFormatInvoke", (Object)Boolean.TRUE);
        Object[] args = new Object[]{"Jelly", "coolest", "used"};
        this.getJellyContext().setVariable("args", (Object)args);
        this.getJellyContext().setVariable("message", (Object)"Is not {0} the {1} thing you have ever {2}?");
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestInvokeStaticTag.assertNotNull((Object)this.getJellyContext().getVariable("message"));
        TestInvokeStaticTag.assertTrue((boolean)this.getJellyContext().getVariable("message").equals("Is not Jelly the coolest thing you have ever used?"));
    }

    public void testInvokeThatThrowsException() throws Exception {
        this.setUpScript("testInvokeStaticTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.invokeThatThrowsException", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        String exceptionMessage = (String)this.getJellyContext().getVariable("exceptionMessage");
        TestInvokeStaticTag.assertNotNull((Object)exceptionMessage);
        Exception jellyException = (Exception)this.getJellyContext().getVariable("jellyException");
        TestInvokeStaticTag.assertNull((Object)jellyException);
        Exception exception = (Exception)this.getJellyContext().getVariable("exceptionThrown");
        TestInvokeStaticTag.assertNotNull((Object)exception);
        TestInvokeStaticTag.assertEquals((String)exceptionMessage, (String)exception.getMessage());
    }

    public void testInvokeThatDoesNotHandleException() throws Exception {
        this.setUpScript("testInvokeStaticTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.invokeThatDoesNotHandleException", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        String exceptionMessage = (String)this.getJellyContext().getVariable("exceptionMessage");
        TestInvokeStaticTag.assertNotNull((Object)exceptionMessage);
        JellyException jellyException = (JellyException)((Object)this.getJellyContext().getVariable("jellyException"));
        TestInvokeStaticTag.assertNotNull((Object)((Object)jellyException));
        TestInvokeStaticTag.assertTrue((String)"messages are the same", (!exceptionMessage.equals(jellyException.getMessage()) ? 1 : 0) != 0);
        TestInvokeStaticTag.assertTrue((String)("exception '" + jellyException.getMessage() + "' does not ends with '" + exceptionMessage + "'"), (boolean)jellyException.getMessage().endsWith(exceptionMessage));
        TestInvokeStaticTag.assertNotNull((Object)jellyException.getCause());
        TestInvokeStaticTag.assertEquals((String)exceptionMessage, (String)jellyException.getCause().getMessage());
    }
}

