/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTest;
import org.apache.commons.io.comparator.PathFileComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PathFileComparatorTest
extends ComparatorAbstractTest {
    PathFileComparatorTest() {
    }

    @BeforeEach
    public void setUp() {
        this.comparator = (AbstractFileComparator)PathFileComparator.PATH_COMPARATOR;
        this.reverse = PathFileComparator.PATH_REVERSE;
        this.equalFile1 = new File("foo/file.txt");
        this.equalFile2 = new File("foo/file.txt");
        this.lessFile = new File("abc/file.txt");
        this.moreFile = new File("xyz/file.txt");
    }

    @Test
    void testCaseSensitivity() {
        File file3 = new File("FOO/file.txt");
        PathFileComparator sensitive = new PathFileComparator(null);
        Assertions.assertEquals((int)0, (int)sensitive.compare(this.equalFile1, this.equalFile2), (String)"sensitive file1 & file2 = 0");
        Assertions.assertTrue((sensitive.compare(this.equalFile1, file3) > 0 ? 1 : 0) != 0, (String)"sensitive file1 & file3 > 0");
        Assertions.assertTrue((sensitive.compare(this.equalFile1, this.lessFile) > 0 ? 1 : 0) != 0, (String)"sensitive file1 & less  > 0");
        Comparator insensitive = PathFileComparator.PATH_INSENSITIVE_COMPARATOR;
        Assertions.assertEquals((int)0, (int)insensitive.compare(this.equalFile1, this.equalFile2), (String)"insensitive file1 & file2 = 0");
        Assertions.assertEquals((int)0, (int)insensitive.compare(this.equalFile1, file3), (String)"insensitive file1 & file3 = 0");
        Assertions.assertTrue((insensitive.compare(this.equalFile1, this.lessFile) > 0 ? 1 : 0) != 0, (String)"insensitive file1 & file4 > 0");
        Assertions.assertTrue((insensitive.compare(file3, this.lessFile) > 0 ? 1 : 0) != 0, (String)"insensitive file3 & less  > 0");
    }
}

