/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.AbstractJpegTest;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.test.TestResources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class JpegReadTest
extends AbstractJpegTest {
    public static Stream<File> data() throws Exception {
        return JpegReadTest.getJpegImages().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void test(File imageFile) throws Exception {
        JpegImageParser jpegImageParser = new JpegImageParser();
        TiffImageMetadata metadata = jpegImageParser.getExifMetadata(ByteSource.file((File)imageFile), new TiffImagingParameters());
        Debug.debug((String)"metadata", (Object)metadata);
        Debug.debug((String)"ICC profile", (Object)Imaging.getIccProfile((File)imageFile));
        ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
        Assertions.assertNotNull((Object)imageInfo);
        try {
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            Assertions.assertNotNull((Object)image);
        }
        catch (ImagingException imageReadException) {
            Assertions.assertEquals((Object)"Only sequential, baseline JPEGs are supported at the moment", (Object)imageReadException.getMessage());
        }
    }

    @Test
    public void testUncaughtExceptionOssFuzz33458() {
        File file = TestResources.resourceToFile("/images/jpeg/oss-fuzz-33458/clusterfuzz-testcase-minimized-ImagingJpegFuzzer-4548690447564800");
        JpegImageParser parser = new JpegImageParser();
        Assertions.assertThrows(ImagingException.class, () -> parser.getBufferedImage(ByteSource.file((File)file), new JpegImagingParameters()));
    }
}

