/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.securitycontext.Capabilities;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.securitycontext.SeLinuxOptions;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.securitycontext.SeccompProfile;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.securitycontext.WindowsOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"allowPrivilegeEscalation", "capabilities", "privileged", "procMount", "readOnlyRootFilesystem", "runAsGroup", "runAsNonRoot", "runAsUser", "seLinuxOptions", "seccompProfile", "windowsOptions"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class SecurityContext
implements KubernetesResource {
    @JsonProperty(value="allowPrivilegeEscalation")
    @JsonPropertyDescription(value="AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean allowPrivilegeEscalation;
    @JsonProperty(value="capabilities")
    @JsonPropertyDescription(value="The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Capabilities capabilities;
    @JsonProperty(value="privileged")
    @JsonPropertyDescription(value="Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean privileged;
    @JsonProperty(value="procMount")
    @JsonPropertyDescription(value="procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled. Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String procMount;
    @JsonProperty(value="readOnlyRootFilesystem")
    @JsonPropertyDescription(value="Whether this container has a read-only root filesystem. Default is false. Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnlyRootFilesystem;
    @JsonProperty(value="runAsGroup")
    @JsonPropertyDescription(value="The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long runAsGroup;
    @JsonProperty(value="runAsNonRoot")
    @JsonPropertyDescription(value="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean runAsNonRoot;
    @JsonProperty(value="runAsUser")
    @JsonPropertyDescription(value="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long runAsUser;
    @JsonProperty(value="seLinuxOptions")
    @JsonPropertyDescription(value="The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SeLinuxOptions seLinuxOptions;
    @JsonProperty(value="seccompProfile")
    @JsonPropertyDescription(value="The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options. Note that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SeccompProfile seccompProfile;
    @JsonProperty(value="windowsOptions")
    @JsonPropertyDescription(value="The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. Note that this field cannot be set when spec.os.name is linux.")
    @JsonSetter(nulls=Nulls.SKIP)
    private WindowsOptions windowsOptions;

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public String getProcMount() {
        return this.procMount;
    }

    public void setProcMount(String procMount) {
        this.procMount = procMount;
    }

    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public SeLinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(SeLinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public SeccompProfile getSeccompProfile() {
        return this.seccompProfile;
    }

    public void setSeccompProfile(SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
    }

    public WindowsOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(WindowsOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public String toString() {
        return "SecurityContext(allowPrivilegeEscalation=" + this.getAllowPrivilegeEscalation() + ", capabilities=" + this.getCapabilities() + ", privileged=" + this.getPrivileged() + ", procMount=" + this.getProcMount() + ", readOnlyRootFilesystem=" + this.getReadOnlyRootFilesystem() + ", runAsGroup=" + this.getRunAsGroup() + ", runAsNonRoot=" + this.getRunAsNonRoot() + ", runAsUser=" + this.getRunAsUser() + ", seLinuxOptions=" + this.getSeLinuxOptions() + ", seccompProfile=" + this.getSeccompProfile() + ", windowsOptions=" + this.getWindowsOptions() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityContext)) {
            return false;
        }
        SecurityContext other = (SecurityContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowPrivilegeEscalation = this.getAllowPrivilegeEscalation();
        Boolean other$allowPrivilegeEscalation = other.getAllowPrivilegeEscalation();
        if (this$allowPrivilegeEscalation == null ? other$allowPrivilegeEscalation != null : !((Object)this$allowPrivilegeEscalation).equals(other$allowPrivilegeEscalation)) {
            return false;
        }
        Boolean this$privileged = this.getPrivileged();
        Boolean other$privileged = other.getPrivileged();
        if (this$privileged == null ? other$privileged != null : !((Object)this$privileged).equals(other$privileged)) {
            return false;
        }
        Boolean this$readOnlyRootFilesystem = this.getReadOnlyRootFilesystem();
        Boolean other$readOnlyRootFilesystem = other.getReadOnlyRootFilesystem();
        if (this$readOnlyRootFilesystem == null ? other$readOnlyRootFilesystem != null : !((Object)this$readOnlyRootFilesystem).equals(other$readOnlyRootFilesystem)) {
            return false;
        }
        Long this$runAsGroup = this.getRunAsGroup();
        Long other$runAsGroup = other.getRunAsGroup();
        if (this$runAsGroup == null ? other$runAsGroup != null : !((Object)this$runAsGroup).equals(other$runAsGroup)) {
            return false;
        }
        Boolean this$runAsNonRoot = this.getRunAsNonRoot();
        Boolean other$runAsNonRoot = other.getRunAsNonRoot();
        if (this$runAsNonRoot == null ? other$runAsNonRoot != null : !((Object)this$runAsNonRoot).equals(other$runAsNonRoot)) {
            return false;
        }
        Long this$runAsUser = this.getRunAsUser();
        Long other$runAsUser = other.getRunAsUser();
        if (this$runAsUser == null ? other$runAsUser != null : !((Object)this$runAsUser).equals(other$runAsUser)) {
            return false;
        }
        Capabilities this$capabilities = this.getCapabilities();
        Capabilities other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        String this$procMount = this.getProcMount();
        String other$procMount = other.getProcMount();
        if (this$procMount == null ? other$procMount != null : !this$procMount.equals(other$procMount)) {
            return false;
        }
        SeLinuxOptions this$seLinuxOptions = this.getSeLinuxOptions();
        SeLinuxOptions other$seLinuxOptions = other.getSeLinuxOptions();
        if (this$seLinuxOptions == null ? other$seLinuxOptions != null : !((Object)this$seLinuxOptions).equals(other$seLinuxOptions)) {
            return false;
        }
        SeccompProfile this$seccompProfile = this.getSeccompProfile();
        SeccompProfile other$seccompProfile = other.getSeccompProfile();
        if (this$seccompProfile == null ? other$seccompProfile != null : !((Object)this$seccompProfile).equals(other$seccompProfile)) {
            return false;
        }
        WindowsOptions this$windowsOptions = this.getWindowsOptions();
        WindowsOptions other$windowsOptions = other.getWindowsOptions();
        return !(this$windowsOptions == null ? other$windowsOptions != null : !((Object)this$windowsOptions).equals(other$windowsOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowPrivilegeEscalation = this.getAllowPrivilegeEscalation();
        result = result * 59 + ($allowPrivilegeEscalation == null ? 43 : ((Object)$allowPrivilegeEscalation).hashCode());
        Boolean $privileged = this.getPrivileged();
        result = result * 59 + ($privileged == null ? 43 : ((Object)$privileged).hashCode());
        Boolean $readOnlyRootFilesystem = this.getReadOnlyRootFilesystem();
        result = result * 59 + ($readOnlyRootFilesystem == null ? 43 : ((Object)$readOnlyRootFilesystem).hashCode());
        Long $runAsGroup = this.getRunAsGroup();
        result = result * 59 + ($runAsGroup == null ? 43 : ((Object)$runAsGroup).hashCode());
        Boolean $runAsNonRoot = this.getRunAsNonRoot();
        result = result * 59 + ($runAsNonRoot == null ? 43 : ((Object)$runAsNonRoot).hashCode());
        Long $runAsUser = this.getRunAsUser();
        result = result * 59 + ($runAsUser == null ? 43 : ((Object)$runAsUser).hashCode());
        Capabilities $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        String $procMount = this.getProcMount();
        result = result * 59 + ($procMount == null ? 43 : $procMount.hashCode());
        SeLinuxOptions $seLinuxOptions = this.getSeLinuxOptions();
        result = result * 59 + ($seLinuxOptions == null ? 43 : ((Object)$seLinuxOptions).hashCode());
        SeccompProfile $seccompProfile = this.getSeccompProfile();
        result = result * 59 + ($seccompProfile == null ? 43 : ((Object)$seccompProfile).hashCode());
        WindowsOptions $windowsOptions = this.getWindowsOptions();
        result = result * 59 + ($windowsOptions == null ? 43 : ((Object)$windowsOptions).hashCode());
        return result;
    }
}

