/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.saml;

import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.OMElement;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.saml.SAMLAssertionHandler;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Conditions;

public class SAML1AssertionHandler
extends SAMLAssertionHandler {
    private Assertion assertion;

    public SAML1AssertionHandler(Assertion saml1Assertion) {
        this.assertion = saml1Assertion;
        this.processSAMLAssertion();
    }

    public boolean isBearerAssertion() {
        return "urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(SAMLUtils.getSAML11SubjectConfirmationMethod((Assertion)this.assertion));
    }

    protected void processSAMLAssertion() {
        this.setAssertionId(this.assertion.getID());
        if (this.assertion.getConditions() != null) {
            Conditions conditions = this.assertion.getConditions();
            if (conditions.getNotBefore() != null) {
                this.setDateNotBefore(conditions.getNotBefore().toDate());
            }
            if (conditions.getNotOnOrAfter() != null) {
                this.setDateNotOnOrAfter(conditions.getNotOnOrAfter().toDate());
            }
        }
    }

    public byte[] getAssertionKeyInfoSecret(Crypto signatureCrypto, TokenCallbackHandler tokenCallbackHandler) throws WSSecurityException {
        RequestData requestData = new RequestData();
        requestData.setCallbackHandler((CallbackHandler)tokenCallbackHandler);
        requestData.setSigCrypto(signatureCrypto);
        WSDocInfo docInfo = new WSDocInfo(this.assertion.getDOM().getOwnerDocument());
        SAMLKeyInfo samlKi = SAMLUtil.getCredentialFromSubject((Assertion)this.assertion, (RequestData)requestData, (WSDocInfo)docInfo, (boolean)true);
        return samlKi.getSecret();
    }

    public OMElement getAssertionElement() throws TrustException {
        return (OMElement)this.assertion.getDOM();
    }
}

