/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import org.apache.axis2.context.MessageContext;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.CharArrayBuffer;

public class ResponseSessionCookie
implements HttpResponseInterceptor {
    public void process(HttpResponse response, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String sessionCookie = null;
        MessageContext msgctx = (MessageContext)context.getAttribute("axis.message.context");
        if (msgctx != null) {
            sessionCookie = (String)msgctx.getProperty("Cookie");
        }
        if (sessionCookie == null) {
            sessionCookie = (String)context.getAttribute("Cookie");
        }
        if (sessionCookie != null) {
            CharArrayBuffer buffer1 = new CharArrayBuffer(sessionCookie.length() + 40);
            buffer1.append("Set-Cookie");
            buffer1.append(": ");
            buffer1.append("JSESSIONID");
            buffer1.append("=");
            buffer1.append(sessionCookie);
            response.addHeader((Header)new BufferedHeader(buffer1));
            CharArrayBuffer buffer2 = new CharArrayBuffer(sessionCookie.length() + 50);
            buffer2.append("Set-Cookie2");
            buffer2.append(": ");
            buffer2.append("JSESSIONID");
            buffer2.append("=");
            buffer2.append(sessionCookie);
            buffer2.append("; ");
            buffer2.append("Version=1");
            response.addHeader((Header)new BufferedHeader(buffer2));
        }
    }
}

