/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.serializer;

import java.io.IOException;
import java.io.Writer;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.serializer.Serializer;

final class SerializerWriter
extends Writer {
    private final Serializer serializer;

    public SerializerWriter(Serializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            this.serializer.characters(cbuf, off, len);
        }
        catch (StreamException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        try {
            this.serializer.characters(str, off, len);
        }
        catch (StreamException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }
}

