/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.MessageSupport;

public class PUBREL
extends MessageSupport.HeaderBase
implements MessageSupport.Message,
MessageSupport.Acked {
    public static final byte TYPE = 6;
    private short messageId;

    public byte messageType() {
        return 6;
    }

    public PUBREL() {
        this.qos(QoS.AT_LEAST_ONCE);
    }

    public PUBREL decode(MQTTFrame frame) throws ProtocolException {
        assert (frame.buffers.length == 1);
        this.header(frame.header());
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        this.messageId = is.readShort();
        return this;
    }

    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream(2);
            os.writeShort((int)this.messageId);
            MQTTFrame frame = new MQTTFrame();
            frame.header(this.header());
            frame.commandType(6);
            return frame.buffer(os.toBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    public boolean dup() {
        return super.dup();
    }

    public PUBREL dup(boolean dup) {
        return (PUBREL)super.dup(dup);
    }

    public QoS qos() {
        return super.qos();
    }

    public short messageId() {
        return this.messageId;
    }

    public PUBREL messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    public String toString() {
        return "PUBREL{dup=" + this.dup() + ", qos=" + (Object)((Object)this.qos()) + ", messageId=" + this.messageId + '}';
    }
}

