/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.AbstractExecutor;
import org.apache.velocity.util.ArrayListWrapper;
import org.apache.velocity.util.introspection.Introspector;
import org.slf4j.Logger;

public class PropertyExecutor
extends AbstractExecutor {
    private final Introspector introspector;
    private final boolean wrapArray;

    public PropertyExecutor(Logger log, Introspector introspector, Class<?> clazz, String property) {
        this(log, introspector, clazz, property, false);
    }

    public PropertyExecutor(Logger log, Introspector introspector, Class<?> clazz, String property, boolean wrapArray) {
        this.log = log;
        this.introspector = introspector;
        this.wrapArray = wrapArray;
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            this.discover(clazz, property);
        }
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class<?> clazz, String property) {
        try {
            Object[] params = new Object[]{};
            StringBuilder sb = new StringBuilder("get");
            sb.append(property);
            this.setMethod(this.introspector.getMethod(clazz, sb.toString(), params));
            if (!this.isAlive()) {
                char c = sb.charAt(3);
                if (Character.isLowerCase(c)) {
                    sb.setCharAt(3, Character.toUpperCase(c));
                } else {
                    sb.setCharAt(3, Character.toLowerCase(c));
                }
                this.setMethod(this.introspector.getMethod(clazz, sb.toString(), params));
            }
            if (!this.isAlive()) {
                this.setMethod(this.introspector.getMethod(clazz, property, params));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Exception while looking for property getter for '" + property + "'";
            this.log.error(msg, (Throwable)e);
            throw new VelocityException(msg, e);
        }
    }

    @Override
    public Object execute(Object o) throws IllegalAccessException, InvocationTargetException {
        if (this.wrapArray) {
            o = new ArrayListWrapper(o);
        }
        return this.isAlive() ? this.getMethod().invoke(o, (Object[])null) : null;
    }
}

