/*
 * Copyright 2008 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.gen;

/**
 * Interface to represent the constants contained in resource bundle:
 * 'com/google/gwt/i18n/client/gen/TestBadKeys.properties'.
 */
public interface TestBadKeys extends
    com.google.gwt.i18n.client.ConstantsWithLookup {

  /**
   * Translated "andStar".
   * 
   * @return translated "andStar"
   */
  @DefaultStringValue("andStar")
  @Key("&*")
  String __();

  /**
   * Translated
   * "________________________________________________________________".
   * 
   * @return translated
   *         "________________________________________________________________"
   */
  @DefaultStringValue("________________________________________________________________")
  @Key("----------------------------------------------------------------")
  String ________________________________________________________________();

  /**
   * Translated "__s".
   * 
   * @return translated "__s"
   */
  @DefaultStringValue("__s")
  @Key("--s")
  String __s();

  /**
   * Translated "__s_dup".
   * 
   * @return translated "__s_dup"
   */
  @DefaultStringValue("__s_dup")
  @Key("-.s")
  String __s_dup();

  /**
   * Translated "_c_____".
   * 
   * @return translated "_c_____"
   */
  @DefaultStringValue("_c_____")
  @Key("-c..-.-")
  String _c_____();

  /**
   * Translated "__dup".
   * 
   * @return translated "__dup"
   */
  @DefaultStringValue("__dup")
  @Key(".")
  String __dup();

  /**
   * Translated "__s_dup_dup".
   * 
   * @return translated "__s_dup_dup"
   */
  @DefaultStringValue("__s_dup_dup")
  @Key("..s")
  String __s_dup_dup();

  /**
   * Translated "_level".
   * 
   * @return translated "_level"
   */
  @DefaultStringValue("_level")
  @Key(".level")
  String _level();

  /**
   * Translated "AWT_end".
   * 
   * @return translated "AWT_end"
   */
  @DefaultStringValue("AWT_end")
  @Key("AWT.end")
  String AWT_end();

  /**
   * Translated "AWT_f5".
   * 
   * @return translated "AWT_f5"
   */
  @DefaultStringValue("AWT_f5")
  @Key("AWT.f5")
  String AWT_f5();

  /**
   * Translated "Cursor_MoveDrop_32x32_File".
   * 
   * @return translated "Cursor_MoveDrop_32x32_File"
   */
  @DefaultStringValue("Cursor_MoveDrop_32x32_File")
  @Key("Cursor.MoveDrop.32x32.File")
  String Cursor_MoveDrop_32x32_File();

  /**
   * Translated "_1_2_3_4".
   * 
   * @return translated "_1_2_3_4"
   */
  @DefaultStringValue("_1_2_3_4")
  @Key("_1.2.3.4")
  String _1_2_3_4();

  /**
   * Translated "a__b".
   * 
   * @return translated "a__b"
   */
  @DefaultStringValue("a__b")
  @Key("a-.b")
  String a__b();

  /**
   * Translated "a_b_c".
   * 
   * @return translated "a_b_c"
   */
  @DefaultStringValue("a_b_c")
  @Key("a-b-c")
  String a_b_c();

  /**
   * Translated "cell_2_5".
   * 
   * @return translated "cell_2_5"
   */
  @DefaultStringValue("cell_2_5")
  @Key("cell.2.5")
  String cell_2_5();

  /**
   * Translated "entity_160".
   * 
   * @return translated "entity_160"
   */
  @DefaultStringValue("entity_160")
  @Key("entity.160")
  String entity_160();

  /**
   * Translated "logger_org_hibernate_jdbc".
   * 
   * @return translated "logger_org_hibernate_jdbc"
   */
  @DefaultStringValue("logger_org_hibernate_jdbc")
  @Key("logger.org.hibernate.jdbc")
  String logger_org_hibernate_jdbc();

  /**
   * Translated "maven_checkstyle_properties".
   * 
   * @return translated "maven_checkstyle_properties"
   */
  @DefaultStringValue("maven_checkstyle_properties")
  @Key("maven.checkstyle.properties")
  String maven_checkstyle_properties();

  /**
   * Translated "maven_jdiff_old_tag".
   * 
   * @return translated "maven_jdiff_old_tag"
   */
  @DefaultStringValue("maven_jdiff_old_tag")
  @Key("maven.jdiff.old.tag")
  String maven_jdiff_old_tag();

  /**
   * Translated "permissions_755".
   * 
   * @return translated "permissions_755"
   */
  @DefaultStringValue("permissions_755")
  @Key("permissions.755")
  String permissions_755();

  /**
   * Translated "zh_spacer".
   * 
   * @return translated "zh_spacer"
   */
  @DefaultStringValue("zh_spacer")
  @Key("zh.spacer")
  String zh_spacer();

  /**
   * Translated "e".
   * 
   * @return translated "e"
   */
  @DefaultStringValue("e")
  @Key("�")
  String __dup_dup();
}
