/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "so" locale.
 */
public class LocalizedNamesImpl_so extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "SO",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AZ",
        "AU",
        "AT",
        "CI",
        "IE",
        "IS",
        "PA",
        "BB",
        "PG",
        "BS",
        "PK",
        "PW",
        "BD",
        "BR",
        "PY",
        "BM",
        "BH",
        "PE",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "VG",
        "PN",
        "BO",
        "PL",
        "PF",
        "BA",
        "GB",
        "PT",
        "BW",
        "PR",
        "BG",
        "BF",
        "BI",
        "BN",
        "BV",
        "BT",
        "KY",
        "IQ",
        "OM",
        "DK",
        "IO",
        "TF",
        "QO",
        "DG",
        "DM",
        "GQ",
        "SV",
        "ER",
        "EE",
        "VA",
        "PS",
        "VU",
        "FR",
        "GF",
        "VE",
        "FJ",
        "PH",
        "FI",
        "VN",
        "GA",
        "GH",
        "GM",
        "GI",
        "GN",
        "GW",
        "GR",
        "GD",
        "GL",
        "GU",
        "GP",
        "GG",
        "GT",
        "GY",
        "HT",
        "HU",
        "IN",
        "HN",
        "HK",
        "IR",
        "EC",
        "AE",
        "ID",
        "ES",
        "SK",
        "SI",
        "IL",
        "SZ",
        "SE",
        "ET",
        "TD",
        "JE",
        "JP",
        "DJ",
        "JM",
        "CF",
        "CD",
        "DO",
        "DE",
        "UM",
        "AX",
        "AC",
        "FO",
        "HM",
        "IM",
        "GS",
        "IC",
        "CV",
        "CP",
        "CX",
        "CK",
        "CC",
        "MH",
        "NC",
        "NF",
        "SJ",
        "SB",
        "MP",
        "FK",
        "CZ",
        "CL",
        "GE",
        "CM",
        "KH",
        "CA",
        "BQ",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "ZA",
        "SS",
        "XK",
        "HR",
        "CR",
        "CW",
        "CU",
        "KR",
        "KP",
        "KW",
        "LA",
        "LV",
        "LR",
        "LY",
        "LT",
        "LI",
        "LS",
        "LB",
        "LU",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MG",
        "MO",
        "MW",
        "MY",
        "US",
        "EG",
        "MK",
        "YT",
        "MX",
        "EU",
        "FM",
        "MM",
        "MD",
        "MN",
        "MS",
        "MC",
        "ME",
        "MA",
        "MU",
        "MR",
        "MZ",
        "NA",
        "NR",
        "NG",
        "NE",
        "NP",
        "NL",
        "NI",
        "NU",
        "NZ",
        "NO",
        "QA",
        "UN",
        "CY",
        "RE",
        "RO",
        "RU",
        "RW",
        "ZM",
        "SA",
        "SH",
        "PM",
        "WS",
        "AS",
        "SM",
        "ST",
        "EH",
        "RS",
        "EA",
        "CN",
        "SX",
        "ZW",
        "SG",
        "SN",
        "SL",
        "LK",
        "SC",
        "SO",
        "BL",
        "VC",
        "KN",
        "LC",
        "MF",
        "SR",
        "SD",
        "SY",
        "CH",
        "TJ",
        "IT",
        "TZ",
        "TH",
        "TW",
        "TL",
        "TT",
        "TA",
        "TK",
        "TO",
        "TG",
        "TV",
        "TN",
        "TR",
        "TM",
        "TC",
        "VI",
        "UG",
        "UA",
        "JO",
        "UY",
        "UZ",
        "WF",
        "XA",
        "XB",
        "YE",
        "EZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dunida");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Waqooyi Ameerika");
    namesMap.put("005", "Koonfur Ameerika");
    namesMap.put("009", "Osheeniya");
    namesMap.put("011", "Galbeeka Afrika");
    namesMap.put("013", "Bartamaha Ameerika");
    namesMap.put("014", "Afrikada Bari");
    namesMap.put("015", "Waqooyiga Afrika");
    namesMap.put("017", "Afrikada Dhexe");
    namesMap.put("018", "Afrikada Koonfureed");
    namesMap.put("019", "Ameerikaas");
    namesMap.put("021", "Waqooyiga Ameerika");
    namesMap.put("029", "Karibiyaan");
    namesMap.put("030", "Aasiyada Bari");
    namesMap.put("034", "Aasiyada Koonfureed");
    namesMap.put("035", "Aasiyada Koonfur-galbeed");
    namesMap.put("039", "Yurubta Koonfureed");
    namesMap.put("053", "Austraalaasiya");
    namesMap.put("054", "Melaneesiya");
    namesMap.put("057", "Gobolka Aasiyada yar");
    namesMap.put("061", "Booliyneesiya");
    namesMap.put("142", "Aasiya");
    namesMap.put("143", "Bartamaha Aasiya");
    namesMap.put("145", "Aasiyada Galbeed");
    namesMap.put("150", "Yurub");
    namesMap.put("151", "Yurubta Bari");
    namesMap.put("154", "Yurubta Waqooyi");
    namesMap.put("155", "Yurubta Galbeed");
    namesMap.put("202", "Afrikada ka hooseysa Saxaraha");
    namesMap.put("419", "Laatiin Ameerika");
    namesMap.put("AC", "Jasiiradda Asensiyoon");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Imaaraadka Carabta ee Midoobay");
    namesMap.put("AF", "Afgaanistaan");
    namesMap.put("AG", "Antigua & Barbuuda");
    namesMap.put("AI", "Anguula");
    namesMap.put("AL", "Albaaniya");
    namesMap.put("AM", "Armeeniya");
    namesMap.put("AO", "Angoola");
    namesMap.put("AQ", "Antaarktika");
    namesMap.put("AR", "Arjentiina");
    namesMap.put("AS", "Samowa Ameerika");
    namesMap.put("AT", "Awsteriya");
    namesMap.put("AU", "Awstaraaliya");
    namesMap.put("AX", "Jasiiradda Aland");
    namesMap.put("AZ", "Asarbajan");
    namesMap.put("BA", "Boosniya & Harsegofina");
    namesMap.put("BB", "Baarbadoos");
    namesMap.put("BE", "Biljam");
    namesMap.put("BF", "Burkiina Faaso");
    namesMap.put("BG", "Bulgaariya");
    namesMap.put("BH", "Baxreyn");
    namesMap.put("BJ", "Biniin");
    namesMap.put("BL", "St. Baathelemiy");
    namesMap.put("BM", "Barmuuda");
    namesMap.put("BN", "Buruneeya");
    namesMap.put("BO", "Boliifiya");
    namesMap.put("BQ", "Karibiyaan Nadarlands");
    namesMap.put("BR", "Baraasiil");
    namesMap.put("BS", "Bahaamas");
    namesMap.put("BT", "Buutan");
    namesMap.put("BV", "Buufet Island");
    namesMap.put("BW", "Botuswaana");
    namesMap.put("BZ", "Beliis");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Jasiiradda Kookoos");
    namesMap.put("CD", "Jamhuuriyadda Dimuquraadiga Kongo");
    namesMap.put("CF", "Jamhuuriyadda Afrikada Dhexe");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Swiiserlaand");
    namesMap.put("CI", "Ayfori Koost");
    namesMap.put("CK", "Jasiiradda Kook");
    namesMap.put("CL", "Jili");
    namesMap.put("CM", "Kaameruun");
    namesMap.put("CN", "Shiinaha");
    namesMap.put("CO", "Kolombiya");
    namesMap.put("CP", "Jasiiradda Kilibarton");
    namesMap.put("CR", "Kosta Riika");
    namesMap.put("CU", "Kuuba");
    namesMap.put("CV", "Jasiiradda Kayb Faarde");
    namesMap.put("CW", "Kurakaaw");
    namesMap.put("CX", "Jasiiradda Kirismas");
    namesMap.put("CY", "Qubrus");
    namesMap.put("CZ", "Jekiya");
    namesMap.put("DE", "Jarmal");
    namesMap.put("DG", "Diyeego Karsiya");
    namesMap.put("DJ", "Jabuuti");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Jamhuuriyaddda Dominika");
    namesMap.put("DZ", "Aljeeriya");
    namesMap.put("EA", "Seyuta & Meliila");
    namesMap.put("EC", "Ikuwadoor");
    namesMap.put("EE", "Estooniya");
    namesMap.put("EG", "Masar");
    namesMap.put("EH", "Saxaraha Galbeed");
    namesMap.put("ER", "Eritreeya");
    namesMap.put("ES", "Isbeyn");
    namesMap.put("ET", "Itoobiya");
    namesMap.put("EU", "Midowga Yurub");
    namesMap.put("EZ", "Yurusoon");
    namesMap.put("FK", "Jaziiradaha Fooklaan");
    namesMap.put("FM", "Mikroneesiya");
    namesMap.put("FO", "Jasiiradda Faroo");
    namesMap.put("FR", "Faransiis");
    namesMap.put("GA", "Gaaboon");
    namesMap.put("GB", "Boqortooyada Midowday");
    namesMap.put("GD", "Giriinaada");
    namesMap.put("GE", "Joorjiya");
    namesMap.put("GF", "Faransiis Gini");
    namesMap.put("GG", "Guurnsey");
    namesMap.put("GH", "Gaana");
    namesMap.put("GM", "Gambiya");
    namesMap.put("GN", "Gini");
    namesMap.put("GP", "Guadeluub");
    namesMap.put("GQ", "Ekuwatooriyal Gini");
    namesMap.put("GR", "Giriig");
    namesMap.put("GS", "Jasiiradda Joorjiyada Koonfureed & Sandwij");
    namesMap.put("GT", "Guwaatamaala");
    namesMap.put("GU", "Guaam");
    namesMap.put("GW", "Gini-Bisaaw");
    namesMap.put("HK", "Hong Kong");
    namesMap.put("HM", "Jasiiradda Haad & MakDonald");
    namesMap.put("HR", "Korweeshiya");
    namesMap.put("HU", "Hangari");
    namesMap.put("IC", "Jasiiradda Kanari");
    namesMap.put("ID", "Indoneesiya");
    namesMap.put("IE", "Ayrlaand");
    namesMap.put("IL", "Israaʼiil");
    namesMap.put("IM", "Jasiiradda Isle of Man");
    namesMap.put("IN", "Hindiya");
    namesMap.put("IO", "Dhul xadeedka Badweynta Hindiya ee Biritishka");
    namesMap.put("IQ", "Ciraaq");
    namesMap.put("IR", "Iiraan");
    namesMap.put("IS", "Ayslaand");
    namesMap.put("IT", "Talyaani");
    namesMap.put("JE", "Jaarsey");
    namesMap.put("JM", "Jamaaika");
    namesMap.put("JO", "Urdun");
    namesMap.put("JP", "Jabaan");
    namesMap.put("KG", "Kirgistaan");
    namesMap.put("KH", "Kamboodiya");
    namesMap.put("KM", "Komooros");
    namesMap.put("KN", "St. Kitts & Nefis");
    namesMap.put("KP", "Kuuriyada Waqooyi");
    namesMap.put("KR", "Kuuriyada Koonfureed");
    namesMap.put("KW", "Kuwayt");
    namesMap.put("KZ", "Kasaakhistaan");
    namesMap.put("LB", "Lubnaan");
    namesMap.put("LC", "St. Lusia");
    namesMap.put("LI", "Liyjtensteyn");
    namesMap.put("LK", "Sirilaanka");
    namesMap.put("LR", "Laybeeriya");
    namesMap.put("LS", "Losooto");
    namesMap.put("LT", "Lituweeniya");
    namesMap.put("LU", "Luksemboorg");
    namesMap.put("LV", "Latfiya");
    namesMap.put("LY", "Liibya");
    namesMap.put("MA", "Morooko");
    namesMap.put("MC", "Moonako");
    namesMap.put("MD", "Moldofa");
    namesMap.put("ME", "Moontenegro");
    namesMap.put("MF", "St. Maartin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Jasiiradda Maarshal");
    namesMap.put("MK", "Masedooniya");
    namesMap.put("ML", "Maali");
    namesMap.put("MM", "Miyanmar");
    namesMap.put("MN", "Mongooliya");
    namesMap.put("MO", "Makaaw");
    namesMap.put("MP", "Jasiiradda Waqooyiga Mariaana");
    namesMap.put("MQ", "Maartinik");
    namesMap.put("MR", "Muritaaniya");
    namesMap.put("MT", "Maalta");
    namesMap.put("MU", "Murishiyoos");
    namesMap.put("MV", "Maaldiqeen");
    namesMap.put("MW", "Malaawi");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MZ", "Musambiik");
    namesMap.put("NA", "Namiibiya");
    namesMap.put("NC", "Jasiiradda Niyuu Kaledooniya");
    namesMap.put("NE", "Nayjer");
    namesMap.put("NF", "Jasiiradda Noorfolk");
    namesMap.put("NG", "Nayjeeriya");
    namesMap.put("NI", "Nikaraaguwa");
    namesMap.put("NL", "Nederlaands");
    namesMap.put("NO", "Noorweey");
    namesMap.put("NP", "Nebaal");
    namesMap.put("NZ", "Niyuusiilaand");
    namesMap.put("OM", "Cumaan");
    namesMap.put("PA", "Baanama");
    namesMap.put("PE", "Beeru");
    namesMap.put("PF", "Booliyneesiya Faransiiska");
    namesMap.put("PG", "Babua Niyuu Gini");
    namesMap.put("PH", "Filibiin");
    namesMap.put("PK", "Bakistaan");
    namesMap.put("PL", "Booland");
    namesMap.put("PM", "Saint Pierre and Miquelon");
    namesMap.put("PN", "Bitkairn");
    namesMap.put("PR", "Bueerto Riiko");
    namesMap.put("PS", "Falastiin Daanka galbeed iyo Qasa");
    namesMap.put("PT", "Bortugaal");
    namesMap.put("PW", "Balaaw");
    namesMap.put("PY", "Baraguaay");
    namesMap.put("QA", "Qadar");
    namesMap.put("QO", "Dhulxeebeedka Osheeniya");
    namesMap.put("RO", "Rumaaniya");
    namesMap.put("RS", "Seerbiya");
    namesMap.put("RU", "Ruush");
    namesMap.put("RW", "Ruwanda");
    namesMap.put("SA", "Sacuudi Carabiya");
    namesMap.put("SB", "Jasiiradda Solomon");
    namesMap.put("SC", "Sishelis");
    namesMap.put("SD", "Suudaan");
    namesMap.put("SE", "Iswidhan");
    namesMap.put("SG", "Singaboor");
    namesMap.put("SH", "Saint Helena");
    namesMap.put("SI", "islofeeniya");
    namesMap.put("SJ", "Jasiiradda Sfaldbaad & Jaan Mayen");
    namesMap.put("SK", "Islofaakiya");
    namesMap.put("SL", "Siraaliyoon");
    namesMap.put("SN", "Sinigaal");
    namesMap.put("SO", "Soomaaliya");
    namesMap.put("SR", "Surineym");
    namesMap.put("SS", "Koonfur Suudaan");
    namesMap.put("ST", "Sao Tome & Birincibal");
    namesMap.put("SV", "El Salfadoor");
    namesMap.put("SX", "Siint Maarteen");
    namesMap.put("SY", "Suuriya");
    namesMap.put("SZ", "Iswaasilaand");
    namesMap.put("TA", "Tiristan da Kunha");
    namesMap.put("TC", "Turks & Kaikos Island");
    namesMap.put("TD", "Jaad");
    namesMap.put("TF", "Dhul xadeedka Koonfureed ee Faransiiska");
    namesMap.put("TG", "Toogo");
    namesMap.put("TH", "Taylaand");
    namesMap.put("TK", "Tokelaaw");
    namesMap.put("TL", "Timoor");
    namesMap.put("TN", "Tuniisiya");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Tirinidaad & Tobago");
    namesMap.put("TV", "Tufaalu");
    namesMap.put("TW", "Taywaan");
    namesMap.put("TZ", "Tansaaniya");
    namesMap.put("UA", "Ukrayn");
    namesMap.put("UG", "Ugaanda");
    namesMap.put("UM", "Jasiiradaha ka baxsan Maraykanka");
    namesMap.put("UN", "Qaramada Midoobay");
    namesMap.put("US", "Maraykanka");
    namesMap.put("UY", "Uruguwaay");
    namesMap.put("UZ", "Uusbakistaan");
    namesMap.put("VA", "Faatikaan");
    namesMap.put("VC", "St. Finsent & Girenadiins");
    namesMap.put("VE", "Fenisuweela");
    namesMap.put("VG", "Biritish Farjin Island");
    namesMap.put("VI", "U.S Fargin Island");
    namesMap.put("VN", "Fiyetnaam");
    namesMap.put("VU", "Fanuaatu");
    namesMap.put("WF", "Walis & Futuna");
    namesMap.put("WS", "Samoowa");
    namesMap.put("XK", "Koosofo");
    namesMap.put("YE", "Yaman");
    namesMap.put("ZA", "Koonfur Afrika");
    namesMap.put("ZM", "Saambiya");
    namesMap.put("ZW", "Simbaabwe");
    namesMap.put("ZZ", "Far aan la aqoon amase aan saxnayn");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dunida",
        "002": "Afrika",
        "003": "Waqooyi Ameerika",
        "005": "Koonfur Ameerika",
        "009": "Osheeniya",
        "011": "Galbeeka Afrika",
        "013": "Bartamaha Ameerika",
        "014": "Afrikada Bari",
        "015": "Waqooyiga Afrika",
        "017": "Afrikada Dhexe",
        "018": "Afrikada Koonfureed",
        "019": "Ameerikaas",
        "021": "Waqooyiga Ameerika",
        "029": "Karibiyaan",
        "030": "Aasiyada Bari",
        "034": "Aasiyada Koonfureed",
        "035": "Aasiyada Koonfur-galbeed",
        "039": "Yurubta Koonfureed",
        "053": "Austraalaasiya",
        "054": "Melaneesiya",
        "057": "Gobolka Aasiyada yar",
        "061": "Booliyneesiya",
        "142": "Aasiya",
        "143": "Bartamaha Aasiya",
        "145": "Aasiyada Galbeed",
        "150": "Yurub",
        "151": "Yurubta Bari",
        "154": "Yurubta Waqooyi",
        "155": "Yurubta Galbeed",
        "202": "Afrikada ka hooseysa Saxaraha",
        "419": "Laatiin Ameerika",
        "AC": "Jasiiradda Asensiyoon",
        "AD": "Andora",
        "AE": "Imaaraadka Carabta ee Midoobay",
        "AF": "Afgaanistaan",
        "AG": "Antigua & Barbuuda",
        "AI": "Anguula",
        "AL": "Albaaniya",
        "AM": "Armeeniya",
        "AO": "Angoola",
        "AQ": "Antaarktika",
        "AR": "Arjentiina",
        "AS": "Samowa Ameerika",
        "AT": "Awsteriya",
        "AU": "Awstaraaliya",
        "AX": "Jasiiradda Aland",
        "AZ": "Asarbajan",
        "BA": "Boosniya & Harsegofina",
        "BB": "Baarbadoos",
        "BE": "Biljam",
        "BF": "Burkiina Faaso",
        "BG": "Bulgaariya",
        "BH": "Baxreyn",
        "BJ": "Biniin",
        "BL": "St. Baathelemiy",
        "BM": "Barmuuda",
        "BN": "Buruneeya",
        "BO": "Boliifiya",
        "BQ": "Karibiyaan Nadarlands",
        "BR": "Baraasiil",
        "BS": "Bahaamas",
        "BT": "Buutan",
        "BV": "Buufet Island",
        "BW": "Botuswaana",
        "BZ": "Beliis",
        "CA": "Kanada",
        "CC": "Jasiiradda Kookoos",
        "CD": "Jamhuuriyadda Dimuquraadiga Kongo",
        "CF": "Jamhuuriyadda Afrikada Dhexe",
        "CG": "Kongo",
        "CH": "Swiiserlaand",
        "CI": "Ayfori Koost",
        "CK": "Jasiiradda Kook",
        "CL": "Jili",
        "CM": "Kaameruun",
        "CN": "Shiinaha",
        "CO": "Kolombiya",
        "CP": "Jasiiradda Kilibarton",
        "CR": "Kosta Riika",
        "CU": "Kuuba",
        "CV": "Jasiiradda Kayb Faarde",
        "CW": "Kurakaaw",
        "CX": "Jasiiradda Kirismas",
        "CY": "Qubrus",
        "CZ": "Jekiya",
        "DE": "Jarmal",
        "DG": "Diyeego Karsiya",
        "DJ": "Jabuuti",
        "DM": "Dominika",
        "DO": "Jamhuuriyaddda Dominika",
        "DZ": "Aljeeriya",
        "EA": "Seyuta & Meliila",
        "EC": "Ikuwadoor",
        "EE": "Estooniya",
        "EG": "Masar",
        "EH": "Saxaraha Galbeed",
        "ER": "Eritreeya",
        "ES": "Isbeyn",
        "ET": "Itoobiya",
        "EU": "Midowga Yurub",
        "EZ": "Yurusoon",
        "FK": "Jaziiradaha Fooklaan",
        "FM": "Mikroneesiya",
        "FO": "Jasiiradda Faroo",
        "FR": "Faransiis",
        "GA": "Gaaboon",
        "GB": "Boqortooyada Midowday",
        "GD": "Giriinaada",
        "GE": "Joorjiya",
        "GF": "Faransiis Gini",
        "GG": "Guurnsey",
        "GH": "Gaana",
        "GM": "Gambiya",
        "GN": "Gini",
        "GP": "Guadeluub",
        "GQ": "Ekuwatooriyal Gini",
        "GR": "Giriig",
        "GS": "Jasiiradda Joorjiyada Koonfureed & Sandwij",
        "GT": "Guwaatamaala",
        "GU": "Guaam",
        "GW": "Gini-Bisaaw",
        "HK": "Hong Kong",
        "HM": "Jasiiradda Haad & MakDonald",
        "HR": "Korweeshiya",
        "HU": "Hangari",
        "IC": "Jasiiradda Kanari",
        "ID": "Indoneesiya",
        "IE": "Ayrlaand",
        "IL": "Israaʼiil",
        "IM": "Jasiiradda Isle of Man",
        "IN": "Hindiya",
        "IO": "Dhul xadeedka Badweynta Hindiya ee Biritishka",
        "IQ": "Ciraaq",
        "IR": "Iiraan",
        "IS": "Ayslaand",
        "IT": "Talyaani",
        "JE": "Jaarsey",
        "JM": "Jamaaika",
        "JO": "Urdun",
        "JP": "Jabaan",
        "KG": "Kirgistaan",
        "KH": "Kamboodiya",
        "KM": "Komooros",
        "KN": "St. Kitts & Nefis",
        "KP": "Kuuriyada Waqooyi",
        "KR": "Kuuriyada Koonfureed",
        "KW": "Kuwayt",
        "KZ": "Kasaakhistaan",
        "LB": "Lubnaan",
        "LC": "St. Lusia",
        "LI": "Liyjtensteyn",
        "LK": "Sirilaanka",
        "LR": "Laybeeriya",
        "LS": "Losooto",
        "LT": "Lituweeniya",
        "LU": "Luksemboorg",
        "LV": "Latfiya",
        "LY": "Liibya",
        "MA": "Morooko",
        "MC": "Moonako",
        "MD": "Moldofa",
        "ME": "Moontenegro",
        "MF": "St. Maartin",
        "MG": "Madagaskar",
        "MH": "Jasiiradda Maarshal",
        "MK": "Masedooniya",
        "ML": "Maali",
        "MM": "Miyanmar",
        "MN": "Mongooliya",
        "MO": "Makaaw",
        "MP": "Jasiiradda Waqooyiga Mariaana",
        "MQ": "Maartinik",
        "MR": "Muritaaniya",
        "MT": "Maalta",
        "MU": "Murishiyoos",
        "MV": "Maaldiqeen",
        "MW": "Malaawi",
        "MX": "Meksiko",
        "MZ": "Musambiik",
        "NA": "Namiibiya",
        "NC": "Jasiiradda Niyuu Kaledooniya",
        "NE": "Nayjer",
        "NF": "Jasiiradda Noorfolk",
        "NG": "Nayjeeriya",
        "NI": "Nikaraaguwa",
        "NL": "Nederlaands",
        "NO": "Noorweey",
        "NP": "Nebaal",
        "NZ": "Niyuusiilaand",
        "OM": "Cumaan",
        "PA": "Baanama",
        "PE": "Beeru",
        "PF": "Booliyneesiya Faransiiska",
        "PG": "Babua Niyuu Gini",
        "PH": "Filibiin",
        "PK": "Bakistaan",
        "PL": "Booland",
        "PM": "Saint Pierre and Miquelon",
        "PN": "Bitkairn",
        "PR": "Bueerto Riiko",
        "PS": "Falastiin Daanka galbeed iyo Qasa",
        "PT": "Bortugaal",
        "PW": "Balaaw",
        "PY": "Baraguaay",
        "QA": "Qadar",
        "QO": "Dhulxeebeedka Osheeniya",
        "RO": "Rumaaniya",
        "RS": "Seerbiya",
        "RU": "Ruush",
        "RW": "Ruwanda",
        "SA": "Sacuudi Carabiya",
        "SB": "Jasiiradda Solomon",
        "SC": "Sishelis",
        "SD": "Suudaan",
        "SE": "Iswidhan",
        "SG": "Singaboor",
        "SH": "Saint Helena",
        "SI": "islofeeniya",
        "SJ": "Jasiiradda Sfaldbaad & Jaan Mayen",
        "SK": "Islofaakiya",
        "SL": "Siraaliyoon",
        "SN": "Sinigaal",
        "SO": "Soomaaliya",
        "SR": "Surineym",
        "SS": "Koonfur Suudaan",
        "ST": "Sao Tome & Birincibal",
        "SV": "El Salfadoor",
        "SX": "Siint Maarteen",
        "SY": "Suuriya",
        "SZ": "Iswaasilaand",
        "TA": "Tiristan da Kunha",
        "TC": "Turks & Kaikos Island",
        "TD": "Jaad",
        "TF": "Dhul xadeedka Koonfureed ee Faransiiska",
        "TG": "Toogo",
        "TH": "Taylaand",
        "TK": "Tokelaaw",
        "TL": "Timoor",
        "TN": "Tuniisiya",
        "TR": "Turki",
        "TT": "Tirinidaad & Tobago",
        "TV": "Tufaalu",
        "TW": "Taywaan",
        "TZ": "Tansaaniya",
        "UA": "Ukrayn",
        "UG": "Ugaanda",
        "UM": "Jasiiradaha ka baxsan Maraykanka",
        "UN": "Qaramada Midoobay",
        "US": "Maraykanka",
        "UY": "Uruguwaay",
        "UZ": "Uusbakistaan",
        "VA": "Faatikaan",
        "VC": "St. Finsent & Girenadiins",
        "VE": "Fenisuweela",
        "VG": "Biritish Farjin Island",
        "VI": "U.S Fargin Island",
        "VN": "Fiyetnaam",
        "VU": "Fanuaatu",
        "WF": "Walis & Futuna",
        "WS": "Samoowa",
        "XK": "Koosofo",
        "YE": "Yaman",
        "ZA": "Koonfur Afrika",
        "ZM": "Saambiya",
        "ZW": "Simbaabwe",
        "ZZ": "Far aan la aqoon amase aan saxnayn"
    };
  }-*/;
}
