/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u0006\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/ChangeSet;", "", "changedClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "changedClassMembers", "", "", "changedTopLevelMembers", "Lorg/jetbrains/kotlin/name/FqName;", "(Ljava/util/Set;Ljava/util/Map;Ljava/util/Map;)V", "getChangedClassMembers", "()Ljava/util/Map;", "getChangedClasses", "()Ljava/util/Set;", "getChangedTopLevelMembers", "getChanges", "Lorg/jetbrains/kotlin/incremental/ChangesEither$Known;", "getChanges$incremental_compilation_impl", "isEmpty", "", "plus", "other", "Collector", "incremental-compilation-impl"})
public final class ChangeSet {
    @NotNull
    private final Set<ClassId> changedClasses;
    @NotNull
    private final Map<ClassId, Set<String>> changedClassMembers;
    @NotNull
    private final Map<FqName, Set<String>> changedTopLevelMembers;

    public ChangeSet(@NotNull Set<ClassId> changedClasses, @NotNull Map<ClassId, ? extends Set<String>> changedClassMembers, @NotNull Map<FqName, ? extends Set<String>> changedTopLevelMembers) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(changedClasses, (String)"changedClasses");
            Intrinsics.checkNotNullParameter(changedClassMembers, (String)"changedClassMembers");
            Intrinsics.checkNotNullParameter(changedTopLevelMembers, (String)"changedTopLevelMembers");
            this.changedClasses = changedClasses;
            this.changedClassMembers = changedClassMembers;
            this.changedTopLevelMembers = changedTopLevelMembers;
            Iterable $this$none$iv = this.changedClassMembers.keySet();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ClassId it = (ClassId)element$iv;
                    boolean bl2 = false;
                    if (!this.changedClasses.contains(it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
    }

    @NotNull
    public final Set<ClassId> getChangedClasses() {
        return this.changedClasses;
    }

    @NotNull
    public final Map<ClassId, Set<String>> getChangedClassMembers() {
        return this.changedClassMembers;
    }

    @NotNull
    public final Map<FqName, Set<String>> getChangedTopLevelMembers() {
        return this.changedTopLevelMembers;
    }

    public final boolean isEmpty() {
        return this.changedClasses.isEmpty() && this.changedClassMembers.isEmpty() && this.changedTopLevelMembers.isEmpty();
    }

    @NotNull
    public final ChangeSet plus(@NotNull ChangeSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new ChangeSet(SetsKt.plus(this.changedClasses, (Iterable)other.changedClasses), MapsKt.plus(this.changedClassMembers, other.changedClassMembers), MapsKt.plus(this.changedTopLevelMembers, other.changedTopLevelMembers));
    }

    @NotNull
    public final ChangesEither.Known getChanges$incremental_compilation_impl() {
        Set lookupSymbols = new LinkedHashSet();
        Set fqNames = new LinkedHashSet();
        Iterable $this$forEach$iv = this.changedClasses;
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName classFqName;
            ClassId it = (ClassId)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.asSingleFqName(), (String)"it.asSingleFqName()");
            String string2 = classFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classFqName.shortName().asString()");
            String string3 = classFqName.parent().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classFqName.parent().asString()");
            lookupSymbols.add(new LookupSymbol(string2, string3));
            fqNames.add(classFqName);
        }
        for (Map.Entry<ClassId, Set<String>> entry : this.changedClassMembers.entrySet()) {
            FqName classFqName;
            ClassId changedClass = entry.getKey();
            Set<String> changedClassMembers = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)changedClass.asSingleFqName(), (String)"changedClass.asSingleFqName()");
            Iterable $this$forEach$iv2 = changedClassMembers;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl3 = false;
                String string4 = classFqName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"classFqName.asString()");
                lookupSymbols.add(new LookupSymbol(it, string4));
            }
            fqNames.add(classFqName);
        }
        for (Map.Entry<Object, Set<String>> entry : this.changedTopLevelMembers.entrySet()) {
            FqName changedPackage = (FqName)entry.getKey();
            Set<String> changedTopLevelMembers = entry.getValue();
            Iterable $this$forEach$iv3 = changedTopLevelMembers;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                String it = (String)element$iv;
                boolean bl4 = false;
                String string5 = changedPackage.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"changedPackage.asString()");
                lookupSymbols.add(new LookupSymbol(it, string5));
            }
            fqNames.add(changedPackage);
        }
        return new ChangesEither.Known(lookupSymbols, fqNames);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007J\u001c\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013J\u0014\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0007J\u001c\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013J\u0006\u0010\u001b\u001a\u00020\u001cR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/ChangeSet$Collector;", "", "()V", "changedClassMembers", "", "Lorg/jetbrains/kotlin/name/ClassId;", "", "", "changedClasses", "changedTopLevelMembers", "Lorg/jetbrains/kotlin/name/FqName;", "addChangedClass", "", "className", "addChangedClassMember", "", "memberName", "addChangedClassMembers", "memberNames", "", "addChangedClasses", "classNames", "addChangedTopLevelMember", "packageName", "topLevelMember", "addChangedTopLevelMembers", "topLevelMembers", "getChanges", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ChangeSet;", "incremental-compilation-impl"})
    public static final class Collector {
        @NotNull
        private final Set<ClassId> changedClasses = new LinkedHashSet();
        @NotNull
        private final Map<ClassId, Set<String>> changedClassMembers = new LinkedHashMap();
        @NotNull
        private final Map<FqName, Set<String>> changedTopLevelMembers = new LinkedHashMap();

        public final boolean addChangedClasses(@NotNull Collection<ClassId> classNames2) {
            Intrinsics.checkNotNullParameter(classNames2, (String)"classNames");
            return this.changedClasses.addAll(classNames2);
        }

        public final boolean addChangedClass(@NotNull ClassId className2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            return this.changedClasses.add(className2);
        }

        public final void addChangedClassMembers(@NotNull ClassId className2, @NotNull Collection<String> memberNames2) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter(memberNames2, (String)"memberNames");
            if (!memberNames2.isEmpty()) {
                this.changedClassMembers.computeIfAbsent(className2, Collector::addChangedClassMembers$lambda-0).addAll(memberNames2);
            }
        }

        public final void addChangedClassMember(@NotNull ClassId className2, @NotNull String memberName) {
            Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
            Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
            this.addChangedClassMembers(className2, CollectionsKt.listOf((Object)memberName));
        }

        public final void addChangedTopLevelMembers(@NotNull FqName packageName, @NotNull Collection<String> topLevelMembers) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(topLevelMembers, (String)"topLevelMembers");
            if (!topLevelMembers.isEmpty()) {
                this.changedTopLevelMembers.computeIfAbsent(packageName, Collector::addChangedTopLevelMembers$lambda-1).addAll(topLevelMembers);
            }
        }

        public final void addChangedTopLevelMember(@NotNull FqName packageName, @NotNull String topLevelMember) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)topLevelMember, (String)"topLevelMember");
            this.addChangedTopLevelMembers(packageName, CollectionsKt.listOf((Object)topLevelMember));
        }

        @NotNull
        public final ChangeSet getChanges() {
            Iterable $this$forEach$iv = CollectionsKt.intersect((Iterable)this.changedClassMembers.keySet(), (Iterable)this.changedClasses);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassId it = (ClassId)element$iv;
                boolean bl = false;
                this.changedClassMembers.remove(it);
            }
            return new ChangeSet(CollectionsKt.toSet((Iterable)this.changedClasses), MapsKt.toMap(this.changedClassMembers), MapsKt.toMap(this.changedTopLevelMembers));
        }

        private static final Set addChangedClassMembers$lambda-0(ClassId it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set addChangedTopLevelMembers$lambda-1(FqName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }
    }
}

