/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gwt.dev.js.rhino;

import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.BinaryDigitReader;

public class ScriptRuntime {
    public static double NaN = Double.NaN;

    static double stringToNumber(String s, int start, int radix) {
        int end;
        char digitMax = '9';
        char lowerCaseBound = 'a';
        char upperCaseBound = 'A';
        int len = s.length();
        if (radix < 10) {
            digitMax = (char)(48 + radix - 1);
        }
        if (radix > 10) {
            lowerCaseBound = (char)(97 + radix - 10);
            upperCaseBound = (char)(65 + radix - 10);
        }
        double sum = 0.0;
        for (end = start; end < len; ++end) {
            int newDigit;
            char c = s.charAt(end);
            if ('0' <= c && c <= digitMax) {
                newDigit = c - 48;
            } else if ('a' <= c && c < lowerCaseBound) {
                newDigit = c - 97 + 10;
            } else {
                if ('A' > c || c >= upperCaseBound) break;
                newDigit = c - 65 + 10;
            }
            sum = sum * (double)radix + (double)newDigit;
        }
        if (start == end) {
            return NaN;
        }
        if (sum >= 9.007199254740992E15) {
            if (radix == 10) {
                try {
                    return Double.valueOf(s.substring(start, end));
                }
                catch (NumberFormatException nfe) {
                    return NaN;
                }
            }
            if (radix == 2 || radix == 4 || radix == 8 || radix == 16 || radix == 32) {
                int bit;
                BinaryDigitReader bdr = new BinaryDigitReader(radix, s, start, end);
                sum = 0.0;
                while ((bit = bdr.getNextBinaryDigit()) == 0) {
                }
                if (bit == 1) {
                    sum = 1.0;
                    for (int j = 52; j != 0; --j) {
                        bit = bdr.getNextBinaryDigit();
                        if (bit < 0) {
                            return sum;
                        }
                        sum = sum * 2.0 + (double)bit;
                    }
                    int bit54 = bdr.getNextBinaryDigit();
                    if (bit54 >= 0) {
                        int bit3;
                        double factor = 2.0;
                        int sticky = 0;
                        while ((bit3 = bdr.getNextBinaryDigit()) >= 0) {
                            sticky |= bit3;
                            factor *= 2.0;
                        }
                        sum += (double)(bit54 & (bit | sticky));
                        sum *= factor;
                    }
                }
            }
        }
        return sum;
    }
}

