/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordLemmaTag;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Morpha;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Function;
import java.util.logging.Logger;

public class Morphology
implements Function {
    private static final Logger LOGGER = Logger.getLogger(Morphology.class.getName());
    private static final boolean DEBUG = false;
    private static Morpha staticLexer;
    private final Morpha lexer;

    public Morphology() {
        this.lexer = new Morpha(System.in);
    }

    public Morphology(Reader in) {
        this.lexer = new Morpha(in);
    }

    public Morphology(Reader in, int flags) {
        this.lexer = new Morpha(in);
        this.lexer.setOptions(flags);
    }

    public Word next() throws IOException {
        String nx = this.lexer.next();
        if (nx == null) {
            return null;
        }
        return new Word(nx);
    }

    static boolean isProper(String posTag) {
        return posTag.equals("NNP") || posTag.equals("NNPS") || posTag.equals("NP");
    }

    public Word stem(Word w) {
        return new Word(this.stem(w.value()));
    }

    public String stem(String word) {
        try {
            this.lexer.yyreset(new StringReader(word));
            this.lexer.yybegin(6);
            String wordRes = this.lexer.next();
            return wordRes;
        }
        catch (IOException e) {
            LOGGER.warning("Morphology.stem() had error on word " + word);
            return word;
        }
    }

    public String lemma(String word, String tag) {
        return Morphology.lemmatize(word, tag, this.lexer, this.lexer.option(1));
    }

    public String lemma(String word, String tag, boolean lowercase) {
        return Morphology.lemmatize(word, tag, this.lexer, lowercase);
    }

    public void stem(CoreLabel label) {
        this.stem(label, CoreAnnotations.LemmaAnnotation.class);
    }

    public void stem(CoreLabel label, Class<? extends CoreAnnotation<String>> ann) {
        String lemma = Morphology.lemmatize(label.word(), label.tag(), this.lexer, this.lexer.option(1));
        label.set(ann, lemma);
    }

    private static String lemmatize(String word, String tag, Morpha lexer, boolean lowercase) {
        boolean wordHasForbiddenChar = word.indexOf(95) >= 0 || word.indexOf(32) >= 0 || word.indexOf(10) >= 0;
        String quotedWord = word;
        if (wordHasForbiddenChar) {
            quotedWord = quotedWord.replaceAll("_", "\u1cf0");
            quotedWord = quotedWord.replaceAll(" ", "\u1cf1");
            quotedWord = quotedWord.replaceAll("\n", "\u1cf2");
        }
        String wordtag = quotedWord + '_' + tag;
        try {
            lexer.setOption(1, lowercase);
            lexer.yyreset(new StringReader(wordtag));
            lexer.yybegin(8);
            String wordRes = lexer.next();
            lexer.next();
            if (wordHasForbiddenChar) {
                wordRes = wordRes.replaceAll("\u1cf0", "_");
                wordRes = wordRes.replaceAll("\u1cf1", " ");
                wordRes = wordRes.replaceAll("\u1cf2", "\n");
            }
            return wordRes;
        }
        catch (IOException e) {
            LOGGER.warning("Morphology.stem() had error on word " + word + "/" + tag);
            return word;
        }
    }

    private static synchronized void initStaticLexer() {
        if (staticLexer == null) {
            staticLexer = new Morpha(System.in);
        }
    }

    public static WordTag stemStatic(String word, String tag) {
        Morphology.initStaticLexer();
        return new WordTag(Morphology.lemmatize(word, tag, staticLexer, staticLexer.option(1)), tag);
    }

    public static String lemmaStatic(String word, String tag, boolean lowercase) {
        Morphology.initStaticLexer();
        return Morphology.lemmatize(word, tag, staticLexer, lowercase);
    }

    public static synchronized WordTag stemStaticSynchronized(String word, String tag) {
        return Morphology.stemStatic(word, tag);
    }

    public static synchronized String lemmaStaticSynchronized(String word, String tag, boolean lowercase) {
        return Morphology.lemmaStatic(word, tag, lowercase);
    }

    public static WordTag stemStatic(WordTag wT) {
        return Morphology.stemStatic(wT.word(), wT.tag());
    }

    public Object apply(Object in) {
        if (in instanceof WordTag) {
            WordTag wt = (WordTag)in;
            String tag = wt.tag();
            return new WordTag(Morphology.lemmatize(wt.word(), tag, this.lexer, this.lexer.option(1)), tag);
        }
        if (in instanceof Word) {
            return this.stem((Word)in);
        }
        return in;
    }

    public WordLemmaTag lemmatize(WordTag wT) {
        String tag = wT.tag();
        String word = wT.word();
        String lemma = this.lemma(word, tag);
        return new WordLemmaTag(word, lemma, tag);
    }

    public static WordLemmaTag lemmatizeStatic(WordTag wT) {
        String tag = wT.tag();
        String word = wT.word();
        String lemma = Morphology.stemStatic(wT).word();
        return new WordLemmaTag(word, lemma, tag);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("java Morphology [-rebuildVerbTable file|-stem word+|file+]");
        } else if (args.length == 2 && args[0].equals("-rebuildVerbTable")) {
            String verbs = IOUtils.slurpFile(args[1]);
            String[] words = verbs.split("\\s+");
            System.out.print(" private static final String[] verbStems = { ");
            for (int i = 0; i < words.length; ++i) {
                System.out.print("\"" + words[i] + "\"");
                if (i == words.length - 1) continue;
                System.out.print(", ");
                if (i % 5 != 0) continue;
                System.out.println();
                System.out.print("    ");
            }
            System.out.println(" };");
        } else if (args[0].equals("-stem")) {
            for (int i = 1; i < args.length; ++i) {
                System.out.println(args[i] + " --> " + Morphology.stemStatic(WordTag.valueOf(args[i], "_")));
            }
        } else {
            int flags = 0;
            for (String arg : args) {
                Word next;
                if (arg.charAt(0) == '-') {
                    try {
                        flags = Integer.parseInt(arg.substring(1));
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Couldn't handle flag: " + arg + "\n");
                    }
                    continue;
                }
                Morphology morph = new Morphology(new FileReader(arg), flags);
                while ((next = morph.next()) != null) {
                    System.out.print(next);
                }
            }
        }
    }
}

