/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.cache;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.javaruntype.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentCache<K, V> {
    private static final int DEFAULT_MAX_ELEMENTS = 100;
    private final ConcurrentHashMap<K, V> cache;
    private final int maxElements;
    private final Queue<K> keysQueue;

    public ConcurrentCache() {
        this(100);
    }

    public ConcurrentCache(int maxElements) {
        Utils.validateIsTrue(maxElements > 1, "Max elements must be > 1");
        this.cache = new ConcurrentHashMap();
        this.maxElements = maxElements;
        this.keysQueue = new ConcurrentLinkedQueue<K>();
    }

    public void clear() {
        this.cache.clear();
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public V computeAndGet(K key, V value) {
        V result = this.cache.get(key);
        if (result == null && (result = this.cache.putIfAbsent(key, value)) == null) {
            result = value;
            int excessElements = this.cache.size() - this.maxElements;
            for (int i = 0; i < excessElements; ++i) {
                K keyToRemove = this.keysQueue.poll();
                this.cache.remove(keyToRemove);
            }
            this.keysQueue.add(key);
        }
        return result;
    }
}

