/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnmodifiableHashMap<K, V>
implements Map<K, V> {
    @NotNull
    private final HashingStrategy<K> strategy;
    private final Object @NotNull [] data;
    private final K k1;
    private final K k2;
    private final K k3;
    private final V v1;
    private final V v2;
    private final V v3;
    private final int size;
    private Set<K> keySet;
    private Collection<V> values;

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> empty() {
        return UnmodifiableHashMap.empty(HashingStrategy.canonical());
    }

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> empty(HashingStrategy<K> strategy) {
        return new UnmodifiableHashMap<Object, Object>(strategy, ArrayUtilRt.EMPTY_OBJECT_ARRAY, null, null, null, null, null, null);
    }

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> fromMap(@NotNull HashingStrategy<K> strategy, @NotNull Map<? extends K, ? extends V> map) {
        if (strategy == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(1);
        }
        if (map == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(2);
        }
        if (map instanceof UnmodifiableHashMap && ((UnmodifiableHashMap)map).strategy == strategy) {
            UnmodifiableHashMap unmodifiableHashMap = (UnmodifiableHashMap)map;
            if (unmodifiableHashMap == null) {
                UnmodifiableHashMap.$$$reportNull$$$0(3);
            }
            return unmodifiableHashMap;
        }
        if (map.size() <= 3) {
            K k1 = null;
            K k2 = null;
            K k3 = null;
            V v1 = null;
            V v2 = null;
            V v3 = null;
            Iterator<Map.Entry<K, V>> iterator2 = map.entrySet().iterator();
            if (iterator2.hasNext()) {
                Map.Entry<K, V> e = iterator2.next();
                k1 = e.getKey();
                v1 = e.getValue();
                if (iterator2.hasNext()) {
                    e = iterator2.next();
                    k2 = e.getKey();
                    v2 = e.getValue();
                    if (iterator2.hasNext()) {
                        e = iterator2.next();
                        k3 = e.getKey();
                        v3 = e.getValue();
                        assert (!iterator2.hasNext());
                    }
                }
            }
            return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)strategy, ArrayUtilRt.EMPTY_OBJECT_ARRAY, k1, v1, k2, v2, k3, v3);
        }
        Object[] newData = new Object[map.size() * 4];
        map.forEach((k, v) -> UnmodifiableHashMap.insert(strategy, newData, Objects.requireNonNull(k), v));
        return new UnmodifiableHashMap<Object, Object>(strategy, newData, null, null, null, null, null, null);
    }

    private UnmodifiableHashMap(@NotNull HashingStrategy<K> strategy, Object @NotNull [] data, @Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3) {
        if (strategy == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(4);
        }
        if (data == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(5);
        }
        this.strategy = strategy;
        this.data = data;
        this.k1 = k1;
        this.k2 = k2;
        this.k3 = k3;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.size = data.length / 4 + (k1 == null ? 0 : (k2 == null ? 1 : (k3 == null ? 2 : 3)));
    }

    @Contract(pure=true)
    @NotNull
    public UnmodifiableHashMap<K, V> without(@NotNull K key) {
        int pos;
        if (key == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(6);
        }
        int n = pos = this.data.length == 0 ? -1 : UnmodifiableHashMap.tablePos(this.strategy, this.data, key);
        if (pos >= 0) {
            Object[] newData = new Object[(this.size - 1) * 4];
            for (int i = 0; i < this.data.length; i += 2) {
                Object k;
                if (i == pos || (k = this.data[i]) == null) continue;
                Object v = this.data[i + 1];
                UnmodifiableHashMap.insert(this.strategy, newData, k, v);
            }
            if (this.k1 != null) {
                UnmodifiableHashMap.insert(this.strategy, newData, this.k1, this.v1);
                if (this.k2 != null) {
                    UnmodifiableHashMap.insert(this.strategy, newData, this.k2, this.v2);
                    if (this.k3 != null) {
                        UnmodifiableHashMap.insert(this.strategy, newData, this.k3, this.v3);
                    }
                }
            }
            return new UnmodifiableHashMap<Object, Object>(this.strategy, newData, null, null, null, null, null, null);
        }
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, key)) {
                return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, this.k2, this.v2, this.k3, this.v3, null, null);
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, key)) {
                    return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, this.k3, this.v3, null, null);
                }
                if (this.k3 != null && this.strategy.equals(this.k3, key)) {
                    return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, null, null);
                }
            }
        }
        UnmodifiableHashMap unmodifiableHashMap = this;
        if (unmodifiableHashMap == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(7);
        }
        return unmodifiableHashMap;
    }

    @Contract(pure=true)
    @NotNull
    public UnmodifiableHashMap<K, V> with(@NotNull K key, @Nullable V value2) {
        int pos;
        if (key == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(8);
        }
        int n = pos = this.data.length == 0 ? -1 : UnmodifiableHashMap.tablePos(this.strategy, this.data, key);
        if (pos >= 0) {
            if (this.data[pos + 1] == value2) {
                UnmodifiableHashMap<K, V> unmodifiableHashMap = this;
                if (unmodifiableHashMap == null) {
                    UnmodifiableHashMap.$$$reportNull$$$0(9);
                }
                return unmodifiableHashMap;
            }
            Object[] copy = (Object[])this.data.clone();
            copy[pos + 1] = value2;
            return new UnmodifiableHashMap<K, V>(this.strategy, copy, this.k1, this.v1, this.k2, this.v2, this.k3, this.v3);
        }
        if (this.k1 == null) {
            return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, key, value2, null, null, null, null);
        }
        if (this.strategy.equals(this.k1, key)) {
            return value2 == this.v1 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, value2, this.k2, this.v2, this.k3, this.v3);
        }
        if (this.k2 == null) {
            return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, key, value2, null, null);
        }
        if (this.strategy.equals(this.k2, key)) {
            return value2 == this.v2 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, value2, this.k3, this.v3);
        }
        if (this.k3 == null) {
            return new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, key, value2);
        }
        if (this.strategy.equals(this.k3, key)) {
            return value2 == this.v3 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, this.k3, value2);
        }
        Object[] newData = new Object[(this.size + 1) * 4];
        for (int i = 0; i < this.data.length; i += 2) {
            Object k = this.data[i];
            if (k == null) continue;
            Object v = this.data[i + 1];
            UnmodifiableHashMap.insert(this.strategy, newData, k, v);
        }
        UnmodifiableHashMap.insert(this.strategy, newData, this.k1, this.v1);
        UnmodifiableHashMap.insert(this.strategy, newData, this.k2, this.v2);
        UnmodifiableHashMap.insert(this.strategy, newData, this.k3, this.v3);
        UnmodifiableHashMap.insert(this.strategy, newData, key, value2);
        return new UnmodifiableHashMap<Object, Object>(this.strategy, newData, null, null, null, null, null, null);
    }

    @NotNull
    public UnmodifiableHashMap<K, V> withAll(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(10);
        }
        if (map.isEmpty()) {
            UnmodifiableHashMap unmodifiableHashMap = this;
            if (unmodifiableHashMap == null) {
                UnmodifiableHashMap.$$$reportNull$$$0(11);
            }
            return unmodifiableHashMap;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            UnmodifiableHashMap<K, V> unmodifiableHashMap = this.with(entry.getKey(), entry.getValue());
            if (unmodifiableHashMap == null) {
                UnmodifiableHashMap.$$$reportNull$$$0(12);
            }
            return unmodifiableHashMap;
        }
        Object2ObjectOpenCustomHashMap<K, V> newMap2 = new Object2ObjectOpenCustomHashMap<K, V>(this, new Hash.Strategy<K>(){

            @Override
            public int hashCode(@Nullable K o) {
                return o == null ? 0 : UnmodifiableHashMap.this.strategy.hashCode(o);
            }

            @Override
            public boolean equals(@Nullable K a, @Nullable K b) {
                return a == b || a != null && b != null && UnmodifiableHashMap.this.strategy.equals(a, b);
            }
        });
        newMap2.putAll(map);
        return UnmodifiableHashMap.fromMap(this.strategy, newMap2);
    }

    private static <K> void insert(HashingStrategy<K> strategy, Object[] data, K k, Object v) {
        int insertPos = UnmodifiableHashMap.tablePos(strategy, data, k);
        assert ((insertPos ^= 0xFFFFFFFF) >= 0);
        data[insertPos] = k;
        data[insertPos + 1] = v;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        Object typedKey = key;
        if (this.data.length > 0 && UnmodifiableHashMap.tablePos(this.strategy, this.data, typedKey) >= 0) {
            return true;
        }
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, typedKey)) {
                return true;
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, typedKey)) {
                    return true;
                }
                if (this.k3 != null) {
                    return this.strategy.equals(this.k3, typedKey);
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value2) {
        if (this.k1 != null) {
            if (Objects.equals(this.v1, value2)) {
                return true;
            }
            if (this.k2 != null) {
                if (Objects.equals(this.v2, value2)) {
                    return true;
                }
                if (this.k3 != null && Objects.equals(this.v3, value2)) {
                    return true;
                }
            }
        }
        for (int i = 0; i < this.data.length; i += 2) {
            if (this.data[i] == null || !Objects.equals(this.data[i + 1], value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.getOrDefault(key, null);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Object typedKey = key;
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, typedKey)) {
                return this.v1;
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, typedKey)) {
                    return this.v2;
                }
                if (this.k3 != null && this.strategy.equals(this.k3, typedKey)) {
                    return this.v3;
                }
            }
        }
        if (this.data.length == 0) {
            return defaultValue;
        }
        int pos = UnmodifiableHashMap.tablePos(this.strategy, this.data, typedKey);
        V v = pos < 0 ? defaultValue : this.data[pos + 1];
        return v;
    }

    private static <K> int tablePos(HashingStrategy<K> strategy, Object[] data, K key) {
        int pos = Math.floorMod(strategy.hashCode(key), data.length / 2) * 2;
        Object candidate2;
        while ((candidate2 = data[pos]) != null) {
            if (strategy.equals(candidate2, key)) {
                return pos;
            }
            if ((pos += 2) != data.length) continue;
            pos = 0;
        }
        return ~pos;
    }

    @Override
    public int hashCode() {
        int h = 0;
        if (this.k1 != null) {
            h += this.strategy.hashCode(this.k1) ^ Objects.hashCode(this.v1);
            if (this.k2 != null) {
                h += this.strategy.hashCode(this.k2) ^ Objects.hashCode(this.v2);
                if (this.k3 != null) {
                    h += this.strategy.hashCode(this.k3) ^ Objects.hashCode(this.v3);
                }
            }
        }
        for (int i = 0; i < this.data.length; i += 2) {
            Object key = this.data[i];
            if (key == null) continue;
            h += this.strategy.hashCode(key) ^ Objects.hashCode(this.data[i + 1]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        if (this.size() != map.size()) {
            return false;
        }
        if (this.k1 != null) {
            if (!Objects.equals(map.get(this.k1), this.v1)) {
                return false;
            }
            if (this.k2 != null) {
                if (!Objects.equals(map.get(this.k2), this.v2)) {
                    return false;
                }
                if (this.k3 != null && !Objects.equals(map.get(this.k3), this.v3)) {
                    return false;
                }
            }
        }
        for (int i = 0; i < this.data.length; i += 2) {
            Object key = this.data[i];
            if (key == null || Objects.equals(map.get(key), this.data[i + 1])) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public V put(K key, V value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.k1 != null) {
            if (this.k2 != null) {
                if (this.k3 != null) {
                    action.accept(this.k3, this.v3);
                }
                action.accept(this.k2, this.v2);
            }
            action.accept(this.k1, this.v1);
        }
        for (int i = 0; i < this.data.length; i += 2) {
            Object key = this.data[i];
            if (key == null) continue;
            action.accept(key, this.data[i + 1]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.forEach((k, v) -> {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(k).append('=').append(v);
        });
        return sb.append('}').toString();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                @NotNull
                public Iterator<K> iterator() {
                    return new MyIterator(){

                        K fieldElement(int offset) {
                            return offset == 0 ? UnmodifiableHashMap.this.k1 : (offset == 1 ? UnmodifiableHashMap.this.k2 : UnmodifiableHashMap.this.k3);
                        }

                        K tableElement(int offset) {
                            return UnmodifiableHashMap.this.data[offset];
                        }
                    };
                }

                @Override
                public void forEach(Consumer<? super K> action) {
                    if (UnmodifiableHashMap.this.k1 != null) {
                        if (UnmodifiableHashMap.this.k2 != null) {
                            if (UnmodifiableHashMap.this.k3 != null) {
                                action.accept(UnmodifiableHashMap.this.k3);
                            }
                            action.accept(UnmodifiableHashMap.this.k2);
                        }
                        action.accept(UnmodifiableHashMap.this.k1);
                    }
                    for (int i = 0; i < UnmodifiableHashMap.this.data.length; i += 2) {
                        Object key = UnmodifiableHashMap.this.data[i];
                        if (key == null) continue;
                        Object k = UnmodifiableHashMap.this.data[i];
                        action.accept(k);
                    }
                }

                @Override
                public boolean contains(Object o) {
                    return UnmodifiableHashMap.this.containsKey(o);
                }

                @Override
                public int size() {
                    return UnmodifiableHashMap.this.size();
                }
            };
        }
        Set<K> set = this.keySet;
        if (set == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(14);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    return new MyIterator(){

                        V fieldElement(int offset) {
                            return offset == 0 ? UnmodifiableHashMap.this.v1 : (offset == 1 ? UnmodifiableHashMap.this.v2 : UnmodifiableHashMap.this.v3);
                        }

                        V tableElement(int offset) {
                            return UnmodifiableHashMap.this.data[offset + 1];
                        }
                    };
                }

                @Override
                public void forEach(Consumer<? super V> action) {
                    if (UnmodifiableHashMap.this.k1 != null) {
                        if (UnmodifiableHashMap.this.k2 != null) {
                            if (UnmodifiableHashMap.this.k3 != null) {
                                action.accept(UnmodifiableHashMap.this.v3);
                            }
                            action.accept(UnmodifiableHashMap.this.v2);
                        }
                        action.accept(UnmodifiableHashMap.this.v1);
                    }
                    for (int i = 0; i < UnmodifiableHashMap.this.data.length; i += 2) {
                        Object key = UnmodifiableHashMap.this.data[i];
                        if (key == null) continue;
                        Object v = UnmodifiableHashMap.this.data[i + 1];
                        action.accept(v);
                    }
                }

                @Override
                public boolean contains(Object o) {
                    return UnmodifiableHashMap.this.containsValue(o);
                }

                @Override
                public int size() {
                    return UnmodifiableHashMap.this.size();
                }
            };
        }
        Collection<V> collection = this.values;
        if (collection == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return new MyIterator(){

                    Map.Entry<K, V> fieldElement(int offset) {
                        return offset == 0 ? new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k1, UnmodifiableHashMap.this.v1) : (offset == 1 ? new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k2, UnmodifiableHashMap.this.v2) : new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k3, UnmodifiableHashMap.this.v3));
                    }

                    Map.Entry<K, V> tableElement(int offset) {
                        return new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.data[offset], UnmodifiableHashMap.this.data[offset + 1]);
                    }
                };
            }

            @Override
            public int size() {
                return UnmodifiableHashMap.this.size();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/UnmodifiableHashMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/UnmodifiableHashMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "without";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "with";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withAll";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromMap";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "without";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withAll";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class MyIterator<E>
    implements Iterator<E> {
        int pos;

        MyIterator() {
            if (UnmodifiableHashMap.this.k1 == null) {
                this.pos = -1;
                this.advance();
            } else {
                this.pos = UnmodifiableHashMap.this.k2 == null ? -1 : (UnmodifiableHashMap.this.k3 == null ? -2 : -3);
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos < UnmodifiableHashMap.this.data.length;
        }

        private void advance() {
            this.pos = this.pos < 0 ? ++this.pos : (this.pos += 2);
            if (this.pos >= 0) {
                while (this.pos < UnmodifiableHashMap.this.data.length && UnmodifiableHashMap.this.data[this.pos] == null) {
                    ++this.pos;
                }
            }
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pos < 0) {
                int offset = ~this.pos;
                this.advance();
                return this.fieldElement(offset);
            }
            int offset = this.pos;
            this.advance();
            return this.tableElement(offset);
        }

        abstract E fieldElement(int var1);

        abstract E tableElement(int var1);
    }
}

