/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendException;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DescriptorSymbolTableExtension;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.BranchingExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.DelegatedPropertyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionException;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorWithScope;
import org.jetbrains.kotlin.psi2ir.generators.LocalClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.LocalFunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.LoopExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.OperatorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ReflectionReferencesGenerator;
import org.jetbrains.kotlin.psi2ir.generators.TryCatchExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.psi2ir.intermediate.RematerializableValueKt;
import org.jetbrains.kotlin.psi2ir.intermediate.VariableLValue;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0019\u001a\u00020\u001a*\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eJ\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u00020-2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u001a\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002082\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00109\u001a\u00020:2\u0006\u00107\u001a\u0002082\u0006\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=J\u001a\u0010?\u001a\u00020\u00022\u0006\u0010)\u001a\u00020@2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010A\u001a\u00020\u00022\u0006\u0010)\u001a\u00020B2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020D2\u0006\u0010)\u001a\u00020BH\u0002J\u001a\u0010F\u001a\u00020\u00022\u0006\u0010)\u001a\u00020G2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010H\u001a\u00020'2\u0006\u0010)\u001a\u00020I2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010J\u001a\u00020'2\u0006\u0010)\u001a\u00020#2\n\u0010K\u001a\u0006\u0012\u0002\b\u00030LJ\u001a\u0010M\u001a\u00020\u00022\u0006\u0010)\u001a\u00020N2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010O\u001a\b\u0012\u0004\u0012\u00020'0\"*\b\u0012\u0004\u0012\u00020'0\"H\u0002J\u001a\u0010P\u001a\u00020\u00022\u0006\u0010Q\u001a\u00020R2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010S\u001a\u00020\u00022\u0006\u0010Q\u001a\u00020T2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010U\u001a\u00020\u00022\u0006\u0010Q\u001a\u00020V2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010W\u001a\u00020'2\u0006\u0010)\u001a\u00020X2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010Y\u001a\u00020'2\u0006\u0010Z\u001a\u00020\u00142\u0006\u0010)\u001a\u00020#2\f\u0010[\u001a\b\u0012\u0002\b\u0003\u0018\u00010\\H\u0002J\u001a\u0010]\u001a\u00020\u00022\u0006\u0010)\u001a\u00020^2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010_\u001a\u00020\u00022\u0006\u0010)\u001a\u00020`2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010a\u001a\u00020\u00022\u0006\u0010)\u001a\u00020b2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010c\u001a\u00020\u00022\u0006\u0010)\u001a\u00020d2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0002J&\u0010i\u001a\u00020'2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020k2\u0006\u0010m\u001a\u00020\u001b2\u0006\u0010g\u001a\u00020hJ\u001a\u0010n\u001a\u00020'2\u0006\u0010)\u001a\u00020o2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010p\u001a\u00020\u00022\u0006\u0010)\u001a\u00020q2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010r\u001a\u00020\u00022\u0006\u0010)\u001a\u00020s2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010t\u001a\u00020\u00022\u0006\u0010)\u001a\u00020u2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010v\u001a\u00020\u00022\u0006\u0010)\u001a\u00020w2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010x\u001a\u00020\u00022\u0006\u0010)\u001a\u00020y2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010z\u001a\u00020\u00022\u0006\u0010)\u001a\u00020{2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010|\u001a\u00020\u00022\u0006\u0010)\u001a\u00020}2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010~\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u007f2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0080\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u0081\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0082\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u0083\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0084\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u0085\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0086\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u0087\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0088\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u0089\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u008a\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u008b\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001d\u0010\u008c\u0001\u001a\u00020\u00022\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u008f\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u0090\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001d\u0010\u0091\u0001\u001a\u00020\u00022\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001d\u0010\u0094\u0001\u001a\u00020\u00022\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0097\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u0098\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0099\u0001\u001a\u00020\u00022\u0007\u0010)\u001a\u00030\u009a\u00012\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009b\u0001"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;", "bodyGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "<init>", "(Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;Lorg/jetbrains/kotlin/ir/builders/Scope;)V", "getBodyGenerator", "()Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "getScope", "()Lorg/jetbrains/kotlin/ir/builders/Scope;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getScopeOwner", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateStatement", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateStatements", "", "ktStatements", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "to", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementContainer;", "generateExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitExpression", "expression", "data", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "generateLocalDelegatedProperty", "ktProperty", "ktDelegate", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "visitDestructuringDeclaration", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "declareComponentVariablesInBlock", "", "irBlock", "firstContainerValue", "Lorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;", "restContainerValue", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "scopeOwnerAsCallable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getReturnExpressionTarget", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "generateConstantExpression", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "postprocessStringTemplateEntries", "visitLiteralStringTemplateEntry", "entry", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "visitEscapeStringTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtEscapeStringTemplateEntry;", "visitStringTemplateEntryWithExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "generateExpressionForReferencedDescriptor", "descriptor", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "isThisForClassPhysicallyAvailable", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateThisReceiver", "startOffset", "", "endOffset", "kotlinType", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "ir.psi2ir"})
@SourceDebugExtension(value={"SMAP\nStatementGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatementGenerator.kt\norg/jetbrains/kotlin/psi2ir/generators/StatementGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Generator.kt\norg/jetbrains/kotlin/psi2ir/generators/GeneratorKt\n*L\n1#1,565:1\n1628#2,3:566\n1863#2,2:570\n1#3:569\n11158#4:572\n11493#4,3:573\n44#5:576\n44#5:577\n*S KotlinDebug\n*F\n+ 1 StatementGenerator.kt\norg/jetbrains/kotlin/psi2ir/generators/StatementGenerator\n*L\n80#1:566,3\n226#1:570,2\n297#1:572\n297#1:573,3\n462#1:576\n464#1:577\n*E\n"})
public final class StatementGenerator
extends KtVisitor
implements GeneratorWithScope {
    @NotNull
    private final BodyGenerator bodyGenerator;
    @NotNull
    private final Scope scope;
    @NotNull
    private final TypeTranslator typeTranslator;

    public StatementGenerator(@NotNull BodyGenerator bodyGenerator, @NotNull Scope scope2) {
        Intrinsics.checkNotNullParameter(bodyGenerator, "bodyGenerator");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.bodyGenerator = bodyGenerator;
        this.scope = scope2;
        this.typeTranslator = this.getContext().getTypeTranslator();
    }

    @NotNull
    public final BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    @Override
    @NotNull
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.bodyGenerator.getContext();
    }

    @NotNull
    public final DeclarationDescriptor getScopeOwner() {
        return this.bodyGenerator.getScopeOwner();
    }

    @NotNull
    public final IrType toIrType(@NotNull KotlinType $this$toIrType) {
        Intrinsics.checkNotNullParameter($this$toIrType, "<this>");
        return this.typeTranslator.translateType($this$toIrType);
    }

    @NotNull
    public final IrStatement generateStatement(@NotNull KtElement ktElement) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter(ktElement, "ktElement");
        try {
            irStatement = (IrStatement)KotlinUtilsKt.deparenthesize(ktElement).accept(this, null);
        }
        catch (BackendException e) {
            throw e;
        }
        catch (ErrorExpressionException e) {
            throw e;
        }
        catch (Throwable e) {
            irStatement = new ErrorExpressionGenerator(this).generateErrorExpression(ktElement, e);
        }
        return irStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrStatement> generateStatements(@NotNull List<? extends KtExpression> ktStatements, @NotNull IrStatementContainer to) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(ktStatements, "ktStatements");
        Intrinsics.checkNotNullParameter(to, "to");
        Iterable iterable = ktStatements;
        Collection destination$iv = to.getStatements();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(this.generateStatement((KtElement)it));
        }
        return (List)destination$iv;
    }

    @NotNull
    public final IrExpression generateExpression(@NotNull KtElement ktElement) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(ktElement, "ktElement");
        IrStatement irStatement = this.generateStatement(ktElement);
        if (irStatement instanceof IrExpression) {
            irExpression = (IrExpression)irStatement;
        } else if (irStatement instanceof IrDeclaration) {
            irExpression = BuildersKt.IrBlockImpl(irStatement.getStartOffset(), irStatement.getEndOffset(), this.getContext().getIrBuiltIns().getUnitType(), null, CollectionsKt.listOf(irStatement));
        } else {
            throw new AssertionError((Object)("Unexpected statement: " + RenderIrElementKt.render$default(irStatement, null, 1, null)));
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitExpression(@NotNull KtExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        IrType irType = this.getContext().getIrBuiltIns().getNothingType();
        String string2 = expression2.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        return BuildersKt.IrErrorExpressionImpl(n, n2, irType, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrStatement visitProperty(@NotNull KtProperty property2, @Nullable Void data) {
        IrExpression irExpression;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter(property2, "property");
        Generator generator = this;
        WritableSlice<PsiElement, VariableDescriptor> writableSlice = BindingContext.VARIABLE;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "VARIABLE");
        VariableDescriptor variableDescriptor = (VariableDescriptor)GeneratorKt.getOrFail(generator, writableSlice, property2);
        KtPropertyDelegate ktPropertyDelegate = property2.getDelegate();
        if (ktPropertyDelegate != null) {
            KtPropertyDelegate ktDelegate = ktPropertyDelegate;
            boolean bl = false;
            Intrinsics.checkNotNull(variableDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors");
            return this.generateLocalDelegatedProperty(property2, ktDelegate, (VariableDescriptorWithAccessors)variableDescriptor, this.bodyGenerator.getScopeOwnerSymbol());
        }
        if (this.getContext().getExtensions().getDebugInfoOnlyOnVariablesInDestructuringDeclarations()) {
            psiElement = property2.getNameIdentifier();
            if (psiElement == null) {
                psiElement = property2;
            }
        } else {
            psiElement = property2;
        }
        PsiElement sourceElement = psiElement;
        DescriptorSymbolTableExtension descriptorSymbolTableExtension = this.getContext().getSymbolTable().getDescriptorExtension();
        int n = PsiUtilsKt.getStartOffsetSkippingComments(sourceElement);
        int n2 = PsiUtilsKt.getEndOffset(sourceElement);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getDEFINED();
        Intrinsics.checkNotNull(variableDescriptor);
        VariableDescriptor variableDescriptor2 = variableDescriptor;
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        IrType irType = this.toIrType(kotlinType);
        KtExpression ktExpression = property2.getInitializer();
        if (ktExpression != null) {
            void it;
            KtExpression bl = ktExpression;
            IrType irType2 = irType;
            VariableDescriptor variableDescriptor3 = variableDescriptor2;
            IrDeclarationOrigin irDeclarationOrigin2 = irDeclarationOrigin;
            int n3 = n2;
            int n4 = n;
            DescriptorSymbolTableExtension descriptorSymbolTableExtension2 = descriptorSymbolTableExtension;
            boolean bl2 = false;
            IrExpression irExpression2 = this.generateExpression((KtElement)it);
            descriptorSymbolTableExtension = descriptorSymbolTableExtension2;
            n = n4;
            n2 = n3;
            irDeclarationOrigin = irDeclarationOrigin2;
            variableDescriptor2 = variableDescriptor3;
            irType = irType2;
            irExpression = irExpression2;
        } else {
            irExpression = null;
        }
        return descriptorSymbolTableExtension.declareVariable(n, n2, irDeclarationOrigin, variableDescriptor2, irType, irExpression);
    }

    private final IrStatement generateLocalDelegatedProperty(KtProperty ktProperty, KtPropertyDelegate ktDelegate, VariableDescriptorWithAccessors variableDescriptor, IrSymbol scopeOwnerSymbol) {
        return new DelegatedPropertyGenerator(this.getContext()).generateLocalDelegatedProperty(ktProperty, ktDelegate, variableDescriptor, scopeOwnerSymbol);
    }

    @NotNull
    public IrStatement visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(multiDeclaration, "multiDeclaration");
        Pair<Integer, Integer> pair = this.getContext().getExtensions().getDebugInfoOnlyOnVariablesInDestructuringDeclarations() ? TuplesKt.to(-2, -2) : TuplesKt.to(PsiUtilsKt.getStartOffsetSkippingComments(multiDeclaration), PsiUtilsKt.getEndOffset(multiDeclaration));
        int blockStartOffset = ((Number)pair.component1()).intValue();
        int blockEndOffset = ((Number)pair.component2()).intValue();
        IrCompositeImpl irBlock = BuildersKt.IrCompositeImpl(blockStartOffset, blockEndOffset, this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getDESTRUCTURING_DECLARATION());
        KtExpression ktExpression = multiDeclaration.getInitializer();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression ktInitializer = ktExpression;
        IrExpression irInitializer = this.generateExpression(ktInitializer);
        IrVariable containerVariable = RematerializableValueKt.declareTemporaryVariableInBlock$default(this.getScope(), irInitializer, irBlock, "container", 0, 0, 24, null);
        VariableLValue firstContainerValue = new VariableLValue(this.getContext(), containerVariable, null, 0, 0, 28, null);
        this.declareComponentVariablesInBlock(multiDeclaration, irBlock, firstContainerValue, this.getContext().getExtensions().getDebugInfoOnlyOnVariablesInDestructuringDeclarations() ? new VariableLValue(this.getContext(), containerVariable, null, -2, -2, 4, null) : firstContainerValue);
        return irBlock;
    }

    public final void declareComponentVariablesInBlock(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull IrStatementContainer irBlock, @NotNull IntermediateValue firstContainerValue, @NotNull IntermediateValue restContainerValue) {
        Intrinsics.checkNotNullParameter(multiDeclaration, "multiDeclaration");
        Intrinsics.checkNotNullParameter(irBlock, "irBlock");
        Intrinsics.checkNotNullParameter(firstContainerValue, "firstContainerValue");
        Intrinsics.checkNotNullParameter(restContainerValue, "restContainerValue");
        CallGenerator callGenerator = new CallGenerator(this);
        IntermediateValue containerValue = firstContainerValue;
        Iterator iterator2 = ((Iterable)multiDeclaration.getEntries()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            PsiElement psiElement;
            PsiElement psiElement2;
            Pair<Integer, Integer> pair;
            int index = n++;
            KtDestructuringDeclarationEntry ktEntry = (KtDestructuringDeclarationEntry)iterator2.next();
            Generator generator = this;
            WritableSlice<PsiElement, VariableDescriptor> writableSlice = BindingContext.VARIABLE;
            Intrinsics.checkNotNullExpressionValue(writableSlice, "VARIABLE");
            VariableDescriptor componentVariable = (VariableDescriptor)GeneratorKt.getOrFail(generator, writableSlice, ktEntry);
            if (componentVariable.getName().isSpecial()) continue;
            Generator generator2 = this;
            WritableSlice<KtDestructuringDeclarationEntry, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.COMPONENT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice2, "COMPONENT_RESOLVED_CALL");
            ResolvedCall componentResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator2, writableSlice2, ktEntry);
            Intrinsics.checkNotNull(componentResolvedCall);
            CallBuilder componentSubstitutedCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, componentResolvedCall);
            CallBuilderKt.setExplicitReceiverValue(componentSubstitutedCall, containerValue);
            containerValue = restContainerValue;
            if (this.getContext().getExtensions().getDebugInfoOnlyOnVariablesInDestructuringDeclarations()) {
                pair = TuplesKt.to(-2, -2);
            } else {
                Intrinsics.checkNotNull(ktEntry);
                pair = TuplesKt.to(PsiUtilsKt.getStartOffsetSkippingComments(ktEntry), PsiUtilsKt.getEndOffset(ktEntry));
            }
            Pair<Integer, Integer> pair2 = pair;
            int componentCallStartOffset = ((Number)pair2.component1()).intValue();
            int componentCallEndOffset = ((Number)pair2.component2()).intValue();
            IrExpression irComponentCall = callGenerator.generateCall(componentCallStartOffset, componentCallEndOffset, componentSubstitutedCall, IrStatementOrigin.COMPONENT_N.Companion.withIndex(index + 1));
            if (this.getContext().getExtensions().getDebugInfoOnlyOnVariablesInDestructuringDeclarations()) {
                PsiElement psiElement3 = ktEntry.getNameIdentifier();
                if (psiElement3 == null) {
                    psiElement3 = ktEntry;
                }
                psiElement2 = psiElement3;
                Intrinsics.checkNotNull(psiElement2);
                psiElement = psiElement2;
            } else {
                psiElement2 = ktEntry;
                Intrinsics.checkNotNull(psiElement2);
                psiElement = psiElement2;
            }
            PsiElement componentVarOffsetSource = psiElement;
            DescriptorSymbolTableExtension descriptorSymbolTableExtension = this.getContext().getSymbolTable().getDescriptorExtension();
            int n2 = PsiUtilsKt.getStartOffsetSkippingComments(componentVarOffsetSource);
            int n3 = PsiUtilsKt.getEndOffset(componentVarOffsetSource);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getDEFINED();
            Intrinsics.checkNotNull(componentVariable);
            KotlinType kotlinType = componentVariable.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            IrVariable irComponentVar = descriptorSymbolTableExtension.declareVariable(n2, n3, irDeclarationOrigin, componentVariable, this.toIrType(kotlinType), irComponentCall);
            irBlock.getStatements().add(irComponentVar);
        }
    }

    @NotNull
    public IrStatement visitBlockExpression(@NotNull KtBlockExpression expression2, @Nullable Void data) {
        boolean isBlockBody;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        boolean bl = isBlockBody = expression2.getParent() instanceof KtDeclarationWithBody && !(expression2.getParent() instanceof KtFunctionLiteral);
        if (isBlockBody) {
            throw new AssertionError((Object)"Use IrBlockBody and corresponding body generator to generate blocks as function bodies");
        }
        KotlinType returnType = GeneratorKt.getExpressionTypeWithCoercionToUnitOrFail(this, expression2);
        IrBlockImpl irBlock = BuildersKt.IrBlockImpl$default(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.toIrType(returnType), null, 8, null);
        List<KtExpression> list = expression2.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression it = (KtExpression)element$iv;
            boolean bl2 = false;
            List<IrStatement> list2 = irBlock.getStatements();
            Intrinsics.checkNotNull(it);
            list2.add(this.generateStatement(it));
        }
        return irBlock;
    }

    @NotNull
    public IrStatement visitReturnExpression(@NotNull KtReturnExpression expression2, @Nullable Void data) {
        Object object;
        CallableDescriptor returnTarget;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                returnTarget = this.getReturnExpressionTarget(expression2);
                object = expression2.getReturnedExpression();
                if (object == null) break block2;
                KtExpression it = object;
                boolean bl = false;
                IrExpression irExpression = this.generateExpression(it);
                object = irExpression;
                if (irExpression != null) break block3;
            }
            object = BuildersKt.IrGetObjectValueImpl(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.getContext().getIrBuiltIns().getUnitType(), this.getContext().getIrBuiltIns().getUnitClass());
        }
        Object irReturnedExpression = object;
        return new IrReturnImpl(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.getContext().getIrBuiltIns().getNothingType(), IrUtilsKt.referenceFunction(this.getContext().getSymbolTable(), returnTarget), (IrExpression)irReturnedExpression);
    }

    private final CallableDescriptor scopeOwnerAsCallable() {
        DeclarationDescriptor declarationDescriptor = this.getScopeOwner();
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (callableDescriptor == null) {
            throw new AssertionError((Object)("'return' in a non-callable: " + this.getScopeOwner()));
        }
        return callableDescriptor;
    }

    private final CallableDescriptor getReturnExpressionTarget(KtReturnExpression expression2) {
        CallableDescriptor callableDescriptor;
        if (!ExpressionTypingUtils.isFunctionLiteral(this.getScopeOwner()) && !ExpressionTypingUtils.isFunctionExpression(this.getScopeOwner())) {
            callableDescriptor = this.scopeOwnerAsCallable();
        } else {
            KtSimpleNameExpression label = expression2.getTargetLabel();
            if (label != null) {
                Generator generator = this;
                WritableSlice<KtReferenceExpression, PsiElement> writableSlice = BindingContext.LABEL_TARGET;
                Intrinsics.checkNotNullExpressionValue(writableSlice, "LABEL_TARGET");
                PsiElement labelTarget = (PsiElement)GeneratorKt.getOrFail(generator, writableSlice, label);
                Generator generator2 = this;
                ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
                Intrinsics.checkNotNullExpressionValue(readOnlySlice, "DECLARATION_TO_DESCRIPTOR");
                DeclarationDescriptor labelTargetDescriptor = GeneratorKt.getOrFail(generator2, readOnlySlice, labelTarget);
                Intrinsics.checkNotNull(labelTargetDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                callableDescriptor = (CallableDescriptor)labelTargetDescriptor;
            } else if (ExpressionTypingUtils.isFunctionLiteral(this.getScopeOwner())) {
                Object a = BindingContextUtils.getContainingFunctionSkipFunctionLiterals((DeclarationDescriptor)this.getScopeOwner(), (boolean)true).first;
                Intrinsics.checkNotNull(a);
                callableDescriptor = (CallableDescriptor)a;
            } else {
                callableDescriptor = this.scopeOwnerAsCallable();
            }
        }
        return callableDescriptor;
    }

    @NotNull
    public IrStatement visitThrowExpression(@NotNull KtThrowExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        IrType irType = this.getContext().getIrBuiltIns().getNothingType();
        KtExpression ktExpression = expression2.getThrownExpression();
        Intrinsics.checkNotNull(ktExpression);
        return BuildersKt.IrThrowImpl(n, n2, irType, this.generateExpression(ktExpression));
    }

    @NotNull
    public IrExpression visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, this.getContext().getBindingContext());
        if (compileTimeConstant == null) {
            throw new IllegalStateException(("KtConstantExpression was not evaluated: " + expression2.getText()).toString());
        }
        return this.generateConstantExpression(expression2, compileTimeConstant);
    }

    @NotNull
    public final IrExpression generateConstantExpression(@NotNull KtExpression expression2, @NotNull CompileTimeConstant<?> constant) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(constant, "constant");
        return this.getContext().getConstantValueGenerator().generateConstantValueAsExpression(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), constant.toConstantValue(GeneratorKt.getTypeInferredByFrontendOrFail(this, expression2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrStatement visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @Nullable Void data) {
        IrStatement irStatement;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int endOffset = PsiUtilsKt.getEndOffset(expression2);
        IrType resultType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, expression2));
        KtStringTemplateEntry[] ktStringTemplateEntryArray = expression2.getEntries();
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray, "getEntries(...)");
        Object[] objectArray = ktStringTemplateEntryArray;
        StatementGenerator statementGenerator = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            collection.add(this.generateExpression((KtElement)it));
        }
        List<IrExpression> entries = statementGenerator.postprocessStringTemplateEntries((List)destination$iv$iv);
        switch (entries.size()) {
            case 0: {
                irStatement = IrConstImpl.Companion.string(startOffset, endOffset, resultType, "");
                break;
            }
            case 1: {
                IrExpression irExpression;
                IrExpression first = CollectionsKt.first(entries);
                if (first instanceof IrConst && Intrinsics.areEqual(((IrConst)first).getKind(), IrConstKind.String.INSTANCE)) {
                    IrType irType = first.getType();
                    Object object = ((IrConst)first).getValue();
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
                    irExpression = IrConstImpl.Companion.string(startOffset, endOffset, irType, (String)object);
                } else {
                    irExpression = BuildersKt.IrStringConcatenationImpl(startOffset, endOffset, resultType, (Collection<? extends IrExpression>)CollectionsKt.listOf(first));
                }
                irStatement = irExpression;
                break;
            }
            default: {
                irStatement = BuildersKt.IrStringConcatenationImpl(startOffset, endOffset, resultType, (Collection<? extends IrExpression>)entries);
            }
        }
        return irStatement;
    }

    private final List<IrExpression> postprocessStringTemplateEntries(List<? extends IrExpression> $this$postprocessStringTemplateEntries) {
        ArrayList<IrExpression> arrayList;
        ArrayList<IrExpression> result2 = arrayList = new ArrayList<IrExpression>($this$postprocessStringTemplateEntries.size());
        boolean bl = false;
        IrType stringType = this.getContext().getIrBuiltIns().getStringType();
        StringBuilder constString = new StringBuilder();
        int constStringStartOffset = 0;
        int constStringEndOffset = 0;
        for (IrExpression irExpression : $this$postprocessStringTemplateEntries) {
            if (irExpression instanceof IrConst && Intrinsics.areEqual(((IrConst)irExpression).getKind(), IrConstKind.String.INSTANCE)) {
                if (((CharSequence)constString).length() == 0) {
                    constStringStartOffset = irExpression.getStartOffset();
                }
                Object object = ((IrConst)irExpression).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
                constString.append((String)object);
                constStringEndOffset = irExpression.getEndOffset();
                continue;
            }
            if (((CharSequence)constString).length() > 0) {
                String string2 = constString.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                result2.add(IrConstImpl.Companion.string(constStringStartOffset, constStringEndOffset, stringType, string2));
                StringsKt.clear(constString);
            }
            result2.add(irExpression);
        }
        if (((CharSequence)constString).length() > 0) {
            String string3 = constString.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            result2.add(IrConstImpl.Companion.string(constStringStartOffset, constStringEndOffset, stringType, string3));
        }
        return arrayList;
    }

    @NotNull
    public IrStatement visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        int n = PsiUtilsKt.getStartOffsetSkippingComments(entry);
        int n2 = PsiUtilsKt.getEndOffset(entry);
        IrType irType = this.getContext().getIrBuiltIns().getStringType();
        String string2 = entry.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        return IrConstImpl.Companion.string(n, n2, irType, string2);
    }

    @NotNull
    public IrStatement visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        int n = PsiUtilsKt.getStartOffsetSkippingComments(entry);
        int n2 = PsiUtilsKt.getEndOffset(entry);
        IrType irType = this.getContext().getIrBuiltIns().getStringType();
        String string2 = entry.getUnescapedValue();
        Intrinsics.checkNotNullExpressionValue(string2, "getUnescapedValue(...)");
        return IrConstImpl.Companion.string(n, n2, irType, string2);
    }

    @NotNull
    public IrStatement visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        KtExpression ktExpression = entry.getExpression();
        Intrinsics.checkNotNull(ktExpression);
        return this.generateExpression(ktExpression);
    }

    @NotNull
    public IrExpression visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 != null) {
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                CallBuilder variableCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall());
                return CallGeneratorKt.generateCall$default(new CallGenerator(this), expression2, variableCall, IrStatementOrigin.Companion.getVARIABLE_AS_FUNCTION(), 0, 0, 24, null);
            }
            CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getResultingDescriptor(...)");
            CallableDescriptor descriptor = callableDescriptor;
            return this.generateExpressionForReferencedDescriptor(descriptor, expression2, resolvedCall2);
        }
        Generator generator = this;
        WritableSlice<KtReferenceExpression, DeclarationDescriptor> writableSlice = BindingContext.REFERENCE_TARGET;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "REFERENCE_TARGET");
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)GeneratorKt.get(generator, writableSlice, expression2);
        if (referenceTarget != null) {
            return this.generateExpressionForReferencedDescriptor(referenceTarget, expression2, null);
        }
        return new ErrorExpressionGenerator(this).generateErrorSimpleName(expression2);
    }

    private final IrExpression generateExpressionForReferencedDescriptor(DeclarationDescriptor descriptor, KtExpression expression2, ResolvedCall<?> resolvedCall2) {
        Object object;
        return new CallGenerator(this).generateValueReference(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), descriptor, resolvedCall2, null, (object = (ExplicitSmartCasts)this.getContext().getBindingContext().get(BindingContext.SMARTCAST, expression2)) != null && (object = object.getDefaultType()) != null ? this.toIrType((KotlinType)object) : null);
    }

    @NotNull
    public IrStatement visitCallExpression(@NotNull KtCallExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            return new ErrorExpressionGenerator(this).generateErrorCall(expression2);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 instanceof VariableAsFunctionResolvedCall) {
            CallBuilder functionCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, ((VariableAsFunctionResolvedCall)((Object)resolvedCall3)).getFunctionCall());
            return CallGeneratorKt.generateCall$default(new CallGenerator(this), expression2, functionCall, IrStatementOrigin.Companion.getINVOKE(), 0, 0, 24, null);
        }
        KtExpression calleeExpression = expression2.getCalleeExpression();
        IrStatementOriginImpl origin = Intrinsics.areEqual(((Named)resolvedCall3.getResultingDescriptor()).getName(), OperatorNameConventions.INVOKE) && !(calleeExpression instanceof KtSimpleNameExpression) && !(calleeExpression instanceof KtQualifiedExpression) ? IrStatementOrigin.Companion.getINVOKE() : null;
        return new CallGenerator(this).generateCall(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), ArgumentsGenerationUtilsKt.pregenerateCall(this, resolvedCall3), origin);
    }

    @NotNull
    public IrStatement visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, @Nullable Void data) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Generator generator = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.INDEXED_LVALUE_GET;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "INDEXED_LVALUE_GET");
        ResolvedCall indexedGetCall = (ResolvedCall)GeneratorKt.getOrFail(generator, writableSlice, expression2);
        Object d = indexedGetCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
        if (DynamicCallsKt.isDynamic((DeclarationDescriptor)d)) {
            irStatement = new OperatorExpressionGenerator(this).generateDynamicArrayAccess(expression2);
        } else {
            CallGenerator callGenerator = new CallGenerator(this);
            int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
            int n2 = PsiUtilsKt.getEndOffset(expression2);
            Intrinsics.checkNotNull(indexedGetCall);
            irStatement = callGenerator.generateCall(n, n2, ArgumentsGenerationUtilsKt.pregenerateCall(this, indexedGetCall), IrStatementOrigin.Companion.getGET_ARRAY_ELEMENT());
        }
        return irStatement;
    }

    @NotNull
    public IrStatement visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression = expression2.getSelectorExpression();
        Intrinsics.checkNotNull(ktExpression);
        Object r = ktExpression.accept(this, data);
        Intrinsics.checkNotNullExpressionValue(r, "accept(...)");
        return (IrStatement)r;
    }

    @NotNull
    public IrStatement visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression = expression2.getSelectorExpression();
        Intrinsics.checkNotNull(ktExpression);
        Object r = ktExpression.accept(this, data);
        Intrinsics.checkNotNullExpressionValue(r, "accept(...)");
        return (IrStatement)r;
    }

    private final boolean isThisForClassPhysicallyAvailable(ClassDescriptor classDescriptor) {
        for (DeclarationDescriptor scopeDescriptor = this.getScopeOwner(); scopeDescriptor != null; scopeDescriptor = scopeDescriptor.getContainingDeclaration()) {
            if (Intrinsics.areEqual(scopeDescriptor, classDescriptor)) {
                return true;
            }
            if (!(scopeDescriptor instanceof ClassDescriptor) || ((ClassDescriptor)scopeDescriptor).isInner()) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public final IrExpression generateThisReceiver(int startOffset, int endOffset, @NotNull KotlinType kotlinType, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        ReceiverParameterDescriptor receiverParameterDescriptor = classDescriptor.getThisAsReceiverParameter();
        Intrinsics.checkNotNullExpressionValue(receiverParameterDescriptor, "getThisAsReceiverParameter(...)");
        ReceiverParameterDescriptor thisAsReceiverParameter = receiverParameterDescriptor;
        IrType thisType = this.toIrType(kotlinType);
        return DescriptorUtils.isObject(classDescriptor) && !this.isThisForClassPhysicallyAvailable(classDescriptor) ? (IrExpression)BuildersKt.IrGetObjectValueImpl(startOffset, endOffset, thisType, this.getContext().getSymbolTable().getDescriptorExtension().referenceClass(classDescriptor)) : (IrExpression)BuildersKt.IrGetValueImpl$default(startOffset, endOffset, thisType, this.getContext().getSymbolTable().getDescriptorExtension().referenceValueParameter(thisAsReceiverParameter), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitThisExpression(@NotNull KtThisExpression expression2, @Nullable Void data) {
        IrExpression irExpression;
        void key$iv;
        void slice$iv;
        void $this$getOrFail$iv;
        Generator slice$iv2;
        void $this$getOrFail$iv2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Generator generator = this;
        WritableSlice<KtReferenceExpression, DeclarationDescriptor> writableSlice = BindingContext.REFERENCE_TARGET;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "REFERENCE_TARGET");
        ReadOnlySlice readOnlySlice = writableSlice;
        Object key$iv2 = expression2.getInstanceReference();
        boolean $i$f$getOrFail22 = false;
        Object v = $this$getOrFail$iv2.getContext().getBindingContext().get(slice$iv2, key$iv2);
        if (v == null) {
            KtReferenceExpression it = key$iv2;
            boolean bl = false;
            String string2 = "No reference target for this";
            throw new RuntimeException(string2);
        }
        Object it = v;
        Intrinsics.checkNotNull(it);
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)it;
        slice$iv2 = this;
        WritableSlice<KtReferenceExpression, ReceiverParameterDescriptor> writableSlice2 = BindingContext.THIS_REFERENCE_TARGET;
        Intrinsics.checkNotNullExpressionValue(writableSlice2, "THIS_REFERENCE_TARGET");
        key$iv2 = writableSlice2;
        KtReferenceExpression $i$f$getOrFail22 = expression2.getInstanceReference();
        boolean $i$f$getOrFail = false;
        Object v2 = $this$getOrFail$iv.getContext().getBindingContext().get(slice$iv, key$iv);
        if (v2 == null) {
            void it2 = key$iv;
            boolean bl = false;
            String string3 = "No reference target for this";
            throw new RuntimeException(string3);
        }
        Object v3 = v2;
        Intrinsics.checkNotNull(v3);
        ReceiverParameterDescriptor receiverParameter = (ReceiverParameterDescriptor)v3;
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int endOffset = PsiUtilsKt.getEndOffset(expression2);
        DeclarationDescriptor declarationDescriptor = referenceTarget;
        if (declarationDescriptor instanceof ClassDescriptor) {
            if (receiverParameter.getValue() instanceof ContextClassReceiver) {
                ReceiverValue receiverValue = receiverParameter.getValue();
                Intrinsics.checkNotNull(receiverValue, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ContextClassReceiver");
                irExpression = ArgumentsGenerationUtilsKt.loadContextReceiver(this, (ContextClassReceiver)receiverValue, startOffset, endOffset);
            } else {
                KotlinType kotlinType = ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter().getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                irExpression = this.generateThisReceiver(startOffset, endOffset, kotlinType, (ClassDescriptor)referenceTarget);
            }
        } else if (declarationDescriptor instanceof CallableDescriptor) {
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            IrType receiverType = this.toIrType(kotlinType);
            irExpression = BuildersKt.IrGetValueImpl$default(startOffset, endOffset, receiverType, this.getContext().getSymbolTable().getDescriptorExtension().referenceValueParameter(receiverParameter), null, 16, null);
        } else {
            throw new IllegalStateException(("Expected this or receiver: " + referenceTarget).toString());
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitBinaryExpression(@NotNull KtBinaryExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generateBinaryExpression(expression2);
    }

    @NotNull
    public IrStatement visitPrefixExpression(@NotNull KtPrefixExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generatePrefixExpression(expression2);
    }

    @NotNull
    public IrStatement visitPostfixExpression(@NotNull KtPostfixExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generatePostfixExpression(expression2);
    }

    @NotNull
    public IrStatement visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generateCastExpression(expression2);
    }

    @NotNull
    public IrStatement visitIsExpression(@NotNull KtIsExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generateInstanceOfExpression(expression2);
    }

    @NotNull
    public IrStatement visitIfExpression(@NotNull KtIfExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new BranchingExpressionGenerator(this).generateIfExpression(expression2);
    }

    @NotNull
    public IrStatement visitWhenExpression(@NotNull KtWhenExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new BranchingExpressionGenerator(this).generateWhenExpression(expression2);
    }

    @NotNull
    public IrStatement visitWhileExpression(@NotNull KtWhileExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateWhileLoop(expression2);
    }

    @NotNull
    public IrStatement visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateDoWhileLoop(expression2);
    }

    @NotNull
    public IrStatement visitForExpression(@NotNull KtForExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateForLoop(expression2);
    }

    @NotNull
    public IrStatement visitBreakExpression(@NotNull KtBreakExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateBreak(expression2);
    }

    @NotNull
    public IrStatement visitContinueExpression(@NotNull KtContinueExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateContinue(expression2);
    }

    @NotNull
    public IrStatement visitTryExpression(@NotNull KtTryExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new TryCatchExpressionGenerator(this).generateTryCatch(expression2);
    }

    @NotNull
    public IrStatement visitLambdaExpression(@NotNull KtLambdaExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LocalFunctionGenerator(this).generateLambda(expression2);
    }

    @NotNull
    public IrStatement visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return new LocalFunctionGenerator(this).generateFunction(function2);
    }

    @NotNull
    public IrStatement visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LocalClassGenerator(this).generateObjectLiteral(expression2);
    }

    @NotNull
    public IrStatement visitClassOrObject(@NotNull KtClassOrObject classOrObject, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        return new LocalClassGenerator(this).generateLocalClass(classOrObject);
    }

    @NotNull
    public IrStatement visitTypeAlias(@NotNull KtTypeAlias typeAlias, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        return BuildersKt.IrBlockImpl$default(PsiUtilsKt.getStartOffsetSkippingComments(typeAlias), PsiUtilsKt.getEndOffset(typeAlias), this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
    }

    @NotNull
    public IrStatement visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new ReflectionReferencesGenerator(this).generateClassLiteral(expression2);
    }

    @NotNull
    public IrStatement visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new ReflectionReferencesGenerator(this).generateCallableReference(expression2);
    }
}

