/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.ConstructorHeaderCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nConstructorHeaderCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructorHeaderCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,59:1\n1251#2,2:60\n*S KotlinDebug\n*F\n+ 1 ConstructorHeaderCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker\n*L\n48#1:60,2\n*E\n"})
public final class ConstructorHeaderCallChecker
implements CallChecker {
    @NotNull
    public static final ConstructorHeaderCallChecker INSTANCE = new ConstructorHeaderCallChecker();

    private ConstructorHeaderCallChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        ClassDescriptor labelReferenceClass;
        Object v;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        ClassDescriptor dispatchReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver(resolvedCall2.getDispatchReceiver());
        ClassDescriptor extensionReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver(resolvedCall2.getExtensionReceiver());
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
        KtElement callElement = ktElement;
        ClassDescriptor classDescriptor = callElement instanceof KtInstanceExpressionWithLabel ? ((v = context.getTrace().get(BindingContext.REFERENCE_TARGET, ((KtInstanceExpressionWithLabel)callElement).getInstanceReference())) instanceof ClassDescriptor ? (ClassDescriptor)v : null) : (labelReferenceClass = null);
        if (dispatchReceiverClass == null && extensionReceiverClass == null && labelReferenceClass == null) {
            return;
        }
        ClassDescriptor[] classDescriptorArray = new ClassDescriptor[]{dispatchReceiverClass, extensionReceiverClass, labelReferenceClass};
        Set<ClassDescriptor> classes = SetsKt.setOf(classDescriptorArray);
        Sequence<HierarchicalScope> $this$any$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
        boolean $i$f$any = false;
        Iterator<HierarchicalScope> iterator2 = $this$any$iv.iterator();
        do {
            HierarchicalScope element$iv;
            if (!iterator2.hasNext()) return;
            HierarchicalScope scope2 = element$iv = iterator2.next();
            boolean bl2 = false;
            if (scope2 instanceof LexicalScope && ((LexicalScope)scope2).getKind() == LexicalScopeKind.CONSTRUCTOR_HEADER) {
                DeclarationDescriptor declarationDescriptor = ((LexicalScope)scope2).getOwnerDescriptor();
                Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
                if (classes.contains(((ClassConstructorDescriptor)declarationDescriptor).getContainingDeclaration())) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        boolean bl3 = true;
        if (!bl3) return;
        context.getTrace().report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(reportOn, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
    }
}

