/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizationErrors;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMap;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualAnnotationsIncompatibilityType;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCheckingCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u000fH\u0000\u001a(\u0010\u0011\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0000\u001a$\u0010\u0014\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0015H\u0000\u001a2\u0010\u0016\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0000\u001a$\u0010\u001b\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\u001a\f\u0010!\u001a\u00020\"*\u00020\u001cH\u0000\u001a\f\u0010#\u001a\u00020\"*\u00020$H\u0000\u00a8\u0006%"}, d2={"recordActualForExpectDeclaration", "", "expectSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbol", "expectActualMap", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "recordTypeParametersMapping", "expectTypeParametersContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "actualTypeParametersContainer", "reportMissingActual", "irDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "reportAmbiguousActuals", "reportExpectActualIncompatibility", "incompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCheckingCompatibility$Incompatible;", "reportExpectActualMismatch", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility$Mismatch;", "reportActualAnnotationsNotMatchExpect", "incompatibilityType", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualAnnotationsIncompatibilityType;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "reportOn", "reportActualAnnotationConflictingDefaultArgumentValue", "Lorg/jetbrains/kotlin/ir/IrElement;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "actualParam", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "containsOptionalExpectation", "", "isPropertyForJavaField", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "ir.actualization"})
@SourceDebugExtension(value={"SMAP\nIrActualizerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrActualizerUtils.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1863#2,2:170\n*S KotlinDebug\n*F\n+ 1 IrActualizerUtils.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizerUtilsKt\n*L\n75#1:170,2\n*E\n"})
public final class IrActualizerUtilsKt {
    public static final void recordActualForExpectDeclaration(@NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol, @NotNull IrExpectActualMap expectActualMap, @NotNull IrDiagnosticReporter diagnosticsReporter) {
        Intrinsics.checkNotNullParameter(expectSymbol, "expectSymbol");
        Intrinsics.checkNotNullParameter(actualSymbol, "actualSymbol");
        Intrinsics.checkNotNullParameter(expectActualMap, "expectActualMap");
        Intrinsics.checkNotNullParameter(diagnosticsReporter, "diagnosticsReporter");
        IrSymbolOwner irSymbolOwner = expectSymbol.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationBase");
        IrDeclarationBase expectDeclaration = (IrDeclarationBase)irSymbolOwner;
        IrSymbolOwner irSymbolOwner2 = actualSymbol.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrDeclaration actualDeclaration = (IrDeclaration)irSymbolOwner2;
        IrSymbol registeredActual = expectActualMap.getRegularSymbols().put(expectSymbol, actualSymbol);
        if (registeredActual != null && !Intrinsics.areEqual(registeredActual, actualSymbol)) {
            IrActualizerUtilsKt.reportAmbiguousActuals(diagnosticsReporter, expectDeclaration);
        }
        if (expectDeclaration instanceof IrTypeParametersContainer) {
            IrActualizerUtilsKt.recordTypeParametersMapping(expectActualMap, (IrTypeParametersContainer)((Object)expectDeclaration), (IrTypeParametersContainer)actualDeclaration);
        }
        if (expectDeclaration instanceof IrProperty) {
            if (!(actualDeclaration instanceof IrProperty)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            IrSimpleFunction irSimpleFunction = ((IrProperty)expectDeclaration).getGetter();
            if (irSimpleFunction != null) {
                IrSimpleFunction expectGetter = irSimpleFunction;
                boolean bl = false;
                IrSimpleFunction actualGetter = ((IrProperty)actualDeclaration).getGetter();
                if (actualGetter != null) {
                    expectActualMap.getRegularSymbols().put(expectGetter.getSymbol(), actualGetter.getSymbol());
                    IrActualizerUtilsKt.recordTypeParametersMapping(expectActualMap, expectGetter, actualGetter);
                } else if (IrActualizerUtilsKt.isPropertyForJavaField((IrProperty)actualDeclaration)) {
                    expectActualMap.getPropertyAccessorsActualizedByFields().put(expectGetter.getSymbol(), ((IrProperty)actualDeclaration).getSymbol());
                } else {
                    throw new IllegalStateException(("Actual property " + RenderIrElementKt.render$default(actualDeclaration, null, 1, null) + " has not getter while expect property " + RenderIrElementKt.render$default(expectDeclaration, null, 1, null) + " has it").toString());
                }
            }
            IrSimpleFunction irSimpleFunction2 = ((IrProperty)expectDeclaration).getSetter();
            if (irSimpleFunction2 != null) {
                IrSimpleFunction expectSetter = irSimpleFunction2;
                boolean bl = false;
                IrSimpleFunction actualSetter = ((IrProperty)actualDeclaration).getSetter();
                if (actualSetter != null) {
                    expectActualMap.getRegularSymbols().put(expectSetter.getSymbol(), actualSetter.getSymbol());
                } else if (IrActualizerUtilsKt.isPropertyForJavaField((IrProperty)actualDeclaration)) {
                    expectActualMap.getPropertyAccessorsActualizedByFields().put(expectSetter.getSymbol(), ((IrProperty)actualDeclaration).getSymbol());
                } else {
                    throw new IllegalStateException(("Actual property " + RenderIrElementKt.render$default(actualDeclaration, null, 1, null) + " has not setter while expect property " + RenderIrElementKt.render$default(expectDeclaration, null, 1, null) + " has it").toString());
                }
            }
        }
    }

    private static final void recordTypeParametersMapping(IrExpectActualMap expectActualMap, IrTypeParametersContainer expectTypeParametersContainer, IrTypeParametersContainer actualTypeParametersContainer) {
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)expectTypeParametersContainer.getTypeParameters(), (Iterable)actualTypeParametersContainer.getTypeParameters());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            IrTypeParameter expectTypeParameter = (IrTypeParameter)pair.component1();
            IrTypeParameter actualTypeParameter = (IrTypeParameter)pair.component2();
            expectActualMap.getRegularSymbols().put(expectTypeParameter.getSymbol(), actualTypeParameter.getSymbol());
        }
    }

    public static final void reportMissingActual(@NotNull IrDiagnosticReporter $this$reportMissingActual, @NotNull IrSymbol expectSymbol) {
        Intrinsics.checkNotNullParameter($this$reportMissingActual, "<this>");
        Intrinsics.checkNotNullParameter(expectSymbol, "expectSymbol");
        IrSymbolOwner irSymbolOwner = expectSymbol.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrActualizerUtilsKt.reportMissingActual($this$reportMissingActual, (IrDeclaration)irSymbolOwner);
    }

    public static final void reportMissingActual(@NotNull IrDiagnosticReporter $this$reportMissingActual, @NotNull IrDeclaration irDeclaration2) {
        String string2;
        Intrinsics.checkNotNullParameter($this$reportMissingActual, "<this>");
        Intrinsics.checkNotNullParameter(irDeclaration2, "irDeclaration");
        KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = $this$reportMissingActual.at(irDeclaration2);
        KtDiagnosticFactory2<String, ModuleDescriptor> ktDiagnosticFactory2 = IrActualizationErrors.INSTANCE.getNO_ACTUAL_FOR_EXPECT();
        Object object = irDeclaration2 instanceof IrDeclarationWithName ? (IrDeclarationWithName)irDeclaration2 : null;
        if ((object != null && (object = object.getName()) != null ? ((Name)object).asString() : (string2 = null)) == null) {
            string2 = "";
        }
        diagnosticContextImpl.report(ktDiagnosticFactory2, string2, AdditionalIrUtilsKt.getModule(irDeclaration2));
    }

    public static final void reportAmbiguousActuals(@NotNull IrDiagnosticReporter $this$reportAmbiguousActuals, @NotNull IrDeclaration expectSymbol) {
        String string2;
        Intrinsics.checkNotNullParameter($this$reportAmbiguousActuals, "<this>");
        Intrinsics.checkNotNullParameter(expectSymbol, "expectSymbol");
        KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = $this$reportAmbiguousActuals.at(expectSymbol);
        KtDiagnosticFactory2<String, ModuleDescriptor> ktDiagnosticFactory2 = IrActualizationErrors.INSTANCE.getAMBIGUOUS_ACTUALS();
        Object object = expectSymbol instanceof IrDeclarationWithName ? (IrDeclarationWithName)expectSymbol : null;
        if ((object != null && (object = object.getName()) != null ? ((Name)object).asString() : (string2 = null)) == null) {
            string2 = "";
        }
        diagnosticContextImpl.report(ktDiagnosticFactory2, string2, AdditionalIrUtilsKt.getModule(expectSymbol));
    }

    public static final void reportExpectActualIncompatibility(@NotNull IrDiagnosticReporter $this$reportExpectActualIncompatibility, @NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol, @NotNull ExpectActualCheckingCompatibility.Incompatible<?> incompatibility) {
        Intrinsics.checkNotNullParameter($this$reportExpectActualIncompatibility, "<this>");
        Intrinsics.checkNotNullParameter(expectSymbol, "expectSymbol");
        Intrinsics.checkNotNullParameter(actualSymbol, "actualSymbol");
        Intrinsics.checkNotNullParameter(incompatibility, "incompatibility");
        IrSymbolOwner irSymbolOwner = expectSymbol.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrDeclaration expectDeclaration = (IrDeclaration)irSymbolOwner;
        IrSymbolOwner irSymbolOwner2 = actualSymbol.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrDeclaration actualDeclaration = (IrDeclaration)irSymbolOwner2;
        KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = $this$reportExpectActualIncompatibility.at(expectDeclaration);
        KtDiagnosticFactory3<String, String, ExpectActualCheckingCompatibility.Incompatible<?>> ktDiagnosticFactory3 = IrActualizationErrors.INSTANCE.getEXPECT_ACTUAL_INCOMPATIBILITY();
        String string2 = AdditionalIrUtilsKt.getNameWithAssert(expectDeclaration).asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String string3 = AdditionalIrUtilsKt.getNameWithAssert(actualDeclaration).asString();
        Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
        diagnosticContextImpl.report(ktDiagnosticFactory3, string2, string3, incompatibility);
    }

    public static final void reportExpectActualMismatch(@NotNull IrDiagnosticReporter $this$reportExpectActualMismatch, @NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol, @NotNull ExpectActualMatchingCompatibility.Mismatch incompatibility) {
        Intrinsics.checkNotNullParameter($this$reportExpectActualMismatch, "<this>");
        Intrinsics.checkNotNullParameter(expectSymbol, "expectSymbol");
        Intrinsics.checkNotNullParameter(actualSymbol, "actualSymbol");
        Intrinsics.checkNotNullParameter(incompatibility, "incompatibility");
        IrSymbolOwner irSymbolOwner = expectSymbol.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrDeclaration expectDeclaration = (IrDeclaration)irSymbolOwner;
        IrSymbolOwner irSymbolOwner2 = actualSymbol.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrDeclaration actualDeclaration = (IrDeclaration)irSymbolOwner2;
        KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = $this$reportExpectActualMismatch.at(expectDeclaration);
        KtDiagnosticFactory3<String, String, ExpectActualMatchingCompatibility.Mismatch> ktDiagnosticFactory3 = IrActualizationErrors.INSTANCE.getEXPECT_ACTUAL_MISMATCH();
        String string2 = AdditionalIrUtilsKt.getNameWithAssert(expectDeclaration).asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String string3 = AdditionalIrUtilsKt.getNameWithAssert(actualDeclaration).asString();
        Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
        diagnosticContextImpl.report(ktDiagnosticFactory3, string2, string3, incompatibility);
    }

    public static final void reportActualAnnotationsNotMatchExpect(@NotNull IrDiagnosticReporter $this$reportActualAnnotationsNotMatchExpect, @NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol, @NotNull ExpectActualAnnotationsIncompatibilityType<? extends IrConstructorCall> incompatibilityType, @NotNull IrSymbol reportOn) {
        Intrinsics.checkNotNullParameter($this$reportActualAnnotationsNotMatchExpect, "<this>");
        Intrinsics.checkNotNullParameter(expectSymbol, "expectSymbol");
        Intrinsics.checkNotNullParameter(actualSymbol, "actualSymbol");
        Intrinsics.checkNotNullParameter(incompatibilityType, "incompatibilityType");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        IrSymbolOwner irSymbolOwner = reportOn.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        $this$reportActualAnnotationsNotMatchExpect.at((IrDeclaration)irSymbolOwner).report(IrActualizationErrors.INSTANCE.getACTUAL_ANNOTATIONS_NOT_MATCH_EXPECT(), expectSymbol, actualSymbol, incompatibilityType);
    }

    public static final void reportActualAnnotationConflictingDefaultArgumentValue(@NotNull IrDiagnosticReporter $this$reportActualAnnotationConflictingDefaultArgumentValue, @NotNull IrElement reportOn, @NotNull IrFile file2, @NotNull IrValueParameter actualParam) {
        Intrinsics.checkNotNullParameter($this$reportActualAnnotationConflictingDefaultArgumentValue, "<this>");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(actualParam, "actualParam");
        $this$reportActualAnnotationConflictingDefaultArgumentValue.at(reportOn, file2).report(IrActualizationErrors.INSTANCE.getACTUAL_ANNOTATION_CONFLICTING_DEFAULT_ARGUMENT_VALUE(), actualParam);
    }

    public static final boolean containsOptionalExpectation(@NotNull IrElement $this$containsOptionalExpectation) {
        Intrinsics.checkNotNullParameter($this$containsOptionalExpectation, "<this>");
        return $this$containsOptionalExpectation instanceof IrClass && ((IrClass)$this$containsOptionalExpectation).getKind() == ClassKind.ANNOTATION_CLASS && IrUtilsKt.hasAnnotation((IrAnnotationContainer)((Object)$this$containsOptionalExpectation), StandardClassIds.Annotations.INSTANCE.getOptionalExpectation());
    }

    public static final boolean isPropertyForJavaField(@NotNull IrProperty $this$isPropertyForJavaField) {
        Intrinsics.checkNotNullParameter($this$isPropertyForJavaField, "<this>");
        return $this$isPropertyForJavaField.getGetter() == null && $this$isPropertyForJavaField.getSetter() == null && $this$isPropertyForJavaField.getBackingField() != null;
    }
}

