/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.fir.checkers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlinx.serialization.compiler.fir.checkers.FirSerializationErrors;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "jsonFqName", "Lorg/jetbrains/kotlin/name/FqName;", "jsonDefaultFqName", "parameterNameFrom", "Lorg/jetbrains/kotlin/name/Name;", "parameterNameBuilderAction", "check", "", "functionCall", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isJsonFormatCreation", "", "function", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "isDefaultFormat", "isDefaultFormatArgument", "argumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isEmptyFunctionArgument", "argument", "kotlinx-serialization-compiler-plugin.k2"})
@SourceDebugExtension(value={"SMAP\nFirSerializationPluginCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSerializationPluginCallChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,97:1\n57#2,4:98\n216#3,2:102\n*S KotlinDebug\n*F\n+ 1 FirSerializationPluginCallChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginCallChecker\n*L\n71#1:98,4\n71#1:102,2\n*E\n"})
public final class FirSerializationPluginCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirSerializationPluginCallChecker INSTANCE = new FirSerializationPluginCallChecker();
    @NotNull
    private static final FqName jsonFqName = new FqName("kotlinx.serialization.json.Json");
    @NotNull
    private static final FqName jsonDefaultFqName = new FqName("kotlinx.serialization.json.Json.Default");
    @NotNull
    private static final Name parameterNameFrom;
    @NotNull
    private static final Name parameterNameBuilderAction;

    private FirSerializationPluginCallChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull FirFunctionCall functionCall, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirBasedSymbol firBasedSymbol = FirReferenceUtilsKt.getSymbol((FirReference)((FirReference)functionCall.getCalleeReference()));
        FirNamedFunctionSymbol firNamedFunctionSymbol = firBasedSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol : null;
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol function = firNamedFunctionSymbol;
        if (this.isJsonFormatCreation(function)) {
            if (this.isDefaultFormat(functionCall)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)functionCall.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getJSON_FORMAT_REDUNDANT_DEFAULT(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
            return;
        }
        FirExpression firExpression = functionCall.getExplicitReceiver();
        FirFunctionCall firFunctionCall = firExpression instanceof FirFunctionCall ? (FirFunctionCall)firExpression : null;
        if (firFunctionCall == null) {
            return;
        }
        FirFunctionCall receiverCall = firFunctionCall;
        FirBasedSymbol firBasedSymbol2 = FirReferenceUtilsKt.getSymbol((FirReference)((FirReference)receiverCall.getCalleeReference()));
        FirNamedFunctionSymbol firNamedFunctionSymbol2 = firBasedSymbol2 instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol2 : null;
        if (firNamedFunctionSymbol2 == null) {
            return;
        }
        FirNamedFunctionSymbol receiverFunction = firNamedFunctionSymbol2;
        if (this.isJsonFormatCreation(receiverFunction) && !this.isDefaultFormat(receiverCall)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)receiverCall.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getJSON_FORMAT_REDUNDANT(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    private final boolean isJsonFormatCreation(FirNamedFunctionSymbol function) {
        return Intrinsics.areEqual((Object)function.getCallableId().asSingleFqName(), (Object)jsonFqName);
    }

    private final boolean isDefaultFormat(FirFunctionCall functionCall) {
        boolean emptyBuilder;
        boolean defaultFrom;
        block2: {
            defaultFrom = false;
            defaultFrom = true;
            emptyBuilder = false;
            FirCall $this$resolvedArgumentMapping$iv = (FirCall)functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) break block2;
            Map $this$forEach$iv = linkedHashMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                FirExpression argumentExpression = (FirExpression)entry.getKey();
                FirValueParameter parameter = (FirValueParameter)entry.getValue();
                Name name = parameter.getName();
                if (Intrinsics.areEqual((Object)name, (Object)parameterNameFrom)) {
                    defaultFrom = INSTANCE.isDefaultFormatArgument(argumentExpression);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)name, (Object)parameterNameBuilderAction)) continue;
                emptyBuilder = INSTANCE.isEmptyFunctionArgument(argumentExpression);
            }
        }
        return defaultFrom && emptyBuilder;
    }

    private final boolean isDefaultFormatArgument(FirExpression argumentExpression) {
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType((FirExpression)argumentExpression);
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return false;
        }
        ConeClassLikeType typeRef = coneClassLikeType;
        return Intrinsics.areEqual((Object)typeRef.getLookupTag().getClassId().asSingleFqName(), (Object)jsonDefaultFqName);
    }

    private final boolean isEmptyFunctionArgument(FirExpression argument) {
        FirStatement firStatement;
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = argument instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)argument : null;
        if (firAnonymousFunctionExpression == null || (firAnonymousFunctionExpression = firAnonymousFunctionExpression.getAnonymousFunction()) == null || (firAnonymousFunctionExpression = firAnonymousFunctionExpression.getBody()) == null) {
            return false;
        }
        FirAnonymousFunctionExpression lambdaArgument = firAnonymousFunctionExpression;
        return lambdaArgument.getStatements().isEmpty() || Intrinsics.areEqual((Object)((firStatement = (FirStatement)CollectionsKt.singleOrNull((List)lambdaArgument.getStatements())) != null && (firStatement = firStatement.getSource()) != null ? firStatement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitReturn.FromExpressionBody.INSTANCE);
    }

    static {
        Name name = Name.identifier((String)"from");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        parameterNameFrom = name;
        Name name2 = Name.identifier((String)"builderAction");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        parameterNameBuilderAction = name2;
    }
}

