/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.ProperTrackedReferenceValue;
import org.jetbrains.kotlin.codegen.optimization.common.ReferenceTrackingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.ReferenceValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.common.TrackedReferenceValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "<init>", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "CapturedVarDescriptor", "Transformer", "backend"})
public final class CapturedVarsOptimizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        new Transformer(internalClassName, methodNode).run();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u00100\u001a\u000201H\u0016J\u0006\u00102\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020,0'\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010*R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020,0'\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010*\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$CapturedVarDescriptor;", "Lorg/jetbrains/kotlin/codegen/optimization/common/ReferenceValueDescriptor;", "newInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "refType", "Lorg/jetbrains/org/objectweb/asm/Type;", "valueType", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getNewInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "getRefType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getValueType", "hazard", "", "getHazard", "()Z", "setHazard", "(Z)V", "initCallInsn", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "getInitCallInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "setInitCallInsn", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;)V", "localVar", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "getLocalVar", "()Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "setLocalVar", "(Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;)V", "localVarIndex", "", "getLocalVarIndex", "()I", "setLocalVarIndex", "(I)V", "wrapperInsns", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getWrapperInsns", "()Ljava/util/Collection;", "getFieldInsns", "Lorg/jetbrains/org/objectweb/asm/tree/FieldInsnNode;", "getGetFieldInsns", "putFieldInsns", "getPutFieldInsns", "onUseAsTainted", "", "canRewrite", "backend"})
    private static final class CapturedVarDescriptor
    implements ReferenceValueDescriptor {
        @NotNull
        private final TypeInsnNode newInsn;
        @NotNull
        private final Type refType;
        @NotNull
        private final Type valueType;
        private boolean hazard;
        @Nullable
        private MethodInsnNode initCallInsn;
        @Nullable
        private LocalVariableNode localVar;
        private int localVarIndex;
        @NotNull
        private final Collection<AbstractInsnNode> wrapperInsns;
        @NotNull
        private final Collection<FieldInsnNode> getFieldInsns;
        @NotNull
        private final Collection<FieldInsnNode> putFieldInsns;

        public CapturedVarDescriptor(@NotNull TypeInsnNode newInsn, @NotNull Type refType, @NotNull Type valueType) {
            Intrinsics.checkNotNullParameter(newInsn, "newInsn");
            Intrinsics.checkNotNullParameter(refType, "refType");
            Intrinsics.checkNotNullParameter(valueType, "valueType");
            this.newInsn = newInsn;
            this.refType = refType;
            this.valueType = valueType;
            this.localVarIndex = -1;
            this.wrapperInsns = new LinkedHashSet();
            this.getFieldInsns = new LinkedHashSet();
            this.putFieldInsns = new LinkedHashSet();
        }

        @NotNull
        public final TypeInsnNode getNewInsn() {
            return this.newInsn;
        }

        @NotNull
        public final Type getRefType() {
            return this.refType;
        }

        @NotNull
        public final Type getValueType() {
            return this.valueType;
        }

        public final boolean getHazard() {
            return this.hazard;
        }

        public final void setHazard(boolean bl) {
            this.hazard = bl;
        }

        @Nullable
        public final MethodInsnNode getInitCallInsn() {
            return this.initCallInsn;
        }

        public final void setInitCallInsn(@Nullable MethodInsnNode methodInsnNode) {
            this.initCallInsn = methodInsnNode;
        }

        @Nullable
        public final LocalVariableNode getLocalVar() {
            return this.localVar;
        }

        public final void setLocalVar(@Nullable LocalVariableNode localVariableNode) {
            this.localVar = localVariableNode;
        }

        public final int getLocalVarIndex() {
            return this.localVarIndex;
        }

        public final void setLocalVarIndex(int n) {
            this.localVarIndex = n;
        }

        @NotNull
        public final Collection<AbstractInsnNode> getWrapperInsns() {
            return this.wrapperInsns;
        }

        @NotNull
        public final Collection<FieldInsnNode> getGetFieldInsns() {
            return this.getFieldInsns;
        }

        @NotNull
        public final Collection<FieldInsnNode> getPutFieldInsns() {
            return this.putFieldInsns;
        }

        @Override
        public void onUseAsTainted() {
            this.hazard = true;
        }

        public final boolean canRewrite() {
            return !this.hazard && this.initCallInsn != null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J%\u0010\u0014\u001a\u00020\u000f2\u0016\u0010\u0015\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\n*\u00020\u0018H\u0002J%\u0010\u001b\u001a\u00020\u000f2\u0016\u0010\u0015\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d*\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u000f*\u00020 2\u0006\u0010!\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer;", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "refValues", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$CapturedVarDescriptor;", "refValuesByNewInsn", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "run", "", "getIndex", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "createRefValues", "trackPops", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "([Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "getCapturedVarOrNull", "assignLocalVars", "findCleanInstructions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/org/objectweb/asm/tree/LocalVariableNode;", "removeOrReplaceByNop", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "insn", "rewriteRefValue", "capturedVar", "Interpreter", "backend"})
    @SourceDebugExtension(value={"SMAP\nCapturedVarsOptimizationMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturedVarsOptimizationMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n1#2:233\n2632#3,3:234\n1863#3,2:237\n1863#3,2:239\n1863#3,2:241\n*S KotlinDebug\n*F\n+ 1 CapturedVarsOptimizationMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer\n*L\n190#1:234,3\n214#1:237,2\n215#1:239,2\n216#1:241,2\n*E\n"})
    private static final class Transformer {
        @NotNull
        private final String internalClassName;
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final ArrayList<CapturedVarDescriptor> refValues;
        @NotNull
        private final LinkedHashMap<TypeInsnNode, CapturedVarDescriptor> refValuesByNewInsn;

        public Transformer(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
            Intrinsics.checkNotNullParameter(methodNode, "methodNode");
            this.internalClassName = internalClassName;
            this.methodNode = methodNode;
            this.refValues = new ArrayList();
            this.refValuesByNewInsn = new LinkedHashMap();
        }

        public final void run() {
            this.createRefValues();
            if (this.refValues.isEmpty()) {
                return;
            }
            Frame<V>[] frameArray = MethodTransformer.analyze(this.internalClassName, this.methodNode, new Interpreter());
            Intrinsics.checkNotNullExpressionValue(frameArray, "analyze(...)");
            Frame<V>[] frames = frameArray;
            this.trackPops(frames);
            this.assignLocalVars(frames);
            Iterator<CapturedVarDescriptor> iterator2 = this.refValues.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<CapturedVarDescriptor> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                CapturedVarDescriptor refValue;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                if (!refValue.canRewrite()) continue;
                this.rewriteRefValue(refValue);
            }
            UtilKt.removeEmptyCatchBlocks(this.methodNode);
            UtilKt.removeUnusedLocalVariables(this.methodNode);
        }

        private final int getIndex(AbstractInsnNode $this$getIndex) {
            return this.methodNode.instructions.indexOf($this$getIndex);
        }

        private final void createRefValues() {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            Iterator<AbstractInsnNode> iterator2 = UtilKt.asSequence(insnList).iterator();
            while (iterator2.hasNext()) {
                Type valueType;
                Type type2;
                AbstractInsnNode insn = iterator2.next();
                if (insn.getOpcode() != 187 || !(insn instanceof TypeInsnNode) || !AsmTypes.isSharedVarType(type2 = Type.getObjectType(((TypeInsnNode)insn).desc)) || CapturedVarsOptimizationMethodTransformerKt.getREF_TYPE_TO_ELEMENT_TYPE().get(type2.getInternalName()) == null) continue;
                TypeInsnNode typeInsnNode = (TypeInsnNode)insn;
                Intrinsics.checkNotNull(type2);
                CapturedVarDescriptor refValue = new CapturedVarDescriptor(typeInsnNode, type2, valueType);
                this.refValues.add(refValue);
                ((Map)this.refValuesByNewInsn).put(insn, refValue);
            }
        }

        private final void trackPops(Frame<BasicValue>[] frames) {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            Iterator<AbstractInsnNode> iterator2 = UtilKt.asSequence(insnList).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                AbstractInsnNode insn = iterator2.next();
                if (frames[i] == null) continue;
                switch (insn.getOpcode()) {
                    case 87: {
                        Frame<BasicValue> frame;
                        Object object = StackTransformationUtilsKt.top(frame);
                        if (object != null && (object = this.getCapturedVarOrNull((BasicValue)object)) != null) {
                            Object $this$trackPops_u24lambda_u240 = object;
                            boolean bl = false;
                            ((CapturedVarDescriptor)$this$trackPops_u24lambda_u240).getWrapperInsns().add(insn);
                        }
                        break;
                    }
                    case 88: {
                        Object object;
                        BasicValue top;
                        Frame<BasicValue> frame;
                        BasicValue basicValue = top = StackTransformationUtilsKt.top(frame);
                        boolean bl = basicValue != null ? basicValue.getSize() == 1 : false;
                        if (!bl) break;
                        CapturedVarDescriptor capturedVarDescriptor = this.getCapturedVarOrNull(top);
                        if (capturedVarDescriptor != null) {
                            capturedVarDescriptor.setHazard(true);
                        }
                        if ((object = StackTransformationUtilsKt.peek(frame, 1)) == null || (object = this.getCapturedVarOrNull((BasicValue)object)) == null) break;
                        ((CapturedVarDescriptor)object).setHazard(true);
                        break;
                    }
                }
            }
        }

        private final CapturedVarDescriptor getCapturedVarOrNull(BasicValue $this$getCapturedVarOrNull) {
            ProperTrackedReferenceValue properTrackedReferenceValue = $this$getCapturedVarOrNull instanceof ProperTrackedReferenceValue ? (ProperTrackedReferenceValue)$this$getCapturedVarOrNull : null;
            ReferenceValueDescriptor referenceValueDescriptor = properTrackedReferenceValue != null ? properTrackedReferenceValue.getDescriptor() : null;
            return referenceValueDescriptor instanceof CapturedVarDescriptor ? (CapturedVarDescriptor)referenceValueDescriptor : null;
        }

        private final void assignLocalVars(Frame<BasicValue>[] frames) {
            for (LocalVariableNode localVar : this.methodNode.localVariables) {
                CapturedVarDescriptor descriptor;
                Frame<BasicValue> startFrame;
                Type type2 = Type.getType(localVar.desc);
                if (!AsmTypes.isSharedVarType(type2)) continue;
                LabelNode labelNode = localVar.start;
                Intrinsics.checkNotNullExpressionValue(labelNode, "start");
                if (frames[this.getIndex(labelNode)] == null) continue;
                BasicValue basicValue = startFrame.getLocal(localVar.index);
                ProperTrackedReferenceValue properTrackedReferenceValue = basicValue instanceof ProperTrackedReferenceValue ? (ProperTrackedReferenceValue)basicValue : null;
                if (properTrackedReferenceValue == null) continue;
                ProperTrackedReferenceValue refValue = properTrackedReferenceValue;
                ReferenceValueDescriptor referenceValueDescriptor = refValue.getDescriptor();
                CapturedVarDescriptor capturedVarDescriptor = referenceValueDescriptor instanceof CapturedVarDescriptor ? (CapturedVarDescriptor)referenceValueDescriptor : null;
                if (capturedVarDescriptor == null || (descriptor = capturedVarDescriptor).getHazard()) continue;
                if (descriptor.getLocalVar() == null) {
                    descriptor.setLocalVar(localVar);
                    continue;
                }
                descriptor.setHazard(true);
            }
            Iterator<CapturedVarDescriptor> iterator2 = this.refValues.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<Object> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object object = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                CapturedVarDescriptor refValue = (CapturedVarDescriptor)object;
                if (refValue.getHazard()) continue;
                if (refValue.getLocalVar() == null || refValue.getValueType().getSize() != 1) {
                    refValue.setLocalVarIndex(this.methodNode.maxLocals);
                    MethodNode methodNode = this.methodNode;
                    methodNode.maxLocals += refValue.getValueType().getSize();
                    continue;
                }
                LocalVariableNode localVariableNode = refValue.getLocalVar();
                Intrinsics.checkNotNull(localVariableNode);
                refValue.setLocalVarIndex(localVariableNode.index);
            }
        }

        private final Sequence<AbstractInsnNode> findCleanInstructions(LocalVariableNode $this$findCleanInstructions) {
            InsnList insnList = this.methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            return SequencesKt.filter(SequencesKt.takeWhile(SequencesKt.dropWhile(new InsnSequence(insnList), arg_0 -> Transformer.findCleanInstructions$lambda$1($this$findCleanInstructions, arg_0)), arg_0 -> Transformer.findCleanInstructions$lambda$2($this$findCleanInstructions, arg_0)), arg_0 -> Transformer.findCleanInstructions$lambda$3($this$findCleanInstructions, arg_0));
        }

        private final void removeOrReplaceByNop(InsnList $this$removeOrReplaceByNop, AbstractInsnNode insn) {
            if (insn.getPrevious() instanceof LineNumberNode && insn.getNext() instanceof LabelNode && insn.getNext().getNext() instanceof LineNumberNode) {
                $this$removeOrReplaceByNop.set(insn, new InsnNode(0));
            } else {
                $this$removeOrReplaceByNop.remove(insn);
            }
        }

        private final void rewriteRefValue(CapturedVarDescriptor capturedVar) {
            AbstractInsnNode it;
            InsnList $this$rewriteRefValue_u24lambda_u248 = this.methodNode.instructions;
            boolean bl = false;
            int loadOpcode = capturedVar.getValueType().getOpcode(21);
            int storeOpcode = capturedVar.getValueType().getOpcode(54);
            LocalVariableNode localVar = capturedVar.getLocalVar();
            if (localVar != null) {
                boolean bl2;
                Object $this$none$iv;
                block10: {
                    $this$none$iv = capturedVar.getPutFieldInsns();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        Iterator iterator2 = $this$none$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            it = (FieldInsnNode)element$iv;
                            boolean bl3 = false;
                            int n = this.getIndex(it);
                            LabelNode labelNode = localVar.start;
                            Intrinsics.checkNotNullExpressionValue(labelNode, "start");
                            if (!(n < this.getIndex(labelNode))) continue;
                            bl2 = false;
                            break block10;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    $this$rewriteRefValue_u24lambda_u248.insertBefore((AbstractInsnNode)capturedVar.getNewInsn(), new InsnNode(AsmUtil.defaultValueOpcode(capturedVar.getValueType())));
                    $this$rewriteRefValue_u24lambda_u248.insertBefore((AbstractInsnNode)capturedVar.getNewInsn(), new VarInsnNode(storeOpcode, capturedVar.getLocalVarIndex()));
                }
                $this$none$iv = this.findCleanInstructions(localVar).iterator();
                while ($this$none$iv.hasNext()) {
                    AbstractInsnNode insn = (AbstractInsnNode)$this$none$iv.next();
                    if (storeOpcode == 58) {
                        $this$rewriteRefValue_u24lambda_u248.set(insn.getPrevious(), new InsnNode(AsmUtil.defaultValueOpcode(capturedVar.getValueType())));
                        continue;
                    }
                    $this$rewriteRefValue_u24lambda_u248.remove(insn.getPrevious());
                    $this$rewriteRefValue_u24lambda_u248.remove(insn);
                }
                localVar.index = capturedVar.getLocalVarIndex();
                localVar.desc = capturedVar.getValueType().getDescriptor();
                localVar.signature = null;
            }
            $this$rewriteRefValue_u24lambda_u248.remove(capturedVar.getNewInsn());
            MethodInsnNode methodInsnNode = capturedVar.getInitCallInsn();
            Intrinsics.checkNotNull(methodInsnNode);
            $this$rewriteRefValue_u24lambda_u248.remove(methodInsnNode);
            Iterable $this$forEach$iv = capturedVar.getWrapperInsns();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull($this$rewriteRefValue_u24lambda_u248);
                this.removeOrReplaceByNop($this$rewriteRefValue_u24lambda_u248, it);
            }
            $this$forEach$iv = capturedVar.getGetFieldInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldInsnNode)element$iv;
                boolean bl5 = false;
                $this$rewriteRefValue_u24lambda_u248.set(it, new VarInsnNode(loadOpcode, capturedVar.getLocalVarIndex()));
            }
            $this$forEach$iv = capturedVar.getPutFieldInsns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FieldInsnNode)element$iv;
                boolean bl6 = false;
                $this$rewriteRefValue_u24lambda_u248.set(it, new VarInsnNode(storeOpcode, capturedVar.getLocalVarIndex()));
            }
        }

        private static final boolean findCleanInstructions$lambda$1(LocalVariableNode $this_findCleanInstructions, AbstractInsnNode it) {
            Intrinsics.checkNotNullParameter($this_findCleanInstructions, "$this_findCleanInstructions");
            Intrinsics.checkNotNullParameter(it, "it");
            return !Intrinsics.areEqual(it, $this_findCleanInstructions.start);
        }

        private static final boolean findCleanInstructions$lambda$2(LocalVariableNode $this_findCleanInstructions, AbstractInsnNode it) {
            Intrinsics.checkNotNullParameter($this_findCleanInstructions, "$this_findCleanInstructions");
            Intrinsics.checkNotNullParameter(it, "it");
            return !Intrinsics.areEqual(it, $this_findCleanInstructions.end);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean findCleanInstructions$lambda$3(LocalVariableNode $this_findCleanInstructions, AbstractInsnNode it) {
            Intrinsics.checkNotNullParameter($this_findCleanInstructions, "$this_findCleanInstructions");
            Intrinsics.checkNotNullParameter(it, "it");
            if (!(it instanceof VarInsnNode)) return false;
            if (((VarInsnNode)it).getOpcode() != 58) return false;
            if (((VarInsnNode)it).var != $this_findCleanInstructions.index) return false;
            AbstractInsnNode abstractInsnNode = ((VarInsnNode)it).getPrevious();
            if (abstractInsnNode == null) return false;
            if (abstractInsnNode.getOpcode() != 1) return false;
            return true;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer$Interpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/ReferenceTrackingInterpreter;", "<init>", "(Lorg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer;)V", "newOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "processRefValueUsage", "", "value", "Lorg/jetbrains/kotlin/codegen/optimization/common/TrackedReferenceValue;", "position", "", "backend"})
        @SourceDebugExtension(value={"SMAP\nCapturedVarsOptimizationMethodTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturedVarsOptimizationMethodTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/CapturedVarsOptimizationMethodTransformer$Transformer$Interpreter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n1#2:233\n*E\n"})
        private final class Interpreter
        extends ReferenceTrackingInterpreter {
            @Override
            @NotNull
            public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
                BasicValue basicValue;
                Intrinsics.checkNotNullParameter(insn, "insn");
                CapturedVarDescriptor capturedVarDescriptor = (CapturedVarDescriptor)((Map)Transformer.this.refValuesByNewInsn).get(insn);
                if (capturedVarDescriptor != null) {
                    CapturedVarDescriptor it = capturedVarDescriptor;
                    boolean bl = false;
                    basicValue = new ProperTrackedReferenceValue(it.getRefType(), it);
                } else {
                    BasicValue basicValue2 = super.newOperation(insn);
                    basicValue = basicValue2;
                    Intrinsics.checkNotNullExpressionValue(basicValue2, "newOperation(...)");
                }
                return basicValue;
            }

            @Override
            protected void processRefValueUsage(@NotNull TrackedReferenceValue value2, @NotNull AbstractInsnNode insn, int position) {
                Intrinsics.checkNotNullParameter(value2, "value");
                Intrinsics.checkNotNullParameter(insn, "insn");
                for (ReferenceValueDescriptor descriptor : value2.getDescriptors()) {
                    if (!(descriptor instanceof CapturedVarDescriptor)) {
                        throw new AssertionError((Object)("Unexpected descriptor: " + descriptor));
                    }
                    if (insn.getOpcode() == 89) {
                        ((CapturedVarDescriptor)descriptor).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 25) {
                        ((CapturedVarDescriptor)descriptor).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 58) {
                        ((CapturedVarDescriptor)descriptor).getWrapperInsns().add(insn);
                        continue;
                    }
                    if (insn.getOpcode() == 180 && insn instanceof FieldInsnNode && Intrinsics.areEqual(((FieldInsnNode)insn).name, "element") && position == 0) {
                        ((CapturedVarDescriptor)descriptor).getGetFieldInsns().add((FieldInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 181 && insn instanceof FieldInsnNode && Intrinsics.areEqual(((FieldInsnNode)insn).name, "element") && position == 0) {
                        ((CapturedVarDescriptor)descriptor).getPutFieldInsns().add((FieldInsnNode)insn);
                        continue;
                    }
                    if (insn.getOpcode() == 183 && insn instanceof MethodInsnNode && Intrinsics.areEqual(((MethodInsnNode)insn).name, "<init>") && position == 0) {
                        if (((CapturedVarDescriptor)descriptor).getInitCallInsn() != null && !Intrinsics.areEqual(((CapturedVarDescriptor)descriptor).getInitCallInsn(), insn)) {
                            ((CapturedVarDescriptor)descriptor).setHazard(true);
                            continue;
                        }
                        ((CapturedVarDescriptor)descriptor).setInitCallInsn((MethodInsnNode)insn);
                        continue;
                    }
                    ((CapturedVarDescriptor)descriptor).setHazard(true);
                }
            }
        }
    }
}

