/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "parameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "source", "", "renameLocalNames", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "refreshLabelNames", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nnamingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 namingUtils.kt\norg/jetbrains/kotlin/js/inline/util/NamingUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context2, @NotNull List<? extends JsExpression> arguments, @NotNull List<JsParameter> parameters, @Nullable Object source) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        if (!(arguments.size() <= parameters.size())) {
            boolean bl = false;
            String string2 = "arguments.size (" + arguments.size() + ") should be less or equal to parameters.size (" + parameters.size() + ')';
            throw new IllegalArgumentException(string2.toString());
        }
        List defaultParams = new ArrayList();
        for (Pair pair : CollectionsKt.zip((Iterable)arguments, (Iterable)parameters)) {
            JsNameRef replacement;
            JsName paramName;
            JsName jsName;
            JsExpression arg = (JsExpression)pair.component1();
            JsParameter param = (JsParameter)pair.component2();
            if (JsAstUtils.isUndefinedExpression(arg)) {
                ((Collection)defaultParams).add(param);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(param.getName(), "getName(...)");
            JsName $this$aliasArgumentsIfNeeded_u24lambda_u241 = jsName = JsScope.declareTemporaryName(paramName.getIdent());
            boolean bl = false;
            Intrinsics.checkNotNull($this$aliasArgumentsIfNeeded_u24lambda_u241);
            MetadataProperties.setStaticRef($this$aliasArgumentsIfNeeded_u24lambda_u241, arg);
            context2.newVar($this$aliasArgumentsIfNeeded_u24lambda_u241, arg.deepCopy(), source);
            Intrinsics.checkNotNullExpressionValue(jsName.makeRef(), "makeRef(...)");
            replacement.setSource(arg.getSource());
            context2.replaceName(paramName, replacement);
        }
        CollectionsKt.addAll((Collection)defaultParams, (Iterable)parameters.subList(arguments.size(), parameters.size()));
        for (JsParameter defaultParam : defaultParams) {
            JsName freshName;
            JsName paramName;
            Intrinsics.checkNotNullExpressionValue(defaultParam.getName(), "getName(...)");
            Intrinsics.checkNotNullExpressionValue(JsScope.declareTemporaryName(paramName.getIdent()), "declareTemporaryName(...)");
            freshName.copyMetadataFrom(paramName);
            NamingContext.newVar$default(context2, freshName, null, source, 2, null);
            JsNameRef jsNameRef = freshName.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
            context2.replaceName(paramName, jsNameRef);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context2, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(function2, "function");
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue(jsBlock, "getBody(...)");
        for (JsName name2 : CollectUtilsKt.collectDefinedNames(jsBlock)) {
            JsName temporaryName;
            JsName jsName;
            JsName $this$renameLocalNames_u24lambda_u242 = jsName = JsScope.declareTemporaryName(name2.getIdent());
            boolean bl = false;
            Intrinsics.checkNotNull($this$renameLocalNames_u24lambda_u242);
            MetadataProperties.setStaticRef($this$renameLocalNames_u24lambda_u242, MetadataProperties.getStaticRef(name2));
            Intrinsics.checkNotNullExpressionValue(jsName, "apply(...)");
            JsNameRef jsNameRef = temporaryName.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
            context2.replaceName(name2, jsNameRef);
        }
    }

    @NotNull
    public static final JsNode refreshLabelNames(@NotNull JsNode node, @NotNull JsScope scope2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        if (!(scope2 instanceof JsFunctionScope)) {
            throw new AssertionError((Object)"JsFunction is expected to have JsFunctionScope");
        }
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor((JsFunctionScope)scope2);
        JsNode jsNode = visitor2.accept(node);
        Intrinsics.checkNotNullExpressionValue(jsNode, "accept(...)");
        return jsNode;
    }
}

