/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/RemoveInitializersForLazyProperties;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "fileToInitializerPureness", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "", "getFileToInitializerPureness", "()Ljava/util/Map;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "calculateFileFieldsPureness", "file", "backend.js"})
@SourceDebugExtension(value={"SMAP\nPropertyLazyInitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyLazyInitLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/RemoveInitializersForLazyProperties\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
public final class RemoveInitializersForLazyProperties
implements DeclarationTransformer {
    @NotNull
    private final JsCommonBackendContext context;

    public RemoveInitializersForLazyProperties(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    private final Map<IrFile, Boolean> getFileToInitializerPureness() {
        return this.context.getPropertyLazyInitialization().getFileToInitializerPureness();
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        block7: {
            IrElement irElement;
            IrElement irElement2;
            boolean allFieldsInFilePure;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (!this.context.getPropertyLazyInitialization().getEnabled()) {
                return null;
            }
            if (!(declaration instanceof IrField)) {
                return null;
            }
            if (!PropertyLazyInitLoweringKt.access$isCompatibleDeclaration(declaration, this.context)) {
                return null;
            }
            IrElement irElement3 = declaration.getParent();
            IrFile irFile = irElement3 instanceof IrFile ? (IrFile)irElement3 : null;
            if (irFile == null) {
                return null;
            }
            IrFile file2 = irFile;
            if (Intrinsics.areEqual(this.getFileToInitializerPureness().get(file2), true)) {
                return null;
            }
            Boolean bl = this.getFileToInitializerPureness().get(file2);
            boolean bl2 = allFieldsInFilePure = bl != null ? bl.booleanValue() : this.calculateFileFieldsPureness(file2);
            if (allFieldsInFilePure) {
                return null;
            }
            irElement3 = PropertyLazyInitLoweringKt.access$getCorrespondingProperty(declaration);
            if (irElement3 == null) break block7;
            IrElement it = irElement2 = irElement3;
            boolean bl3 = false;
            IrElement irElement4 = irElement = PropertyLazyInitLoweringKt.access$isForLazyInit((IrProperty)it) ? irElement2 : null;
            if (irElement != null && (irElement2 = ((IrProperty)irElement).getBackingField()) != null) {
                IrElement it2 = irElement2;
                boolean bl4 = false;
                ((IrField)it2).setInitializer(null);
            }
        }
        return null;
    }

    private final boolean calculateFileFieldsPureness(IrFile file2) {
        List declarations2 = CollectionsKt.toList((Iterable)file2.getDeclarations());
        Collection expressions = PropertyLazyInitLoweringKt.access$calculateFieldToExpression(declarations2, this.context).values();
        boolean allFieldsInFilePure = PropertyLazyInitLoweringKt.access$allFieldsInFilePure(expressions);
        Boolean bl = allFieldsInFilePure;
        this.getFileToInitializerPureness().put(file2, bl);
        return allFieldsInFilePure;
    }
}

