/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.CoveringTryCatchNodeProcessorKt;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.IntervalMetaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarNodeWrapper;
import org.jetbrains.kotlin.codegen.inline.TryCatchBlockNodeInfo;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001aH&J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/CoveringTryCatchNodeProcessor;", "", "parameterSize", "", "<init>", "(I)V", "tryBlocksMetaInfo", "Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "Lorg/jetbrains/kotlin/codegen/inline/TryCatchBlockNodeInfo;", "getTryBlocksMetaInfo", "()Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "localVarsMetaInfo", "Lorg/jetbrains/kotlin/codegen/inline/LocalVarNodeWrapper;", "getLocalVarsMetaInfo", "value", "nextFreeLocalIndex", "getNextFreeLocalIndex", "()I", "getStartNodes", "", "label", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getEndNodes", "processInstruction", "", "curInstr", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "directOrder", "", "instructionIndex", "inst", "sortTryCatchBlocks", "intervals", "substituteTryBlockNodes", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "substituteLocalVarTable", "backend"})
@SourceDebugExtension(value={"SMAP\nCoveringTryCatchNodeProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoveringTryCatchNodeProcessor.kt\norg/jetbrains/kotlin/codegen/inline/CoveringTryCatchNodeProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
public abstract class CoveringTryCatchNodeProcessor {
    @NotNull
    private final IntervalMetaInfo<TryCatchBlockNodeInfo> tryBlocksMetaInfo = new IntervalMetaInfo(this);
    @NotNull
    private final IntervalMetaInfo<LocalVarNodeWrapper> localVarsMetaInfo = new IntervalMetaInfo(this);
    private int nextFreeLocalIndex;

    public CoveringTryCatchNodeProcessor(int parameterSize) {
        this.nextFreeLocalIndex = parameterSize;
    }

    @NotNull
    public final IntervalMetaInfo<TryCatchBlockNodeInfo> getTryBlocksMetaInfo() {
        return this.tryBlocksMetaInfo;
    }

    @NotNull
    public final IntervalMetaInfo<LocalVarNodeWrapper> getLocalVarsMetaInfo() {
        return this.localVarsMetaInfo;
    }

    public final int getNextFreeLocalIndex() {
        return this.nextFreeLocalIndex;
    }

    @NotNull
    public final List<TryCatchBlockNodeInfo> getStartNodes(@NotNull LabelNode label) {
        Intrinsics.checkNotNullParameter(label, "label");
        Collection collection = this.tryBlocksMetaInfo.getIntervalStarts().get((Object)label);
        Intrinsics.checkNotNullExpressionValue(collection, "get(...)");
        return collection;
    }

    @NotNull
    public final List<TryCatchBlockNodeInfo> getEndNodes(@NotNull LabelNode label) {
        Intrinsics.checkNotNullParameter(label, "label");
        Collection collection = this.tryBlocksMetaInfo.getIntervalEnds().get((Object)label);
        Intrinsics.checkNotNullExpressionValue(collection, "get(...)");
        return collection;
    }

    public void processInstruction(@NotNull AbstractInsnNode curInstr, boolean directOrder) {
        Intrinsics.checkNotNullParameter(curInstr, "curInstr");
        if (curInstr instanceof VarInsnNode || curInstr instanceof IincInsnNode) {
            int argSize = InlineCodegenUtilsKt.getLoadStoreArgSize(curInstr.getOpcode());
            int varIndex = curInstr instanceof VarInsnNode ? ((VarInsnNode)curInstr).var : ((IincInsnNode)curInstr).var;
            this.nextFreeLocalIndex = Math.max(this.nextFreeLocalIndex, varIndex + argSize);
        }
        if (curInstr instanceof LabelNode) {
            this.tryBlocksMetaInfo.processCurrent((LabelNode)curInstr, directOrder);
            this.localVarsMetaInfo.processCurrent((LabelNode)curInstr, directOrder);
        }
    }

    public abstract int instructionIndex(@NotNull AbstractInsnNode var1);

    @NotNull
    public final List<TryCatchBlockNodeInfo> sortTryCatchBlocks(@NotNull List<TryCatchBlockNodeInfo> intervals) {
        Intrinsics.checkNotNullParameter(intervals, "intervals");
        Comparator comp = (arg_0, arg_1) -> CoveringTryCatchNodeProcessor.sortTryCatchBlocks$lambda$1(this, arg_0, arg_1);
        Collections.sort(intervals, comp);
        return intervals;
    }

    public final void substituteTryBlockNodes(@NotNull MethodNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        node.tryCatchBlocks.clear();
        this.sortTryCatchBlocks((List<TryCatchBlockNodeInfo>)this.tryBlocksMetaInfo.getAllIntervals());
        for (TryCatchBlockNodeInfo info : CoveringTryCatchNodeProcessorKt.getMeaningfulIntervals(this.tryBlocksMetaInfo)) {
            node.tryCatchBlocks.add(info.getNode());
        }
    }

    public final void substituteLocalVarTable(@NotNull MethodNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        node.localVariables.clear();
        for (LocalVarNodeWrapper info : CoveringTryCatchNodeProcessorKt.getMeaningfulIntervals(this.localVarsMetaInfo)) {
            node.localVariables.add(info.getNode());
        }
    }

    private static final int sortTryCatchBlocks$lambda$1(CoveringTryCatchNodeProcessor this$0, TryCatchBlockNodeInfo t1, TryCatchBlockNodeInfo t2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(t1, "t1");
        Intrinsics.checkNotNullParameter(t2, "t2");
        int result2 = this$0.instructionIndex(t1.getHandler()) - this$0.instructionIndex(t2.getHandler());
        if (result2 == 0 && (result2 = this$0.instructionIndex(t1.getStartLabel()) - this$0.instructionIndex(t2.getStartLabel())) == 0) {
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string2 = "Error: support multicatch finallies: " + t1.getHandler() + ", " + t2.getHandler();
                throw new AssertionError((Object)string2);
            }
            result2 = this$0.instructionIndex(t1.getEndLabel()) - this$0.instructionIndex(t2.getEndLabel());
        }
        return result2;
    }
}

