/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceRegistrarImpl
extends PsiReferenceRegistrar {
    private static final Logger LOG = Logger.getInstance(PsiReferenceRegistrarImpl.class);
    private final Map<Class<?>, SimpleProviderBinding> myBindingsMap = new HashMap();
    private final Map<Class<?>, NamedObjectProviderBinding> myNamedBindingsMap = new HashMap();
    private final ConcurrentMap<Class<?>, ProviderBinding[]> myBindingCache;
    private boolean myInitialized;
    private final List<Disposable> myCleanupDisposables = new ArrayList<Disposable>();

    PsiReferenceRegistrarImpl() {
        this.myBindingCache = ConcurrentFactoryMap.createMap(key -> {
            SmartList<ProviderBinding> result2 = new SmartList<ProviderBinding>();
            for (Class<?> bindingClass : this.myBindingsMap.keySet()) {
                if (!bindingClass.isAssignableFrom((Class<?>)key)) continue;
                result2.add(this.myBindingsMap.get(bindingClass));
            }
            for (Class<?> bindingClass : this.myNamedBindingsMap.keySet()) {
                if (!bindingClass.isAssignableFrom((Class<?>)key)) continue;
                result2.add(this.myNamedBindingsMap.get(bindingClass));
            }
            return result2.toArray(new ProviderBinding[0]);
        });
    }

    void markInitialized() {
        this.myInitialized = true;
    }

    void cleanup() {
        for (Disposable disposable : new ArrayList<Disposable>(this.myCleanupDisposables)) {
            Disposer.dispose(disposable);
        }
        this.myCleanupDisposables.clear();
    }

    @Override
    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider2, double priority) {
        if (pattern == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(1);
        }
        this.registerReferenceProvider(pattern, provider2, priority, null);
    }

    /*
     * WARNING - void declaration
     */
    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, final @NotNull PsiReferenceProvider provider2, double priority, @Nullable Disposable disposable) {
        SimpleProviderBinding providerBinding;
        void parentDisposable;
        if (pattern == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(3);
        }
        if (this.myInitialized && !ApplicationManager.getApplication().isUnitTestMode() && parentDisposable == null) {
            LOG.error("Reference provider registration is only allowed from PsiReferenceContributor");
        }
        final Class<T> scope2 = pattern.getCondition().getInitialCondition().getAcceptedClass();
        List<PatternCondition<T>> conditions = pattern.getCondition().getConditions();
        for (PatternCondition<T> _condition : conditions) {
            if (!(_condition instanceof PsiNamePatternCondition)) continue;
            PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)_condition;
            List<PatternCondition<String>> conditions1 = nameCondition.getNamePattern().getCondition().getConditions();
            for (PatternCondition<String> condition1 : conditions1) {
                if (condition1 instanceof ValuePatternCondition) {
                    Collection<String> strings2 = ((ValuePatternCondition)condition1).getValues();
                    this.registerNamedReferenceProvider(ArrayUtilRt.toStringArray(strings2), nameCondition, scope2, true, provider2, priority, pattern, (Disposable)parentDisposable);
                    return;
                }
                if (!(condition1 instanceof CaseInsensitiveValuePatternCondition)) continue;
                String[] strings3 = ((CaseInsensitiveValuePatternCondition)condition1).getValues();
                this.registerNamedReferenceProvider(strings3, nameCondition, scope2, false, provider2, priority, pattern, (Disposable)parentDisposable);
                return;
            }
        }
        if ((providerBinding = this.myBindingsMap.get(scope2)) == null) {
            providerBinding = new SimpleProviderBinding();
            this.myBindingsMap.put(scope2, providerBinding);
        }
        providerBinding.registerProvider(provider2, pattern, priority);
        if (parentDisposable != null) {
            Disposable disposable2 = new Disposable(){

                @Override
                public void dispose() {
                    PsiReferenceRegistrarImpl.this.unregisterReferenceProvider(scope2, provider2);
                    PsiReferenceRegistrarImpl.this.myCleanupDisposables.remove(this);
                }
            };
            Disposer.register((Disposable)parentDisposable, disposable2);
            this.myCleanupDisposables.add(disposable2);
        }
        this.clearBindingsCache();
    }

    void clearBindingsCache() {
        this.myBindingCache.clear();
    }

    public void unregisterReferenceProvider(@NotNull Class<?> scope2, @NotNull PsiReferenceProvider provider2) {
        SimpleProviderBinding binding;
        if (scope2 == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(4);
        }
        if (provider2 == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(5);
        }
        if ((binding = this.myBindingsMap.get(scope2)) != null) {
            binding.unregisterProvider(provider2);
            if (binding.isEmpty()) {
                this.myBindingsMap.remove(scope2);
            }
        }
        this.clearBindingsCache();
    }

    /*
     * WARNING - void declaration
     */
    private void registerNamedReferenceProvider(String @NotNull [] names, final PsiNamePatternCondition<?> nameCondition, final @NotNull Class<?> scopeClass, boolean caseSensitive, final @NotNull PsiReferenceProvider provider2, double priority, @NotNull ElementPattern<?> pattern, @Nullable Disposable disposable) {
        void parentDisposable;
        NamedObjectProviderBinding providerBinding;
        if (scopeClass == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (provider2 == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(8);
        }
        if (names == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(9);
        }
        if ((providerBinding = this.myNamedBindingsMap.get(scopeClass)) == null) {
            providerBinding = new NamedObjectProviderBinding(){

                @Override
                protected String getName(@NotNull PsiElement position) {
                    if (position == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return nameCondition.getPropertyValue(position);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl$2", "getName"));
                }
            };
            this.myNamedBindingsMap.put(scopeClass, providerBinding);
        }
        providerBinding.registerProvider(names, pattern, caseSensitive, provider2, priority);
        if (parentDisposable != null) {
            final NamedObjectProviderBinding finalProviderBinding = providerBinding;
            Disposable disposable2 = new Disposable(){

                @Override
                public void dispose() {
                    finalProviderBinding.unregisterProvider(provider2);
                    if (finalProviderBinding.isEmpty()) {
                        PsiReferenceRegistrarImpl.this.myNamedBindingsMap.remove(scopeClass);
                    }
                    PsiReferenceRegistrarImpl.this.myCleanupDisposables.remove(this);
                }
            };
            this.myCleanupDisposables.add(disposable2);
            Disposer.register((Disposable)parentDisposable, disposable2);
        }
    }

    @NotNull
    List<ProviderBinding.ProviderInfo<ProcessingContext>> getPairsByElement(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        ProviderBinding[] bindings;
        if (element == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(10);
        }
        if (hints == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(11);
        }
        if ((bindings = (ProviderBinding[])this.myBindingCache.get(element.getClass())).length == 0) {
            List<ProviderBinding.ProviderInfo<ProcessingContext>> list = Collections.emptyList();
            if (list == null) {
                PsiReferenceRegistrarImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        SmartList<ProviderBinding.ProviderInfo<ProcessingContext>> ret = new SmartList<ProviderBinding.ProviderInfo<ProcessingContext>>();
        for (ProviderBinding binding : bindings) {
            binding.addAcceptableReferenceProviders(element, ret, hints);
        }
        SmartList<ProviderBinding.ProviderInfo<ProcessingContext>> smartList = ret;
        if (smartList == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(13);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairsByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterReferenceProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerNamedReferenceProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPairsByElement";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

