/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AstLoadingFilter {
    private static final Logger LOG = Logger.getInstance(AstLoadingFilter.class);
    private static final Set<String> ourReportedTraces = ContainerUtil.newConcurrentSet();
    private static final ThreadLocal<Supplier<String>> myDisallowedInfo = new ThreadLocal();
    private static final ThreadLocal<Set<VirtualFile>> myForcedAllowedFiles = ThreadLocal.withInitial(() -> new THashSet());

    private AstLoadingFilter() {
    }

    public static void assertTreeLoadingAllowed(@NotNull VirtualFile file2) {
        AstLoadingException throwable;
        if (file2 == null) {
            AstLoadingFilter.$$$reportNull$$$0(0);
        }
        if (!Registry.is("ast.loading.filter")) {
            return;
        }
        if (file2 instanceof VirtualFileWindow) {
            return;
        }
        Supplier<String> disallowedInfo = myDisallowedInfo.get();
        if (disallowedInfo != null && !myForcedAllowedFiles.get().contains(file2) && ourReportedTraces.add(ExceptionUtil.getThrowableText(throwable = new AstLoadingException()))) {
            LOG.error("Tree access disabled", (Throwable)throwable, new Attachment("debugInfo", AstLoadingFilter.buildDebugInfo(file2, disallowedInfo)));
        }
    }

    @NotNull
    private static String buildDebugInfo(@NotNull VirtualFile file2, @NotNull Supplier<String> disabledInfo) {
        if (file2 == null) {
            AstLoadingFilter.$$$reportNull$$$0(1);
        }
        if (disabledInfo == null) {
            AstLoadingFilter.$$$reportNull$$$0(2);
        }
        StringBuilder debugInfo2 = new StringBuilder();
        debugInfo2.append("Accessed file path: ").append(file2.getPath());
        String additionalInfo = disabledInfo.get();
        if (additionalInfo != null) {
            debugInfo2.append('\n').append("Additional info: \n").append(additionalInfo);
        }
        String string = debugInfo2.toString();
        if (string == null) {
            AstLoadingFilter.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static <T, E extends Throwable> T disallowTreeLoading(@NotNull ThrowableComputable<? extends T, E> computable) throws E {
        if (computable == null) {
            AstLoadingFilter.$$$reportNull$$$0(5);
        }
        return AstLoadingFilter.disallowTreeLoading(computable, () -> null);
    }

    public static <T, E extends Throwable> T disallowTreeLoading(@NotNull ThrowableComputable<? extends T, E> computable, @NotNull Supplier<String> debugInfo2) throws E {
        if (computable == null) {
            AstLoadingFilter.$$$reportNull$$$0(6);
        }
        if (debugInfo2 == null) {
            AstLoadingFilter.$$$reportNull$$$0(7);
        }
        if (myDisallowedInfo.get() != null) {
            return computable.compute();
        }
        try {
            myDisallowedInfo.set(debugInfo2);
            T t = computable.compute();
            return t;
        }
        finally {
            myDisallowedInfo.set(null);
        }
    }

    public static <T, E extends Throwable> T forceAllowTreeLoading(@Nullable PsiFile psiFile, @NotNull ThrowableComputable<? extends T, E> computable) throws E {
        if (computable == null) {
            AstLoadingFilter.$$$reportNull$$$0(11);
        }
        VirtualFile virtualFile2 = psiFile == null ? null : psiFile.getVirtualFile();
        return virtualFile2 == null ? computable.compute() : AstLoadingFilter.forceAllowTreeLoading(virtualFile2, computable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T forceAllowTreeLoading(@NotNull VirtualFile virtualFile2, @NotNull ThrowableComputable<? extends T, E> computable) throws E {
        Set<VirtualFile> enabledFiles;
        if (virtualFile2 == null) {
            AstLoadingFilter.$$$reportNull$$$0(12);
        }
        if (computable == null) {
            AstLoadingFilter.$$$reportNull$$$0(13);
        }
        if ((enabledFiles = myForcedAllowedFiles.get()).add(virtualFile2)) {
            try {
                T t = computable.compute();
                return t;
            }
            finally {
                enabledFiles.remove(virtualFile2);
            }
        }
        return computable.compute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/AstLoadingFilter";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugInfo";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/AstLoadingFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDebugInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertTreeLoadingAllowed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildDebugInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disallowTreeLoading";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forceAllowTreeLoading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

