/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.zulip;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.zulip.ZulipException;
import org.jreleaser.sdk.zulip.ZulipSdk;
import org.jreleaser.util.StringUtils;

public class ZulipAnnouncer
implements Announcer<org.jreleaser.model.api.announce.ZulipAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.ZulipAnnouncer zulip;

    public ZulipAnnouncer(JReleaserContext context) {
        this.context = context;
        this.zulip = context.getModel().getAnnounce().getZulip();
    }

    public org.jreleaser.model.api.announce.ZulipAnnouncer getAnnouncer() {
        return this.zulip.asImmutable();
    }

    public String getName() {
        return "zulip";
    }

    public boolean isEnabled() {
        return this.zulip.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.zulip.getMessage())) {
            message = this.zulip.getResolvedMessage(this.context);
        } else {
            TemplateContext props = new TemplateContext();
            this.context.getChangelog().apply(props);
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.zulip.getResolvedMessageTemplate(this.context, props);
        }
        String subject = this.zulip.getResolvedSubject(this.context);
        this.context.getLogger().info("channel: {}", new Object[]{this.zulip.getChannel()});
        this.context.getLogger().info("subject: {}", new Object[]{subject});
        this.context.getLogger().debug("message: {}", new Object[]{message});
        try {
            ZulipSdk sdk = ZulipSdk.builder(this.context.getLogger()).apiHost(this.zulip.getApiHost()).account(this.zulip.getAccount()).apiKey(this.context.isDryrun() ? "**UNDEFINED**" : this.zulip.getApiKey()).connectTimeout(this.zulip.getConnectTimeout()).readTimeout(this.zulip.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.message(this.zulip.getChannel(), subject, message);
        }
        catch (ZulipException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

