/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.DockerConfiguration;
import org.jreleaser.model.internal.packagers.DockerPackager;
import org.jreleaser.model.internal.packagers.DockerSpec;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class DockerPackagerValidator {
    private DockerPackagerValidator() {
    }

    public static void validateDocker(JReleaserContext context, Distribution distribution, DockerPackager packager, Errors errors) {
        String element = "distribution." + distribution.getName() + ".docker";
        context.getLogger().debug(element);
        JReleaserModel model = context.getModel();
        Project project = model.getProject();
        DockerPackager parentPackager = model.getPackagers().getDocker();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        for (DockerSpec spec : packager.getSpecs().values()) {
            if (!spec.isActiveSet() && packager.isActiveSet()) {
                spec.setActive(packager.getActive());
            }
            Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType() + "." + spec.getName(), "NEVER");
            spec.resolveEnabled(context.getModel().getProject());
        }
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        Validator.validateCommitAuthor(packager, parentPackager);
        DockerPackager.DockerRepository repository = packager.getPackagerRepository();
        if (!repository.isVersionedSubfoldersSet()) {
            repository.setVersionedSubfolders(parentPackager.getPackagerRepository().isVersionedSubfolders());
        }
        if (StringUtils.isBlank((String)repository.getName())) {
            repository.setName(project.getName() + "-docker");
        }
        Validator.validateTap(context, distribution, repository, parentPackager.getRepositoryTap(), "docker.repository");
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getBaseImage())) {
            packager.setBaseImage(parentPackager.getBaseImage());
        }
        DockerPackagerValidator.validateBaseImage(distribution, packager);
        if (packager.getImageNames().isEmpty()) {
            packager.setImageNames(parentPackager.getImageNames());
        }
        if (packager.getImageNames().isEmpty()) {
            packager.addImageName("{{repoOwner}}/{{distributionName}}:{{tagName}}");
        }
        if (context.getModel().getProject().isSnapshot()) {
            Optional<String> imageName = packager.getImageNames().stream().filter(n -> n.endsWith(":{{tagName}}") || n.endsWith(":{{ tagName }}")).findFirst();
            packager.setImageNames(Collections.singleton(imageName.orElse(packager.getImageNames().iterator().next())));
        }
        DockerPackagerValidator.validateCommands(packager, parentPackager);
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.putAll(parentPackager.getLabels());
        labels.putAll(packager.getLabels());
        packager.setLabels(labels);
        if (!packager.getLabels().containsKey("org.opencontainers.image.title")) {
            packager.getLabels().put("org.opencontainers.image.title", "{{distributionName}}");
        }
        DockerPackagerValidator.validateLabels(packager);
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        DockerPackagerValidator.validateRegistries(context, packager, parentPackager, errors, element);
        if (!packager.isUseLocalArtifactSet() && parentPackager.isUseLocalArtifactSet()) {
            packager.setUseLocalArtifact(parentPackager.isUseLocalArtifact());
        }
        if (distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
            packager.setUseLocalArtifact(true);
        }
        DockerPackagerValidator.validateBuildx(context, distribution, packager, packager.getBuildx(), parentPackager.getBuildx(), errors);
        for (Map.Entry<String, DockerSpec> e : packager.getSpecs().entrySet()) {
            DockerSpec spec = e.getValue();
            if (StringUtils.isBlank((String)spec.getName())) {
                spec.setName(e.getKey());
            }
            DockerPackagerValidator.validateDockerSpec(context, distribution, spec, packager, errors);
        }
    }

    private static void validateBuildx(JReleaserContext context, Distribution distribution, DockerPackager packager, DockerConfiguration.Buildx buildx, DockerConfiguration.Buildx parentBuildx, Errors errors) {
        if (!buildx.isEnabledSet()) {
            buildx.setEnabled(parentBuildx.isEnabled());
        }
        if (!buildx.isCreateBuilderSet()) {
            buildx.setCreateBuilder(parentBuildx.isCreateBuilder());
        }
        if (buildx.getPlatforms().isEmpty()) {
            buildx.setPlatforms(parentBuildx.getPlatforms());
        }
        if (buildx.isEnabled() && buildx.getPlatforms().isEmpty()) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.platforms", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.docker.buildx.no.platforms", (Object[])new Object[]{distribution.getName()}));
            packager.disable();
        }
        if (buildx.isEnabled() && distribution.getType() != Distribution.DistributionType.JAVA_BINARY && distribution.getType() != Distribution.DistributionType.SINGLE_JAR) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.distributions", (Object[])new Object[]{CollectionUtils.listOf((Object[])new Distribution.DistributionType[]{Distribution.DistributionType.JAVA_BINARY, Distribution.DistributionType.SINGLE_JAR})}));
            errors.warning(RB.$((String)"WARNING.validation.docker.buildx.distributions", (Object[])new Object[]{distribution.getName(), CollectionUtils.listOf((Object[])new Distribution.DistributionType[]{Distribution.DistributionType.JAVA_BINARY, Distribution.DistributionType.SINGLE_JAR})}));
            packager.disable();
        }
        if (buildx.getCreateBuilderFlags().isEmpty()) {
            buildx.setCreateBuilderFlags(parentBuildx.getCreateBuilderFlags());
        }
        if (buildx.getCreateBuilderFlags().isEmpty()) {
            buildx.getCreateBuilderFlags().addAll(CollectionUtils.listOf((Object[])new String[]{"--name", "jreleaser", "--driver", "docker-container", "--bootstrap", "--use"}));
        }
    }

    public static void validateDockerSpec(JReleaserContext context, Distribution distribution, DockerSpec spec, DockerPackager docker, Errors errors) {
        if (!spec.isEnabled()) {
            return;
        }
        String element = "distribution." + distribution.getName() + ".docker.spec." + spec.getName();
        context.getLogger().debug(element);
        TemplateValidator.validateTemplate(context, distribution, spec, docker, errors);
        ExtraPropertiesValidator.mergeExtraProperties(spec, docker);
        DockerPackagerValidator.validateBaseImage(distribution, spec);
        if (spec.getImageNames().isEmpty()) {
            spec.addImageName("{{repoOwner}}/{{distributionName}}-{{dockerSpecName}}:{{tagName}}");
        }
        if (context.getModel().getProject().isSnapshot()) {
            Optional<String> imageName = spec.getImageNames().stream().filter(n -> n.endsWith(":{{tagName}}") || n.endsWith(":{{ tagName }}")).findFirst();
            spec.setImageNames(Collections.singleton(imageName.orElse("{{repoOwner}}/{{distributionName}}-{{dockerSpecName}}:{{tagName}}")));
        }
        DockerPackagerValidator.validateCommands(spec, docker);
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.putAll(docker.getLabels());
        labels.putAll(spec.getLabels());
        if (!spec.getLabels().containsKey("org.opencontainers.image.title")) {
            labels.put("org.opencontainers.image.title", docker.getLabels().get("org.opencontainers.image.title") + "-{{dockerSpecName}}");
        }
        spec.setLabels(labels);
        DockerPackagerValidator.validateLabels(spec);
        DockerPackagerValidator.validateRegistries(context, spec, docker, errors, element);
        long artifactCount = distribution.getArtifacts().stream().filter(Artifact::isActive).count();
        if (artifactCount > 1L && spec.getMatchers().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{element + ".matchers"}));
        }
        if (null == spec.getArtifact()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            spec.disable();
            return;
        }
        if (!spec.isUseLocalArtifactSet() && docker.isUseLocalArtifactSet()) {
            spec.setUseLocalArtifact(docker.isUseLocalArtifact());
        }
        if (distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
            spec.setUseLocalArtifact(true);
        }
        DockerPackagerValidator.validateBuildx(context, distribution, docker, spec.getBuildx(), docker.getBuildx(), errors);
    }

    private static void validateBaseImage(Distribution distribution, DockerConfiguration docker) {
        if (StringUtils.isBlank((String)docker.getBaseImage())) {
            if (distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
                int version = Integer.parseInt(distribution.getJava().getVersion());
                boolean ltsmts = version == 8 || version % 2 == 1;
                docker.setBaseImage("azul/zulu-openjdk-alpine:{{distributionJavaVersion}}" + (ltsmts ? "-jre" : ""));
            } else if (distribution.getType() == Distribution.DistributionType.JLINK) {
                if (DockerPackagerValidator.isAlpineCompatible(distribution, docker)) {
                    docker.setBaseImage("alpine:latest");
                } else {
                    docker.setBaseImage("ubuntu:latest");
                }
            } else {
                docker.setBaseImage("scratch");
            }
        } else if (docker instanceof DockerSpec) {
            DockerSpec spec = (DockerSpec)docker;
            distribution.getArtifacts().stream().filter(artifact -> artifact.getPath().endsWith(".zip")).filter(spec::matches).findFirst().ifPresent(spec::setArtifact);
        }
    }

    private static boolean isAlpineCompatible(Distribution distribution, DockerConfiguration docker) {
        List artifacts = distribution.getArtifacts().stream().filter(artifact -> artifact.getPath().endsWith(".zip")).collect(Collectors.toList());
        if (docker instanceof DockerSpec) {
            DockerSpec spec = (DockerSpec)docker;
            Optional<Artifact> artifact2 = artifacts.stream().filter(spec::matches).findFirst();
            if (artifact2.isPresent()) {
                spec.setArtifact(artifact2.get());
                return PlatformUtils.isAlpineLinux((String)artifact2.get().getPlatform());
            }
            return false;
        }
        return artifacts.stream().anyMatch(artifact -> PlatformUtils.isAlpineLinux((String)artifact.getPlatform()));
    }

    private static void validateCommands(DockerConfiguration self, DockerConfiguration other) {
        if (self.getBuildArgs().isEmpty() && !other.getBuildArgs().isEmpty()) {
            self.setBuildArgs(other.getBuildArgs());
        }
        if (self.getPreCommands().isEmpty() && !other.getPreCommands().isEmpty()) {
            self.setPreCommands(other.getPreCommands());
        }
        if (self.getPostCommands().isEmpty() && !other.getPostCommands().isEmpty()) {
            self.setPostCommands(other.getPostCommands());
        }
    }

    private static void validateLabels(DockerConfiguration self) {
        if (!self.getLabels().containsKey("org.opencontainers.image.description")) {
            self.getLabels().put("org.opencontainers.image.description", "{{projectDescription}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.url")) {
            self.getLabels().put("org.opencontainers.image.url", "{{projectWebsite}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.licenses")) {
            self.getLabels().put("org.opencontainers.image.licenses", "{{projectLicense}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.version")) {
            self.getLabels().put("org.opencontainers.image.version", "{{projectVersion}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.revision")) {
            self.getLabels().put("org.opencontainers.image.revision", "{{commitFullHash}}");
        }
    }

    private static void validateRegistries(JReleaserContext context, DockerConfiguration self, DockerConfiguration other, Errors errors, String element) {
        JReleaserModel model = context.getModel();
        if (self.getRegistries().isEmpty()) {
            String username = model.getRelease().getReleaser().getUsername();
            context.getLogger().info(RB.$((String)"validation_docker_no_registries", (Object[])new Object[]{element, username}));
            DockerConfiguration.Registry registry = new DockerConfiguration.Registry();
            registry.setServerName("DEFAULT");
            registry.setServer("docker.io");
            registry.setUsername(username);
            self.addRegistry(registry);
        }
        LinkedHashSet<DockerConfiguration.Registry> registries = new LinkedHashSet<DockerConfiguration.Registry>();
        registries.addAll(self.getRegistries());
        registries.addAll(other.getRegistries());
        self.setRegistries(registries);
        for (DockerConfiguration.Registry registry : registries) {
            BaseReleaser<?, ?> service = model.getRelease().getReleaser();
            String serverName = registry.getServerName();
            if (StringUtils.isBlank((String)registry.getServer())) {
                registry.setServer(serverName);
            }
            registry.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{element + "." + serverName + ".username", "docker." + serverName + ".username"}), "registry." + serverName + ".username", registry.getUsername(), service.getUsername()));
            if (StringUtils.isBlank((String)registry.getRepositoryName())) {
                registry.setRepositoryName(service.getOwner());
            }
            if (registry.isExternalLogin()) continue;
            if (StringUtils.isBlank((String)registry.getUsername())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{element + ".registry." + serverName + ".username"}));
            }
            registry.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{element + "." + serverName + ".password", "docker." + serverName + ".password"}), "registry." + serverName + ".password", registry.getPassword(), errors, context.isDryrun()));
        }
    }
}

