/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public final class IoUtils {
    private IoUtils() {
    }

    public static Scanner newScanner(InputStream in) {
        return new Scanner(in, StandardCharsets.UTF_8.name());
    }

    public static PrintWriter newPrintWriter(OutputStream out) {
        return IoUtils.newPrintWriter(out, true);
    }

    public static PrintWriter newPrintWriter(OutputStream out, boolean autoFlush) {
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)), autoFlush);
    }

    public static PrintStream newPrintStream(OutputStream out) {
        return IoUtils.newPrintStream(out, true);
    }

    public static PrintStream newPrintStream(OutputStream out, boolean autoFlush) {
        try {
            return new PrintStream(out, autoFlush, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toString(ByteArrayOutputStream out) {
        try {
            return out.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

