/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mavencentral;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.deploy.maven.MavenCentralMavenDeployer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.mavencentral.MavenCentral;
import org.jreleaser.sdk.mavencentral.MavenCentralException;
import org.jreleaser.sdk.mavencentral.api.Deployment;
import org.jreleaser.sdk.mavencentral.api.State;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public class MavenCentralMavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.MavenCentralMavenDeployer, org.jreleaser.model.internal.deploy.maven.MavenCentralMavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.MavenCentralMavenDeployer deployer;

    public MavenCentralMavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.MavenCentralMavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.MavenCentralMavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "mavenCentral";
    }

    public void deploy(String name) throws DeployException {
        String deploymentId = this.deployer.getDeploymentId();
        if (StringUtils.isNotBlank((String)deploymentId)) {
            this.context.getLogger().debug(RB.$((String)"set.to", (Object[])new Object[]{"deploymentId", deploymentId}));
        }
        Path bundleZip = null;
        if (this.deployer.getStage() != MavenCentralMavenDeployer.Stage.PUBLISH) {
            Set deployables = this.collectDeployables();
            if (deployables.isEmpty()) {
                this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
                return;
            }
            bundleZip = this.createDeploymentBundle();
        }
        MavenCentral mavenCentral = new MavenCentral(this.context.asImmutable(), this.deployer.getResolvedUrl(this.context.fullProps()), this.deployer.getAuthorization(), this.deployer.getUsername(), this.deployer.getPassword(), this.deployer.getConnectTimeout(), this.deployer.getReadTimeout(), this.context.isDryrun(), this.deployer.getRetryDelay(), this.deployer.getMaxRetries(), this.deployer.getName());
        this.context.getAdditionalProperties().put(this.prefix("namespace"), this.deployer.getNamespace());
        Deployment deployment = null;
        if (this.deployer.getStage() != MavenCentralMavenDeployer.Stage.PUBLISH) {
            Optional<String> did = this.uploadArtifacts(mavenCentral, bundleZip);
            if (did.isPresent()) {
                deploymentId = did.get();
                this.context.getAdditionalProperties().put(this.prefix("deploymentId"), deploymentId);
                deployment = this.getDeployment(deploymentId, mavenCentral);
            }
        } else {
            this.context.getAdditionalProperties().put(this.prefix("deploymentId"), deploymentId);
            deployment = this.getDeployment(deploymentId, mavenCentral);
            this.checkDeploymentIsValid(deploymentId, deployment);
        }
        if (this.deployer.getStage() != MavenCentralMavenDeployer.Stage.UPLOAD && null != deployment) {
            this.checkDeploymentIsValid(deploymentId, deployment);
            try {
                this.context.getLogger().info(RB.$((String)"maven.central.publish.deployment", (Object[])new Object[]{deploymentId}));
                mavenCentral.publish(deploymentId);
            }
            catch (MavenCentralException e) {
                throw new DeployException(RB.$((String)"ERROR_maven_central_publish_deployment", (Object[])new Object[]{deploymentId}), (Throwable)e);
            }
        }
    }

    private void checkDeploymentIsValid(String deploymentId, Deployment deployment) throws DeployException {
        if (deployment.getDeploymentState() != State.VALIDATED) {
            Set<String> messages = this.resolveErrorMessages(deployment);
            String title = RB.$((String)"maven.central.wait.deployment.invalid.state", (Object[])new Object[]{deploymentId, CollectionUtils.listOf((Object[])new State[]{State.VALIDATED}), deployment.getDeploymentState()});
            if (!messages.isEmpty()) {
                throw new DeployException(title + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), messages));
            }
            throw new DeployException(title);
        }
    }

    private Deployment getDeployment(String deploymentId, MavenCentral mavenCentral) throws DeployException {
        Deployment deployment = this.resolveDeployment(mavenCentral, deploymentId);
        if (!deployment.getErrors().isEmpty()) {
            Set<String> messages = this.resolveErrorMessages(deployment);
            String title = RB.$((String)"maven.central.deployment.failure", (Object[])new Object[]{deploymentId});
            throw new DeployException(title + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), messages));
        }
        return deployment;
    }

    private Set<String> resolveErrorMessages(Deployment deployment) {
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        for (Map.Entry<String, List<String>> e : deployment.getErrors().entrySet()) {
            for (String error : e.getValue()) {
                messages.add(e.getKey() + " " + error);
            }
        }
        return messages;
    }

    private Deployment resolveDeployment(MavenCentral mavenCentral, String deploymentId) throws DeployException {
        try {
            Optional<Deployment> deployment = mavenCentral.status(deploymentId);
            if (deployment.isPresent()) {
                return deployment.get();
            }
            throw new DeployException(RB.$((String)"ERROR_maven_central_find_deployment", (Object[])new Object[]{deploymentId}));
        }
        catch (MavenCentralException e) {
            throw new DeployException(RB.$((String)"ERROR_maven_central_find_deployment", (Object[])new Object[]{deploymentId}), (Throwable)e);
        }
    }

    private Path createDeploymentBundle() throws DeployException {
        Path bundleZip = this.context.getDeployDirectory().resolve(this.deployer.getType()).resolve(this.deployer.getName()).resolve(this.deployer.getNamespace() + "-" + this.context.getModel().getProject().getResolvedName() + "-" + this.context.getModel().getProject().getResolvedVersion() + "-bundle.zip");
        try {
            Path bundleDir = Files.createTempDirectory("maven-central", new FileAttribute[0]);
            for (String stagingRepository : this.deployer.getStagingRepositories()) {
                Path stagingRepositoryDir = this.context.getBasedir().resolve(stagingRepository).normalize();
                FileUtils.copyFilesRecursive((JReleaserLogger)this.context.getLogger(), (Path)stagingRepositoryDir, (Path)bundleDir, p -> FileUtils.isHidden((Path)p) || p.getFileName().toString().contains("maven-metadata.xml"));
            }
            Files.createDirectories(bundleZip.getParent(), new FileAttribute[0]);
            FileUtils.zip((Path)bundleDir, (Path)bundleZip);
            return bundleZip;
        }
        catch (IOException e) {
            throw new DeployException(RB.$((String)"ERROR_maven_central_create_bundle", (Object[])new Object[]{bundleZip.toAbsolutePath()}), (Throwable)e);
        }
    }

    private Optional<String> uploadArtifacts(MavenCentral mavenCentral, Path bundleZip) throws DeployException {
        this.context.getLogger().info(" - {}", new Object[]{bundleZip.getFileName()});
        boolean success = true;
        for (Deployable deployable : this.collectDeployableArtifacts()) {
            if (!mavenCentral.artifactExists(deployable, this.context.getModel().getProject().isSnapshot() ? null : this.getDeployer().getVerifyUrl())) continue;
            success = false;
        }
        if (!success) {
            throw new DeployException(RB.$((String)"ERROR_nexus_deploy_artifacts", (Object[])new Object[0]));
        }
        if (!this.context.isDryrun()) {
            try {
                this.context.getLogger().info(RB.$((String)"maven.central.upload.bundle", (Object[])new Object[]{bundleZip.getFileName()}));
                return Optional.of(mavenCentral.upload(bundleZip.toAbsolutePath()));
            }
            catch (MavenCentralException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{this.context.getBasedir().relativize(bundleZip), e.getMessage()}), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private String prefix(String input) {
        return "deploy" + StringUtils.capitalize((String)this.getDeployer().getType()) + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.getDeployer().getName()) + StringUtils.capitalize((String)input);
    }
}

