/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.internal.common.MatrixAware;
import org.jreleaser.model.internal.hooks.CommandHook;
import org.jreleaser.model.internal.hooks.CommandHookProvider;
import org.jreleaser.model.internal.hooks.NamedCommandHooks;

public final class CommandHooks
extends AbstractActivatable<CommandHooks>
implements Domain,
CommandHookProvider,
MatrixAware {
    private static final long serialVersionUID = -279546387946677379L;
    private final Map<String, NamedCommandHooks> groups = new LinkedHashMap<String, NamedCommandHooks>();
    private final List<CommandHook> before = new ArrayList<CommandHook>();
    private final List<CommandHook> success = new ArrayList<CommandHook>();
    private final List<CommandHook> failure = new ArrayList<CommandHook>();
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final Matrix matrix = new Matrix();
    private String condition;
    private Boolean applyDefaultMatrix;
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.CommandHooks immutable = new org.jreleaser.model.api.hooks.CommandHooks(){
        private static final long serialVersionUID = -7008621316266711034L;
        private Map<String, ? extends org.jreleaser.model.api.hooks.NamedCommandHooks> groups;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> before;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> success;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> failure;

        public String getCondition() {
            return CommandHooks.this.getCondition();
        }

        public Map<String, ? extends org.jreleaser.model.api.hooks.NamedCommandHooks> getGroups() {
            if (null == this.groups) {
                this.groups = CommandHooks.this.groups.values().stream().map(NamedCommandHooks::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.hooks.NamedCommandHooks::getName, UnaryOperator.identity()));
            }
            return this.groups;
        }

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getBefore() {
            if (null == this.before) {
                this.before = CommandHooks.this.before.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.before;
        }

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getSuccess() {
            if (null == this.success) {
                this.success = CommandHooks.this.success.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.success;
        }

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getFailure() {
            if (null == this.failure) {
                this.failure = CommandHooks.this.failure.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.failure;
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(CommandHooks.this.getEnvironment());
        }

        public boolean isApplyDefaultMatrix() {
            return CommandHooks.this.isApplyDefaultMatrix();
        }

        public org.jreleaser.model.api.common.Matrix getMatrix() {
            return CommandHooks.this.matrix.asImmutable();
        }

        public Active getActive() {
            return CommandHooks.this.getActive();
        }

        public boolean isEnabled() {
            return CommandHooks.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(CommandHooks.this.asMap(full));
        }
    };

    public CommandHooks() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.hooks.CommandHooks asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(CommandHooks source) {
        super.merge(source);
        this.condition = this.merge(this.condition, source.condition);
        this.setGroups(this.mergeModel(this.groups, source.groups));
        this.setBefore(this.merge(this.before, source.before));
        this.setSuccess(this.merge(this.success, source.success));
        this.setFailure(this.merge(this.failure, source.failure));
        this.setEnvironment(this.merge(this.environment, source.getEnvironment()));
        this.setMatrix(source.matrix);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || !this.before.isEmpty() || !this.success.isEmpty() || !this.failure.isEmpty();
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Map<String, NamedCommandHooks> getGroups() {
        return this.groups;
    }

    public void setGroups(Map<String, NamedCommandHooks> groups) {
        this.groups.clear();
        this.groups.putAll(groups);
    }

    public void addGroup(NamedCommandHooks hook) {
        this.groups.put(hook.getName(), hook);
    }

    @Override
    public List<CommandHook> getBefore() {
        return this.before;
    }

    public void setBefore(List<CommandHook> before) {
        this.before.clear();
        this.before.addAll(before);
    }

    @Override
    public List<CommandHook> getSuccess() {
        return this.success;
    }

    public void setSuccess(List<CommandHook> success) {
        this.success.clear();
        this.success.addAll(success);
    }

    @Override
    public List<CommandHook> getFailure() {
        return this.failure;
    }

    public void setFailure(List<CommandHook> failure) {
        this.failure.clear();
        this.failure.addAll(failure);
    }

    public void addBefore(CommandHook hook) {
        if (null != hook) {
            this.before.add(hook);
        }
    }

    public void addSuccess(CommandHook hook) {
        if (null != hook) {
            this.success.add(hook);
        }
    }

    public void addFailure(CommandHook hook) {
        if (null != hook) {
            this.failure.add(hook);
        }
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    @Override
    public boolean isApplyDefaultMatrixSet() {
        return null != this.applyDefaultMatrix;
    }

    @Override
    public boolean isApplyDefaultMatrix() {
        return null != this.applyDefaultMatrix && this.applyDefaultMatrix != false;
    }

    @Override
    public void setApplyDefaultMatrix(Boolean applyDefaultMatrix) {
        this.applyDefaultMatrix = applyDefaultMatrix;
    }

    @Override
    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.matrix.merge(matrix);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("condition", this.condition);
        map.put("environment", this.environment);
        this.matrix.asMap(map);
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (CommandHook hook : this.getBefore()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("before", m);
        m = new LinkedHashMap();
        i = 0;
        for (CommandHook hook : this.getSuccess()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("success", m);
        m = new LinkedHashMap();
        i = 0;
        for (CommandHook hook : this.getFailure()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("failure", m);
        List groups = this.groups.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!groups.isEmpty()) {
            map.put("groups", groups);
        }
        return map;
    }
}

