/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.project.Project;

public abstract class AbstractActivatable<S extends AbstractActivatable<S>>
extends AbstractModelObject<S>
implements Activatable,
Serializable {
    private static final long serialVersionUID = -4546036141213581709L;
    @JsonIgnore
    private boolean enabled;
    private Active active;

    @Override
    public void merge(S source) {
        this.active = this.merge(this.active, ((AbstractActivatable)source).getActive());
        this.enabled = this.merge(this.enabled, ((AbstractActivatable)source).isEnabled());
    }

    protected boolean isSet() {
        return null != this.active;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    @Override
    public boolean resolveEnabledWithSnapshot(Project project) {
        boolean bl = this.enabled = null != this.active && this.active.check((Active.Releaseable)project);
        if (project.isSnapshot() && !this.isSnapshotSupported()) {
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public boolean resolveEnabled(Project project) {
        this.enabled = null != this.active && this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return null != this.active;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    protected void enabledSet(boolean enabled) {
        this.enabled = enabled;
    }
}

