/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.assemble.DebAssembler;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.validation.assemble.ArchiveAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.JavaArchiveAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.JlinkAssemblerResolver;
import org.jreleaser.model.internal.validation.assemble.NativeImageAssemblerResolver;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class DebAssemblerProcessor
extends AbstractAssemblerProcessor<DebAssembler, org.jreleaser.model.internal.assemble.DebAssembler> {
    private static final String CONTROL_DIRECTORY = "control";
    private static final String CONTROL_TAR_ZST = "control.tar.zst";
    private static final String DATA_DIRECTORY = "data";
    private static final String DATA_TAR_ZST = "data.tar.zst";
    private static final String DEBIAN_BINARY = "debian-binary";

    public DebAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void fillAssemblerProperties(TemplateContext props) {
        super.fillAssemblerProperties(props);
        props.set("distributionExecutableUnix", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getExecutable());
        props.set("debInstallationPath", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getResolvedInstallationPath(props));
        props.set("debControlPackage", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPackageName());
        props.set("debControlVersion", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPackageVersion());
        props.set("debControlRevision", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPackageRevision());
        props.set("debControlProvides", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getProvides());
        props.set("debControlMaintainer", (Object)MustacheUtils.passThrough((String)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getMaintainer()));
        props.set("debControlSection", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getSection().value());
        props.set("debControlPriority", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPriority().value());
        props.set("debControlEssential", (Object)(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().isEssential() != false ? "yes" : "no"));
        props.set("debControlDescription", (Object)MustacheUtils.passThrough((String)Arrays.stream(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getDescription().split("\n")).filter(StringUtils::isNotBlank).collect(Collectors.joining("\n "))));
        props.set("debControlHomepage", (Object)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getHomepage());
        props.set("debControlBuiltUsing", (Object)MustacheUtils.passThrough((String)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getBuiltUsing()));
        props.set("debControlHasDepends", (Object)(!((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getDepends().isEmpty() ? 1 : 0));
        props.set("debControlHasPreDepends", (Object)(!((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPreDepends().isEmpty() ? 1 : 0));
        props.set("debControlHasPreDepends", (Object)(!((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getRecommends().isEmpty() ? 1 : 0));
        props.set("debControlHasPreDepends", (Object)(!((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getSuggests().isEmpty() ? 1 : 0));
        props.set("debControlHasPreDepends", (Object)(!((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getEnhances().isEmpty() ? 1 : 0));
        props.set("debControlHasPreDepends", (Object)(!((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getBreaks().isEmpty() ? 1 : 0));
        props.set("debControlHasPreDepends", (Object)(!((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getConflicts().isEmpty() ? 1 : 0));
        props.set("debControlDepends", (Object)this.formatDependencies(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getDepends()));
        props.set("debControlPreDepends", (Object)this.formatDependencies(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPreDepends()));
        props.set("debControlPreDepends", (Object)this.formatDependencies(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getRecommends()));
        props.set("debControlPreDepends", (Object)this.formatDependencies(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getSuggests()));
        props.set("debControlPreDepends", (Object)this.formatDependencies(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getEnhances()));
        props.set("debControlPreDepends", (Object)this.formatDependencies(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getBreaks()));
        props.set("debControlPreDepends", (Object)this.formatDependencies(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getConflicts()));
    }

    private String formatDependencies(Set<String> dependencies) {
        return MustacheUtils.passThrough((String)String.join((CharSequence)",\n ", dependencies));
    }

    @Override
    protected void doAssemble(TemplateContext props) throws AssemblerProcessingException {
        String assemblerRef = ((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getAssemblerRef();
        if (StringUtils.isNotBlank((String)assemblerRef)) {
            Assembler<?> assemblerReference = this.resolveAssemblerReference(assemblerRef.trim());
            for (Artifact artifact : assemblerReference.getOutputs()) {
                this.assembleDebianArtifact(props, artifact);
            }
        } else {
            this.assembleDebianArtifact(props, null);
        }
    }

    private void assembleDebianArtifact(TemplateContext props, Artifact artifact) throws AssemblerProcessingException {
        String architecture;
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path workDirectory = assembleDirectory.resolve("work");
        String string = architecture = StringUtils.isNotBlank((String)((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getArchitecture()) ? ((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getArchitecture().trim() : "all";
        if (null != artifact) {
            String platform = artifact.getPlatform();
            if (StringUtils.isBlank((String)platform)) {
                architecture = "all";
            } else if (PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel64((String)platform)) {
                architecture = "amd64";
            } else if (PlatformUtils.isLinux((String)platform) && PlatformUtils.isArm64((String)platform)) {
                architecture = "arm64";
            } else {
                this.context.getLogger().debug(RB.$((String)"assemble.deb.unsupported.artifact", (Object[])new Object[]{platform}));
                return;
            }
        }
        Path architectureDirectory = workDirectory.resolve(architecture);
        Path dataDirectory = architectureDirectory.resolve(DATA_DIRECTORY);
        try {
            Files.createDirectories(dataDirectory, new FileAttribute[0]);
            if (null != artifact) {
                org.jreleaser.util.FileUtils.unpackArchive((Path)artifact.getResolvedPath(this.context, this.assembler), (Path)dataDirectory);
            }
            props.set("debControlArchitecture", (Object)architecture);
            this.context.getLogger().debug(RB.$((String)"assembler.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(dataDirectory)});
            this.copyFiles(this.context, dataDirectory);
            this.copyFileSets(this.context, dataDirectory);
            long size = FileUtils.sizeOfDirectory((File)dataDirectory.toFile()) / 1024L;
            props.set("debControlInstalledSize", (Object)String.valueOf(size));
            this.copyTemplates(this.context, props, architectureDirectory);
            this.createControlArchive(props, architectureDirectory);
            this.createDataArchive(props, architectureDirectory);
            this.createDebArchive(props, architectureDirectory);
        }
        catch (IOException ioe) {
            throw new AssemblerProcessingException((Throwable)ioe);
        }
    }

    private void createControlArchive(TemplateContext props, Path architectureDirectory) throws AssemblerProcessingException {
        Path controlDirectory = architectureDirectory.resolve(CONTROL_DIRECTORY);
        try {
            org.jreleaser.util.FileUtils.packArchive((Path)controlDirectory, (Path)architectureDirectory.resolve(CONTROL_TAR_ZST), (FileUtils.ArchiveOptions)new FileUtils.ArchiveOptions().withTimestamp(this.context.getModel().resolveArchiveTimestamp()));
        }
        catch (IOException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
    }

    private void createDataArchive(TemplateContext props, Path architectureDirectory) throws AssemblerProcessingException {
        Path dataDirectory = architectureDirectory.resolve(DATA_DIRECTORY);
        try {
            org.jreleaser.util.FileUtils.packArchive((Path)dataDirectory, (Path)architectureDirectory.resolve(DATA_TAR_ZST), (FileUtils.ArchiveOptions)new FileUtils.ArchiveOptions().withTimestamp(this.context.getModel().resolveArchiveTimestamp()).withRootEntryName(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getResolvedInstallationPath(props)).withCreateIntermediateDirs(true));
        }
        catch (IOException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
    }

    private void createDebArchive(TemplateContext props, Path architectureDirectory) throws AssemblerProcessingException {
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path debianBinaryPath = architectureDirectory.resolve(DEBIAN_BINARY);
        try {
            Files.deleteIfExists(debianBinaryPath);
            Path debianBinaryFile = Files.createFile(debianBinaryPath, new FileAttribute[0]);
            Files.write(debianBinaryFile, "2.0\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
        Path debianPackage = assembleDirectory.resolve(((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPackageName() + "-" + ((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPackageVersion() + "-" + ((org.jreleaser.model.internal.assemble.DebAssembler)this.assembler).getControl().getPackageRevision() + "_" + props.get("debControlArchitecture") + ".deb");
        this.context.getLogger().info("- {}", new Object[]{debianPackage.getFileName()});
        try {
            Files.deleteIfExists(debianPackage);
            org.jreleaser.util.FileUtils.ar((Path)architectureDirectory, (Path)debianPackage, (FileUtils.ArchiveOptions)new FileUtils.ArchiveOptions().withTimestamp(this.context.getModel().resolveArchiveTimestamp()).withLongFileMode(FileUtils.ArchiveOptions.TarMode.POSIX).withIncludedPath(debianBinaryPath).withIncludedPath(architectureDirectory.resolve(CONTROL_TAR_ZST)).withIncludedPath(architectureDirectory.resolve(DATA_TAR_ZST)));
        }
        catch (IOException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
    }

    private Assembler<?> resolveAssemblerReference(String assemblerName) throws AssemblerProcessingException {
        Assembler assemblerReference = this.context.getModel().getAssemble().findAssembler(assemblerName);
        Errors errors = new Errors();
        if (assemblerReference instanceof ArchiveAssembler) {
            ArchiveAssemblerResolver.resolveArchiveOutputs((JReleaserContext)this.context, (ArchiveAssembler)((ArchiveAssembler)assemblerReference), (Errors)errors);
        } else if (assemblerReference instanceof JavaArchiveAssembler) {
            JavaArchiveAssemblerResolver.resolveJavaArchiveOutputs((JReleaserContext)this.context, (JavaArchiveAssembler)((JavaArchiveAssembler)assemblerReference), (Errors)errors);
        } else if (assemblerReference instanceof JlinkAssembler) {
            JlinkAssemblerResolver.resolveJlinkOutputs((JReleaserContext)this.context, (JlinkAssembler)((JlinkAssembler)assemblerReference), (Errors)errors);
        } else if (assemblerReference instanceof NativeImageAssembler) {
            NativeImageAssemblerResolver.resolveNativeImageOutputs((JReleaserContext)this.context, (NativeImageAssembler)((NativeImageAssembler)assemblerReference), (Errors)errors);
        }
        if (errors.hasErrors()) {
            throw new AssemblerProcessingException(errors.asString());
        }
        return assemblerReference;
    }
}

