/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.release;

import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.release.GithubReleaser;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.release.BaseReleaserValidator;
import org.jreleaser.util.Errors;

public final class GithubReleaserValidator {
    private GithubReleaserValidator() {
    }

    public static boolean validateGithub(JReleaserContext context, JReleaserContext.Mode mode, GithubReleaser service, Errors errors) {
        if (null == service) {
            return false;
        }
        context.getLogger().debug("release.github");
        BaseReleaserValidator.validateGitService(context, mode, service, errors);
        if (context.getModel().getProject().isSnapshot()) {
            service.getPrerelease().setEnabled(true);
        }
        service.getPrerelease().setPattern(Validator.checkProperty(context, "PRERELEASE_PATTERN", "release.github.prerelease.pattern", service.getPrerelease().getPattern(), ""));
        service.getPrerelease().isPrerelease(context.getModel().getProject().getResolvedVersion());
        service.setMakeLatest(Validator.checkProperty(context, "MAKE_LATEST", "release.github.make.latest", service.getMakeLatest(), GithubReleaser.MakeLatest.TRUE));
        if (!service.isDraftSet()) {
            service.setDraft(Validator.checkProperty(context, "DRAFT", "release.github.draft", null, false));
        }
        if (!service.getUpdate().isEnabled()) {
            if (!service.getPrerelease().isEnabledSet()) {
                service.getPrerelease().setEnabled(false);
            }
            if (!service.isDraftSet()) {
                service.setDraft(false);
            }
        }
        if (service.isDraft()) {
            service.getMilestone().setClose(false);
        }
        return service.isEnabled();
    }
}

