/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.Nexus3MavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class Nexus3MavenDeployerValidator {
    private Nexus3MavenDeployerValidator() {
    }

    public static void validateNexus3MavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, Nexus3MavenDeployer> nexus3 = context.getModel().getDeploy().getMaven().getNexus3();
        if (!nexus3.isEmpty()) {
            context.getLogger().debug("deploy.maven.nexus3");
        }
        for (Map.Entry<String, Nexus3MavenDeployer> e : nexus3.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            Errors incoming = new Errors();
            Nexus3MavenDeployerValidator.validateNexus3MavenDeployer(context, e.getValue(), incoming);
            Validator.mergeErrors(context, errors, incoming, e.getValue());
        }
    }

    private static void validateNexus3MavenDeployer(JReleaserContext context, Nexus3MavenDeployer mavenDeployer, Errors errors) {
        MavenDeployersValidator.validateMavenDeployer(context, mavenDeployer, errors);
        if (!mavenDeployer.isEnabled()) {
            return;
        }
        if (StringUtils.isBlank((String)context.getModel().getProject().getLanguages().getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.groupId"}));
        }
        mavenDeployer.setChecksums(false);
    }
}

