/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.assemble;

import java.util.Locale;
import java.util.Set;
import org.jreleaser.model.api.assemble.Assembler;
import org.jreleaser.model.api.common.Domain;
import org.jreleaser.util.StringUtils;

public interface DebAssembler
extends Assembler {
    public static final String TYPE = "deb";

    public String getExecutable();

    public String getInstallationPath();

    public String getArchitecture();

    public Control getControl();

    public String getAssemblerRef();

    public static enum Priority {
        REQUIRED,
        IMPORTANT,
        STANDARD,
        OPTIONAL;


        public String value() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Priority of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Priority.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }

    public static enum Section {
        ADMIN("admin"),
        CLI_MONO("cli-mono"),
        COMM("comm"),
        DATABASE("database"),
        DEBUG("debug"),
        DEVEL("devel"),
        DOC("doc"),
        EDITORS("editors"),
        EDUCATION("education"),
        ELECTRONICS("electronics"),
        EMBEDDED("embedded"),
        FONTS("fonts"),
        GAMES("games"),
        GNOME("gnome"),
        GNU_R("gnu-r"),
        GNUSTEP("gnustep"),
        GRAPHICS("graphics"),
        HAMRADIO("hamradio"),
        HASKELL("haskell"),
        HTTPD("httpd"),
        INTERPRETERS("interpreters"),
        INTROSPECTION("introspection"),
        JAVA("java"),
        JAVASCRIPT("javascript"),
        KDE("kde"),
        KERNEL("kernel"),
        LIBDEVEL("libdevel"),
        LIBS("libs"),
        LISP("lisp"),
        LOCALIZATION("localization"),
        MAIL("mail"),
        MATH("math"),
        METAPACKAGES("metapackages"),
        MISC("misc"),
        NET("net"),
        NEWS("news"),
        OCAML("ocaml"),
        OLDLIBS("oldlibs"),
        OTHEROSFS("otherosfs"),
        PERL("perl"),
        PHP("php"),
        PYTHON("python"),
        RUBY("ruby"),
        RUST("rust"),
        SCIENCE("science"),
        SHELLS("shells"),
        SOUND("sound"),
        TASKS("tasks"),
        TEX("tex"),
        TEXT("text"),
        UTILS("utils"),
        VCS("vcs"),
        VIDEO("video"),
        WEB("web"),
        X11("x11"),
        XFCE("xfce"),
        ZOPE("zope");

        private final String value;

        private Section(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Section of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Section.valueOf(str.toUpperCase(Locale.ENGLISH).trim().replace("-", "_"));
        }
    }

    public static interface Control
    extends Domain {
        public String getPackageName();

        public String getPackageVersion();

        public Integer getPackageRevision();

        public String getProvides();

        public String getMaintainer();

        public Section getSection();

        public Priority getPriority();

        public boolean isEssential();

        public String getDescription();

        public String getHomepage();

        public String getBuiltUsing();

        public Set<String> getDepends();

        public Set<String> getPreDepends();

        public Set<String> getRecommends();

        public Set<String> getSuggests();

        public Set<String> getEnhances();

        public Set<String> getBreaks();

        public Set<String> getConflicts();
    }
}

