/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.Token;

public class Braces
extends TokenRule {
    public static final String OPTION_FORBID = "forbid";
    public static final String OPTION_MIN_SPACES_INSIDE = "min-spaces-inside";
    public static final String OPTION_MAX_SPACES_INSIDE = "max-spaces-inside";
    public static final String OPTION_MIN_SPACES_INSIDE_EMPTY = "min-spaces-inside-empty";
    public static final String OPTION_MAX_SPACES_INSIDE_EMPTY = "max-spaces-inside-empty";

    public Braces() {
        this.registerOption(OPTION_FORBID, Arrays.asList(Boolean.class, "non-empty"), false);
        this.registerOption(OPTION_MIN_SPACES_INSIDE, 0);
        this.registerOption(OPTION_MAX_SPACES_INSIDE, 0);
        this.registerOption(OPTION_MIN_SPACES_INSIDE_EMPTY, -1);
        this.registerOption(OPTION_MAX_SPACES_INSIDE_EMPTY, -1);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        if (Boolean.TRUE.equals(conf.get(OPTION_FORBID)) && token instanceof FlowMappingStartToken || "non-empty".equals(conf.get(OPTION_FORBID)) && token instanceof FlowMappingStartToken && !(next instanceof FlowMappingEndToken)) {
            return Collections.singletonList(new LintProblem(token.getStartMark().getLine() + 1, token.getEndMark().getColumn() + 1, "forbidden flow mapping"));
        }
        LintProblem problem = null;
        if (token instanceof FlowMappingStartToken && next instanceof FlowMappingEndToken) {
            problem = this.spacesAfter(token, next, (int)((Integer)((Integer)conf.get(OPTION_MIN_SPACES_INSIDE_EMPTY) != -1 ? conf.get(OPTION_MIN_SPACES_INSIDE_EMPTY) : conf.get(OPTION_MIN_SPACES_INSIDE))), (int)((Integer)((Integer)conf.get(OPTION_MAX_SPACES_INSIDE_EMPTY) != -1 ? conf.get(OPTION_MAX_SPACES_INSIDE_EMPTY) : conf.get(OPTION_MAX_SPACES_INSIDE))), "too few spaces inside empty braces", "too many spaces inside empty braces");
        } else if (token instanceof FlowMappingStartToken) {
            problem = this.spacesAfter(token, next, (int)((Integer)conf.get(OPTION_MIN_SPACES_INSIDE)), (int)((Integer)conf.get(OPTION_MAX_SPACES_INSIDE)), "too few spaces inside braces", "too many spaces inside braces");
        } else if (token instanceof FlowMappingEndToken && !(prev instanceof FlowMappingStartToken)) {
            problem = this.spacesBefore(token, prev, (int)((Integer)conf.get(OPTION_MIN_SPACES_INSIDE)), (int)((Integer)conf.get(OPTION_MAX_SPACES_INSIDE)), "too few spaces inside braces", "too many spaces inside braces");
        }
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (problem != null) {
            problems.add(problem);
        }
        return problems;
    }
}

