/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.util.JReleaserOutput;

public class Gitlab
extends GitService<Gitlab> {
    public static final String NAME = "gitlab";
    public static final String SKIP_GITLAB_LINKS = "skipGitlabLinks";
    private final Map<String, String> uploadLinks = new LinkedHashMap<String, String>();
    private String projectIdentifier;

    public Gitlab() {
        super(NAME, true);
        this.setHost("gitlab.com");
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/blob/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/releases/{{tagName}}/downloads/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/releases/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/releases/permalink/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/issues");
    }

    @Override
    public void merge(Gitlab service) {
        this.freezeCheck();
        super.merge(service);
        this.projectIdentifier = this.merge(this.projectIdentifier, service.projectIdentifier);
        this.setUploadLinks(this.merge(this.uploadLinks, service.uploadLinks));
    }

    @Override
    public String getReverseRepoHost() {
        return "com.gitlab";
    }

    @Deprecated
    public String getIdentifier() {
        return this.getProjectIdentifier();
    }

    @Deprecated
    public void setIdentifier(String identifier) {
        JReleaserOutput.nag((String)"gitlab.identifier is deprecated since 1.2.0 and will be removed in 2.0.0. Use gitlab.projectIdentifier instead");
        this.setProjectIdentifier(identifier);
    }

    public String getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public void setProjectIdentifier(String projectIdentifier) {
        this.freezeCheck();
        this.projectIdentifier = projectIdentifier;
    }

    public Map<String, String> getUploadLinks() {
        return this.freezeWrap(this.uploadLinks);
    }

    public void setUploadLinks(Map<String, String> uploadLinks) {
        this.freezeCheck();
        this.uploadLinks.clear();
        this.uploadLinks.putAll(uploadLinks);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("projectIdentifier", this.projectIdentifier);
        map.put("uploadLinks", this.uploadLinks);
        return map;
    }

    @Override
    public Map<String, Object> props(JReleaserModel model) {
        Map<String, Object> props = super.props(model);
        props.put("identifier", this.projectIdentifier);
        props.put("projectIdentifier", this.projectIdentifier);
        return props;
    }
}

