/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractDockerConfiguration;
import org.jreleaser.model.Artifact;
import org.jreleaser.util.PlatformUtils;

public class DockerSpec
extends AbstractDockerConfiguration<DockerSpec> {
    private final Map<String, Object> matchers = new LinkedHashMap<String, Object>();
    private Artifact artifact;
    private String name;

    @Override
    public void freeze() {
        super.freeze();
        if (null != this.artifact) {
            this.artifact.freeze();
        }
    }

    @Override
    public void merge(DockerSpec docker) {
        this.freezeCheck();
        super.merge(docker);
        this.name = this.merge(this.name, docker.name);
        this.artifact = docker.artifact;
        this.setMatchers(this.merge(this.matchers, docker.matchers));
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.freezeCheck();
        this.artifact = artifact;
        this.artifact.activate();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.freezeCheck();
        this.name = name;
    }

    public Map<String, Object> getMatchers() {
        return this.freezeWrap(this.matchers);
    }

    public void setMatchers(Map<String, Object> matchers) {
        this.freezeCheck();
        this.matchers.putAll(matchers);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> props = super.asMap(full);
        if (!props.isEmpty()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, props);
            return map;
        }
        return props;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("matchers", this.matchers);
        if (this.artifact != null) {
            props.put("artifact", this.artifact.asMap(full));
        }
    }

    public boolean matches(Artifact artifact) {
        boolean matched = true;
        for (Map.Entry<String, Object> e : this.matchers.entrySet()) {
            String key = e.getKey();
            if ("platform".equals(key)) {
                matched &= PlatformUtils.isCompatible((String)String.valueOf(e.getValue()), (String)artifact.getPlatform());
                continue;
            }
            if (!artifact.getExtraProperties().containsKey(key)) continue;
            matched &= e.getValue().equals(artifact.getExtraProperties().get(key));
        }
        return matched;
    }
}

